rule win_reactorbot_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.reactorbot."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.reactorbot"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { ff15???????? c705????????00000000 c705????????01000000 5d c3 }
            // n = 5, score = 900
            //   ff15????????         |                     
            //   c705????????00000000     |     
            //   c705????????01000000     |     
            //   5d                   | pop                 ebp
            //   c3                   | ret                 

        $sequence_1 = { 52 e8???????? 8d85bcfdffff 50 6804010000 8d8d88fbffff }
            // n = 6, score = 900
            //   52                   | push                edx
            //   e8????????           |                     
            //   8d85bcfdffff         | lea                 eax, [ebp - 0x244]
            //   50                   | push                eax
            //   6804010000           | push                0x104
            //   8d8d88fbffff         | lea                 ecx, [ebp - 0x478]

        $sequence_2 = { 8d4de8 51 ff15???????? 8945f8 }
            // n = 4, score = 900
            //   8d4de8               | lea                 ecx, [ebp - 0x18]
            //   51                   | push                ecx
            //   ff15????????         |                     
            //   8945f8               | mov                 dword ptr [ebp - 8], eax

        $sequence_3 = { 894dfc 8b55fc a1???????? 8982b8000000 }
            // n = 4, score = 900
            //   894dfc               | mov                 dword ptr [ebp - 4], ecx
            //   8b55fc               | mov                 edx, dword ptr [ebp - 4]
            //   a1????????           |                     
            //   8982b8000000         | mov                 dword ptr [edx + 0xb8], eax

        $sequence_4 = { 51 ff15???????? c745f801000000 8b45f8 }
            // n = 4, score = 900
            //   51                   | push                ecx
            //   ff15????????         |                     
            //   c745f801000000       | mov                 dword ptr [ebp - 8], 1
            //   8b45f8               | mov                 eax, dword ptr [ebp - 8]

        $sequence_5 = { 51 ff15???????? 8945fc 837dfc00 7479 }
            // n = 5, score = 900
            //   51                   | push                ecx
            //   ff15????????         |                     
            //   8945fc               | mov                 dword ptr [ebp - 4], eax
            //   837dfc00             | cmp                 dword ptr [ebp - 4], 0
            //   7479                 | je                  0x7b

        $sequence_6 = { 50 ff15???????? 83c408 c745f401000000 8b45f4 }
            // n = 5, score = 900
            //   50                   | push                eax
            //   ff15????????         |                     
            //   83c408               | add                 esp, 8
            //   c745f401000000       | mov                 dword ptr [ebp - 0xc], 1
            //   8b45f4               | mov                 eax, dword ptr [ebp - 0xc]

        $sequence_7 = { 6804010000 8d8d80f9ffff 51 e8???????? }
            // n = 4, score = 900
            //   6804010000           | push                0x104
            //   8d8d80f9ffff         | lea                 ecx, [ebp - 0x680]
            //   51                   | push                ecx
            //   e8????????           |                     

        $sequence_8 = { 6bc005 83e803 99 b999000000 }
            // n = 4, score = 400
            //   6bc005               | imul                eax, eax, 5
            //   83e803               | sub                 eax, 3
            //   99                   | cdq                 
            //   b999000000           | mov                 ecx, 0x99

        $sequence_9 = { 83c005 99 b905000000 f7f9 }
            // n = 4, score = 400
            //   83c005               | add                 eax, 5
            //   99                   | cdq                 
            //   b905000000           | mov                 ecx, 5
            //   f7f9                 | idiv                ecx

        $sequence_10 = { ff15???????? e8???????? 833d????????00 7509 833d????????00 }
            // n = 5, score = 400
            //   ff15????????         |                     
            //   e8????????           |                     
            //   833d????????00       |                     
            //   7509                 | jne                 0xb
            //   833d????????00       |                     

        $sequence_11 = { 69c0b13a0200 99 83e203 03c2 }
            // n = 4, score = 400
            //   69c0b13a0200         | imul                eax, eax, 0x23ab1
            //   99                   | cdq                 
            //   83e203               | and                 edx, 3
            //   03c2                 | add                 eax, edx

        $sequence_12 = { 7402 eb0c c705????????b80b0000 eb0a c705????????e8030000 }
            // n = 5, score = 400
            //   7402                 | je                  4
            //   eb0c                 | jmp                 0xe
            //   c705????????b80b0000     |     
            //   eb0a                 | jmp                 0xc
            //   c705????????e8030000     |     

        $sequence_13 = { 83e101 f7d9 81e12083b8ed 33c1 }
            // n = 4, score = 400
            //   83e101               | and                 ecx, 1
            //   f7d9                 | neg                 ecx
            //   81e12083b8ed         | and                 ecx, 0xedb88320
            //   33c1                 | xor                 eax, ecx

        $sequence_14 = { ba2f000000 488d4c2440 ff15???????? 4889442420 48837c242000 }
            // n = 5, score = 200
            //   ba2f000000           | mov                 edx, 0x2f
            //   488d4c2440           | dec                 eax
            //   ff15????????         |                     
            //   4889442420           | lea                 ecx, [esp + 0x40]
            //   48837c242000         | dec                 eax

        $sequence_15 = { 488b442468 813850450000 0f859f030000 488b442468 4883c018 }
            // n = 5, score = 200
            //   488b442468           | mov                 dword ptr [esp + 0x20], eax
            //   813850450000         | dec                 eax
            //   0f859f030000         | cmp                 dword ptr [esp + 0x20], 0
            //   488b442468           | dec                 eax
            //   4883c018             | mov                 eax, dword ptr [esp + 0x68]

    condition:
        7 of them and filesize < 1032192
}