rule win_redalpha_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.redalpha."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.redalpha"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 8bc1 b900000000 2bde 7414 8b55fc 03d6 }
            // n = 6, score = 400
            //   8bc1                 | mov                 esi, 0x40
            //   b900000000           | shr                 eax, 0x1d
            //   2bde                 | sub                 esi, ecx
            //   7414                 | jb                  0x58
            //   8b55fc               | xor                 ecx, ecx
            //   03d6                 | test                esi, esi

        $sequence_1 = { 2bc2 83fa38 ba???????? 0f42c1 }
            // n = 4, score = 400
            //   2bc2                 | dec                 eax
            //   83fa38               | add                 esp, 0x440
            //   ba????????           |                     
            //   0f42c1               | inc                 ecx

        $sequence_2 = { 33c0 eb04 33f6 8bc1 }
            // n = 4, score = 400
            //   33c0                 | cmp                 ecx, esi
            //   eb04                 | jb                  0xfffffff9
            //   33f6                 | cmp                 ecx, esi
            //   8bc1                 | jb                  0xfffffff6

        $sequence_3 = { 8bc8 c1e903 83e13f 894df4 8d14d8 }
            // n = 5, score = 400
            //   8bc8                 | mov                 ebx, dword ptr [ebp - 4]
            //   c1e903               | add                 edx, edi
            //   83e13f               | mov                 al, byte ptr [ecx + ebx]
            //   894df4               | mov                 byte ptr [edx + ecx + 0x18], al
            //   8d14d8               | inc                 ecx

        $sequence_4 = { 7256 33c9 85f6 7417 8b55f4 }
            // n = 5, score = 400
            //   7256                 | movzx               eax, word ptr [esp + 0x1e4]
            //   33c9                 | mov                 word ptr [ebx + 0x14c], ax
            //   85f6                 | mov                 byte ptr [ebx + 0x14e], 0x74
            //   7417                 | xor                 eax, eax
            //   8b55f4               | dec                 eax

        $sequence_5 = { 3bce 72f4 8b5d08 8d5718 }
            // n = 4, score = 400
            //   3bce                 | mov                 ecx, ebp
            //   72f4                 | inc                 esp
            //   8b5d08               | lea                 eax, [edx + 5]
            //   8d5718               | sub                 eax, edx

        $sequence_6 = { 8b5dfc 03d7 8a0419 88440a18 41 3bce 72f4 }
            // n = 7, score = 400
            //   8b5dfc               | mov                 dword ptr [ebp - 0x20], esp
            //   03d7                 | xor                 edx, edx
            //   8a0419               | inc                 esp
            //   88440a18             | lea                 eax, [eax + 0x60]
            //   41                   | dec                 eax
            //   3bce                 | mov                 dword ptr [esp + 0x98], ebp
            //   72f4                 | mov                 ebp, 2

        $sequence_7 = { ff4714 8bc3 be40000000 c1e81d 2bf1 }
            // n = 5, score = 400
            //   ff4714               | test                ebx, edx
            //   8bc3                 | je                  0xe
            //   be40000000           | nop                 dword ptr [eax + eax]
            //   c1e81d               | shr                 edx, 1
            //   2bf1                 | mov                 dword ptr [ebx + 0x148], eax

        $sequence_8 = { 413bfb 72d8 448b4d88 488b7d68 }
            // n = 4, score = 300
            //   413bfb               | dec                 eax
            //   72d8                 | mov                 edi, eax
            //   448b4d88             | je                  0xa3
            //   488b7d68             | dec                 eax

        $sequence_9 = { 7d09 0fb685443b0100 ebe1 80bd443b010000 }
            // n = 4, score = 300
            //   7d09                 | mov                 edi, dword ptr [ecx + 0x28]
            //   0fb685443b0100       | dec                 eax
            //   ebe1                 | test                edi, edi
            //   80bd443b010000       | je                  0x99

        $sequence_10 = { ff15???????? 488bc8 488d542460 ff15???????? 488bf8 }
            // n = 5, score = 300
            //   ff15????????         |                     
            //   488bc8               | lea                 eax, [esp + 0x78]
            //   488d542460           | dec                 eax
            //   ff15????????         |                     
            //   488bf8               | lea                 edx, [edi + 0x38]

        $sequence_11 = { c744247818000000 4c896580 c7458801000000 4533c9 4c8d442478 488d5738 488d4f20 }
            // n = 7, score = 300
            //   c744247818000000     | mov                 dword ptr [esp + 0x78], 0x18
            //   4c896580             | dec                 esp
            //   c7458801000000       | mov                 dword ptr [ebp - 0x80], esp
            //   4533c9               | mov                 dword ptr [ebp - 0x78], 1
            //   4c8d442478           | inc                 ebp
            //   488d5738             | xor                 ecx, ecx
            //   488d4f20             | dec                 esp

        $sequence_12 = { 458bc6 498bcd e8???????? 488b9c2498040000 4881c440040000 }
            // n = 5, score = 300
            //   458bc6               | cmp                 edi, ebx
            //   498bcd               | jb                  0xffffffdd
            //   e8????????           |                     
            //   488b9c2498040000     | inc                 esp
            //   4881c440040000       | mov                 ecx, dword ptr [ebp - 0x78]

        $sequence_13 = { 4185d3 740c 0f1f440000 d1ea }
            // n = 4, score = 300
            //   4185d3               | dec                 eax
            //   740c                 | mov                 edi, dword ptr [ebp + 0x68]
            //   0f1f440000           | jge                 0xb
            //   d1ea                 | movzx               eax, byte ptr [ebp + 0x13b44]

        $sequence_14 = { 488b4c2440 ff15???????? 90 488d8c2460010000 e8???????? 8bc3 }
            // n = 6, score = 300
            //   488b4c2440           | dec                 eax
            //   ff15????????         |                     
            //   90                   | cmp                 dword ptr [ecx + 0x30], 0
            //   488d8c2460010000     | je                  0x99
            //   e8????????           |                     
            //   8bc3                 | inc                 ecx

        $sequence_15 = { 0f849d000000 488b7928 4885ff 0f8490000000 4883793000 0f8485000000 }
            // n = 6, score = 300
            //   0f849d000000         | dec                 eax
            //   488b7928             | lea                 ecx, [edi + 0x20]
            //   4885ff               | dec                 eax
            //   0f8490000000         | mov                 ecx, eax
            //   4883793000           | dec                 eax
            //   0f8485000000         | lea                 edx, [esp + 0x60]

        $sequence_16 = { 740b 83feff 0f8483000000 eb7d 8b1c9dc4f24000 6800080000 6a00 }
            // n = 7, score = 100
            //   740b                 | je                  0xd
            //   83feff               | cmp                 esi, -1
            //   0f8483000000         | je                  0x89
            //   eb7d                 | jmp                 0x7f
            //   8b1c9dc4f24000       | mov                 ebx, dword ptr [ebx*4 + 0x40f2c4]
            //   6800080000           | push                0x800
            //   6a00                 | push                0

        $sequence_17 = { 837de404 7412 8d45e0 50 56 ff15???????? }
            // n = 6, score = 100
            //   837de404             | cmp                 dword ptr [ebp - 0x1c], 4
            //   7412                 | je                  0x14
            //   8d45e0               | lea                 eax, [ebp - 0x20]
            //   50                   | push                eax
            //   56                   | push                esi
            //   ff15????????         |                     

        $sequence_18 = { 897c2428 e8???????? 83c410 8d442424 }
            // n = 4, score = 100
            //   897c2428             | mov                 dword ptr [esp + 0x28], edi
            //   e8????????           |                     
            //   83c410               | add                 esp, 0x10
            //   8d442424             | lea                 eax, [esp + 0x24]

        $sequence_19 = { 7420 6bc618 57 8db8f06f4100 57 }
            // n = 5, score = 100
            //   7420                 | je                  0x22
            //   6bc618               | imul                eax, esi, 0x18
            //   57                   | push                edi
            //   8db8f06f4100         | lea                 edi, [eax + 0x416ff0]
            //   57                   | push                edi

        $sequence_20 = { 8b04bd30744100 f644032801 7444 837c0318ff 743d }
            // n = 5, score = 100
            //   8b04bd30744100       | mov                 eax, dword ptr [edi*4 + 0x417430]
            //   f644032801           | test                byte ptr [ebx + eax + 0x28], 1
            //   7444                 | je                  0x46
            //   837c0318ff           | cmp                 dword ptr [ebx + eax + 0x18], -1
            //   743d                 | je                  0x3f

        $sequence_21 = { 8d45f4 64a300000000 683f000f00 6a00 6a00 }
            // n = 5, score = 100
            //   8d45f4               | lea                 eax, [ebp - 0xc]
            //   64a300000000         | mov                 dword ptr fs:[0], eax
            //   683f000f00           | push                0xf003f
            //   6a00                 | push                0
            //   6a00                 | push                0

        $sequence_22 = { 7313 8a8750604100 08441619 42 0fb64101 3bd0 }
            // n = 6, score = 100
            //   7313                 | jae                 0x15
            //   8a8750604100         | mov                 al, byte ptr [edi + 0x416050]
            //   08441619             | or                  byte ptr [esi + edx + 0x19], al
            //   42                   | inc                 edx
            //   0fb64101             | movzx               eax, byte ptr [ecx + 1]
            //   3bd0                 | cmp                 edx, eax

        $sequence_23 = { ff75f8 ff15???????? 837de404 7412 8d45e0 }
            // n = 5, score = 100
            //   ff75f8               | push                dword ptr [ebp - 8]
            //   ff15????????         |                     
            //   837de404             | cmp                 dword ptr [ebp - 0x1c], 4
            //   7412                 | je                  0x14
            //   8d45e0               | lea                 eax, [ebp - 0x20]

    condition:
        7 of them and filesize < 606208
}