rule win_redcurl_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.redcurl."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.redcurl"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 99 b91a000000 f7f9 80c261 88143e 47 }
            // n = 6, score = 400
            //   99                   | cdq                 
            //   b91a000000           | mov                 ecx, 0x1a
            //   f7f9                 | idiv                ecx
            //   80c261               | add                 dl, 0x61
            //   88143e               | mov                 byte ptr [esi + edi], dl
            //   47                   | inc                 edi

        $sequence_1 = { 2bc6 48 50 56 }
            // n = 4, score = 400
            //   2bc6                 | sub                 eax, esi
            //   48                   | dec                 eax
            //   50                   | push                eax
            //   56                   | push                esi

        $sequence_2 = { c745f000000000 ff15???????? 8bd0 c7461000000000 8bca c746140f000000 c60600 }
            // n = 7, score = 400
            //   c745f000000000       | mov                 dword ptr [ebp - 0x10], 0
            //   ff15????????         |                     
            //   8bd0                 | mov                 edx, eax
            //   c7461000000000       | mov                 dword ptr [esi + 0x10], 0
            //   8bca                 | mov                 ecx, edx
            //   c746140f000000       | mov                 dword ptr [esi + 0x14], 0xf
            //   c60600               | mov                 byte ptr [esi], 0

        $sequence_3 = { 3bc2 0f42d0 0fb6041a 03d3 }
            // n = 4, score = 300
            //   3bc2                 | cmp                 eax, edx
            //   0f42d0               | cmovb               edx, eax
            //   0fb6041a             | movzx               eax, byte ptr [edx + ebx]
            //   03d3                 | add                 edx, ebx

        $sequence_4 = { 7541 d9ec d9c9 d9f1 833d????????00 0f856c090000 }
            // n = 6, score = 300
            //   7541                 | jne                 0x43
            //   d9ec                 | fldlg2              
            //   d9c9                 | fxch                st(1)
            //   d9f1                 | fyl2x               
            //   833d????????00       |                     
            //   0f856c090000         | jne                 0x972

        $sequence_5 = { 8bca c746140f000000 c60600 8d7901 0f1f440000 8a01 41 }
            // n = 7, score = 300
            //   8bca                 | mov                 ecx, edx
            //   c746140f000000       | mov                 dword ptr [esi + 0x14], 0xf
            //   c60600               | mov                 byte ptr [esi], 0
            //   8d7901               | lea                 edi, [ecx + 1]
            //   0f1f440000           | nop                 dword ptr [eax + eax]
            //   8a01                 | mov                 al, byte ptr [ecx]
            //   41                   | inc                 ecx

        $sequence_6 = { c745fc00000000 c745c400000000 c745c80f000000 c645b400 }
            // n = 4, score = 300
            //   c745fc00000000       | mov                 dword ptr [ebp - 4], 0
            //   c745c400000000       | mov                 dword ptr [ebp - 0x3c], 0
            //   c745c80f000000       | mov                 dword ptr [ebp - 0x38], 0xf
            //   c645b400             | mov                 byte ptr [ebp - 0x4c], 0

        $sequence_7 = { e8???????? 8d0c3e 83c40c 3bf1 }
            // n = 4, score = 300
            //   e8????????           |                     
            //   8d0c3e               | lea                 ecx, [esi + edi]
            //   83c40c               | add                 esp, 0xc
            //   3bf1                 | cmp                 esi, ecx

        $sequence_8 = { 51 e8???????? 83c408 85f6 7430 }
            // n = 5, score = 300
            //   51                   | push                ecx
            //   e8????????           |                     
            //   83c408               | add                 esp, 8
            //   85f6                 | test                esi, esi
            //   7430                 | je                  0x32

        $sequence_9 = { c645d800 8d5001 8b4610 3bc2 726f 2bc2 83c9ff }
            // n = 7, score = 300
            //   c645d800             | mov                 byte ptr [ebp - 0x28], 0
            //   8d5001               | lea                 edx, [eax + 1]
            //   8b4610               | mov                 eax, dword ptr [esi + 0x10]
            //   3bc2                 | cmp                 eax, edx
            //   726f                 | jb                  0x71
            //   2bc2                 | sub                 eax, edx
            //   83c9ff               | or                  ecx, 0xffffffff

        $sequence_10 = { 6a00 6aff 8bf8 6a00 }
            // n = 4, score = 300
            //   6a00                 | push                0
            //   6aff                 | push                -1
            //   8bf8                 | mov                 edi, eax
            //   6a00                 | push                0

        $sequence_11 = { 51 03c2 8d4dd8 50 e8???????? 8d45d8 8bce }
            // n = 7, score = 300
            //   51                   | push                ecx
            //   03c2                 | add                 eax, edx
            //   8d4dd8               | lea                 ecx, [ebp - 0x28]
            //   50                   | push                eax
            //   e8????????           |                     
            //   8d45d8               | lea                 eax, [ebp - 0x28]
            //   8bce                 | mov                 ecx, esi

        $sequence_12 = { 0f57c0 c745e800000000 68???????? ba???????? 660fd645e0 e8???????? 83c404 }
            // n = 7, score = 300
            //   0f57c0               | xorps               xmm0, xmm0
            //   c745e800000000       | mov                 dword ptr [ebp - 0x18], 0
            //   68????????           |                     
            //   ba????????           |                     
            //   660fd645e0           | movq                qword ptr [ebp - 0x20], xmm0
            //   e8????????           |                     
            //   83c404               | add                 esp, 4

        $sequence_13 = { 89742404 893c24 e8???????? 85c0 0f85cdfeffff }
            // n = 5, score = 200
            //   89742404             | mov                 dword ptr [esp + 4], esi
            //   893c24               | mov                 dword ptr [esp], edi
            //   e8????????           |                     
            //   85c0                 | test                eax, eax
            //   0f85cdfeffff         | jne                 0xfffffed3

        $sequence_14 = { 85c0 0f84c4000000 8b8d00ffffff 8945d0 }
            // n = 4, score = 200
            //   85c0                 | test                eax, eax
            //   0f84c4000000         | je                  0xca
            //   8b8d00ffffff         | mov                 ecx, dword ptr [ebp - 0x100]
            //   8945d0               | mov                 dword ptr [ebp - 0x30], eax

        $sequence_15 = { 89b548feffff 8b08 39d1 0f842f180000 }
            // n = 4, score = 200
            //   89b548feffff         | mov                 dword ptr [ebp - 0x1b8], esi
            //   8b08                 | mov                 ecx, dword ptr [eax]
            //   39d1                 | cmp                 ecx, edx
            //   0f842f180000         | je                  0x1835

        $sequence_16 = { 7535 8938 83c41c 31c0 5b 5e }
            // n = 6, score = 200
            //   7535                 | jne                 0x37
            //   8938                 | mov                 dword ptr [eax], edi
            //   83c41c               | add                 esp, 0x1c
            //   31c0                 | xor                 eax, eax
            //   5b                   | pop                 ebx
            //   5e                   | pop                 esi

        $sequence_17 = { 83ec1c 8b31 8b7c2430 8b442434 8b5ef4 39df }
            // n = 6, score = 200
            //   83ec1c               | sub                 esp, 0x1c
            //   8b31                 | mov                 esi, dword ptr [ecx]
            //   8b7c2430             | mov                 edi, dword ptr [esp + 0x30]
            //   8b442434             | mov                 eax, dword ptr [esp + 0x34]
            //   8b5ef4               | mov                 ebx, dword ptr [esi - 0xc]
            //   39df                 | cmp                 edi, ebx

        $sequence_18 = { 83fe0f 0f87f20e0000 83fe01 0f85150d0000 0fb617 889530ffffff }
            // n = 6, score = 200
            //   83fe0f               | cmp                 esi, 0xf
            //   0f87f20e0000         | ja                  0xef8
            //   83fe01               | cmp                 esi, 1
            //   0f85150d0000         | jne                 0xd1b
            //   0fb617               | movzx               edx, byte ptr [edi]
            //   889530ffffff         | mov                 byte ptr [ebp - 0xd0], dl

        $sequence_19 = { 895c2408 890424 89542404 e8???????? 8b5da8 }
            // n = 5, score = 200
            //   895c2408             | mov                 dword ptr [esp + 8], ebx
            //   890424               | mov                 dword ptr [esp], eax
            //   89542404             | mov                 dword ptr [esp + 4], edx
            //   e8????????           |                     
            //   8b5da8               | mov                 ebx, dword ptr [ebp - 0x58]

        $sequence_20 = { 0f8583f7ffff 8b4004 85c0 75e3 8b8310010000 8d5608 89442424 }
            // n = 7, score = 200
            //   0f8583f7ffff         | jne                 0xfffff789
            //   8b4004               | mov                 eax, dword ptr [eax + 4]
            //   85c0                 | test                eax, eax
            //   75e3                 | jne                 0xffffffe5
            //   8b8310010000         | mov                 eax, dword ptr [ebx + 0x110]
            //   8d5608               | lea                 edx, [esi + 8]
            //   89442424             | mov                 dword ptr [esp + 0x24], eax

    condition:
        7 of them and filesize < 487424
}