rule win_redleaves_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.redleaves."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.redleaves"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 89f9 8d64241c d2c0 8a01 }
            // n = 4, score = 400
            //   89f9                 | mov                 ecx, edi
            //   8d64241c             | lea                 esp, [esp + 0x1c]
            //   d2c0                 | rol                 al, cl
            //   8a01                 | mov                 al, byte ptr [ecx]

        $sequence_1 = { 51 7565 7279 55 7365 7254 }
            // n = 6, score = 400
            //   51                   | push                ecx
            //   7565                 | jne                 0x67
            //   7279                 | jb                  0x7b
            //   55                   | push                ebp
            //   7365                 | jae                 0x67
            //   7254                 | jb                  0x56

        $sequence_2 = { 11d2 83e901 0f85edffffff 89d0 29f8 5f 5b }
            // n = 7, score = 400
            //   11d2                 | adc                 edx, edx
            //   83e901               | sub                 ecx, 1
            //   0f85edffffff         | jne                 0xfffffff3
            //   89d0                 | mov                 eax, edx
            //   29f8                 | sub                 eax, edi
            //   5f                   | pop                 edi
            //   5b                   | pop                 ebx

        $sequence_3 = { 9c 894504 9c 9c }
            // n = 4, score = 400
            //   9c                   | pushfd              
            //   894504               | mov                 dword ptr [ebp + 4], eax
            //   9c                   | pushfd              
            //   9c                   | pushfd              

        $sequence_4 = { 47 657449 7041 64647254 }
            // n = 4, score = 400
            //   47                   | inc                 edi
            //   657449               | je                  0x4c
            //   7041                 | jo                  0x43
            //   64647254             | jb                  0x58

        $sequence_5 = { 57 54 53 51 7565 7279 }
            // n = 6, score = 400
            //   57                   | push                edi
            //   54                   | push                esp
            //   53                   | push                ebx
            //   51                   | push                ecx
            //   7565                 | jne                 0x67
            //   7279                 | jb                  0x7b

        $sequence_6 = { 7440 ff7508 ffd0 59 }
            // n = 4, score = 300
            //   7440                 | je                  0x42
            //   ff7508               | push                dword ptr [ebp + 8]
            //   ffd0                 | call                eax
            //   59                   | pop                 ecx

        $sequence_7 = { 60 9c e8???????? f8 }
            // n = 4, score = 300
            //   60                   | pushal              
            //   9c                   | pushfd              
            //   e8????????           |                     
            //   f8                   | clc                 

        $sequence_8 = { 6a0c 81c100020000 51 6a26 }
            // n = 4, score = 300
            //   6a0c                 | push                0xc
            //   81c100020000         | add                 ecx, 0x200
            //   51                   | push                ecx
            //   6a26                 | push                0x26

        $sequence_9 = { 5b 85ff 7509 49 48 c745fc7a000780 }
            // n = 6, score = 300
            //   5b                   | pop                 ebx
            //   85ff                 | test                edi, edi
            //   7509                 | jne                 0xb
            //   49                   | dec                 ecx
            //   48                   | dec                 eax
            //   c745fc7a000780       | mov                 dword ptr [ebp - 4], 0x8007007a

        $sequence_10 = { 54 9c 60 9c }
            // n = 4, score = 300
            //   54                   | push                esp
            //   9c                   | pushfd              
            //   60                   | pushal              
            //   9c                   | pushfd              

        $sequence_11 = { 8bec ff7508 81c160010000 e8???????? }
            // n = 4, score = 300
            //   8bec                 | mov                 ebp, esp
            //   ff7508               | push                dword ptr [ebp + 8]
            //   81c160010000         | add                 ecx, 0x160
            //   e8????????           |                     

        $sequence_12 = { 85c0 746b 53 53 }
            // n = 4, score = 300
            //   85c0                 | test                eax, eax
            //   746b                 | je                  0x6d
            //   53                   | push                ebx
            //   53                   | push                ebx

        $sequence_13 = { 83662000 33c0 40 5e }
            // n = 4, score = 300
            //   83662000             | and                 dword ptr [esi + 0x20], 0
            //   33c0                 | xor                 eax, eax
            //   40                   | inc                 eax
            //   5e                   | pop                 esi

        $sequence_14 = { 8bec ff7508 81c17c010000 e8???????? }
            // n = 4, score = 300
            //   8bec                 | mov                 ebp, esp
            //   ff7508               | push                dword ptr [ebp + 8]
            //   81c17c010000         | add                 ecx, 0x17c
            //   e8????????           |                     

        $sequence_15 = { 8bec ff7508 81c104010000 e8???????? 33c0 40 5d }
            // n = 7, score = 300
            //   8bec                 | mov                 ebp, esp
            //   ff7508               | push                dword ptr [ebp + 8]
            //   81c104010000         | add                 ecx, 0x104
            //   e8????????           |                     
            //   33c0                 | xor                 eax, eax
            //   40                   | inc                 eax
            //   5d                   | pop                 ebp

        $sequence_16 = { 9c 8f442428 880424 e8???????? }
            // n = 4, score = 300
            //   9c                   | pushfd              
            //   8f442428             | pop                 dword ptr [esp + 0x28]
            //   880424               | mov                 byte ptr [esp], al
            //   e8????????           |                     

        $sequence_17 = { e8???????? 895500 9c e8???????? }
            // n = 4, score = 300
            //   e8????????           |                     
            //   895500               | mov                 dword ptr [ebp], edx
            //   9c                   | pushfd              
            //   e8????????           |                     

    condition:
        7 of them and filesize < 1679360
}