rule win_redsalt_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.redsalt."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.redsalt"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 83c414 33c9 83f8ff 0f95c1 }
            // n = 4, score = 1100
            //   83c414               | add                 esp, 0x14
            //   33c9                 | xor                 ecx, ecx
            //   83f8ff               | cmp                 eax, -1
            //   0f95c1               | setne               cl

        $sequence_1 = { 750b 68e8030000 ff15???????? e8???????? }
            // n = 4, score = 1100
            //   750b                 | jne                 0xd
            //   68e8030000           | push                0x3e8
            //   ff15????????         |                     
            //   e8????????           |                     

        $sequence_2 = { c745d060ea0000 6a04 8d45d0 50 6806100000 68ffff0000 }
            // n = 6, score = 900
            //   c745d060ea0000       | mov                 dword ptr [ebp - 0x30], 0xea60
            //   6a04                 | push                4
            //   8d45d0               | lea                 eax, [ebp - 0x30]
            //   50                   | push                eax
            //   6806100000           | push                0x1006
            //   68ffff0000           | push                0xffff

        $sequence_3 = { e8???????? 85c0 750a 6a32 }
            // n = 4, score = 900
            //   e8????????           |                     
            //   85c0                 | test                eax, eax
            //   750a                 | jne                 0xc
            //   6a32                 | push                0x32

        $sequence_4 = { 51 ffd6 85c0 7510 }
            // n = 4, score = 900
            //   51                   | push                ecx
            //   ffd6                 | call                esi
            //   85c0                 | test                eax, eax
            //   7510                 | jne                 0x12

        $sequence_5 = { 85c0 7515 c705????????01000000 ff15???????? e9???????? }
            // n = 5, score = 900
            //   85c0                 | test                eax, eax
            //   7515                 | jne                 0x17
            //   c705????????01000000     |     
            //   ff15????????         |                     
            //   e9????????           |                     

        $sequence_6 = { 740d 68???????? e8???????? 83c404 833d????????02 }
            // n = 5, score = 800
            //   740d                 | je                  0xf
            //   68????????           |                     
            //   e8????????           |                     
            //   83c404               | add                 esp, 4
            //   833d????????02       |                     

        $sequence_7 = { 83c9ff 85f6 7c0e 83fe7f }
            // n = 4, score = 800
            //   83c9ff               | or                  ecx, 0xffffffff
            //   85f6                 | test                esi, esi
            //   7c0e                 | jl                  0x10
            //   83fe7f               | cmp                 esi, 0x7f

        $sequence_8 = { 7509 80780120 7503 83c002 }
            // n = 4, score = 700
            //   7509                 | jne                 0xb
            //   80780120             | cmp                 byte ptr [eax + 1], 0x20
            //   7503                 | jne                 5
            //   83c002               | add                 eax, 2

        $sequence_9 = { 6a00 52 c744242401000000 8944242c }
            // n = 4, score = 700
            //   6a00                 | push                0
            //   52                   | push                edx
            //   c744242401000000     | mov                 dword ptr [esp + 0x24], 1
            //   8944242c             | mov                 dword ptr [esp + 0x2c], eax

        $sequence_10 = { 8d8530fcffff 50 e8???????? 83c40c }
            // n = 4, score = 700
            //   8d8530fcffff         | lea                 eax, [ebp - 0x3d0]
            //   50                   | push                eax
            //   e8????????           |                     
            //   83c40c               | add                 esp, 0xc

        $sequence_11 = { c60100 5f 5e 33c0 }
            // n = 4, score = 700
            //   c60100               | mov                 byte ptr [ecx], 0
            //   5f                   | pop                 edi
            //   5e                   | pop                 esi
            //   33c0                 | xor                 eax, eax

        $sequence_12 = { 83c40c eb02 33c0 8b4df4 }
            // n = 4, score = 700
            //   83c40c               | add                 esp, 0xc
            //   eb02                 | jmp                 4
            //   33c0                 | xor                 eax, eax
            //   8b4df4               | mov                 ecx, dword ptr [ebp - 0xc]

        $sequence_13 = { e8???????? 83c408 6800010000 68???????? }
            // n = 4, score = 600
            //   e8????????           |                     
            //   83c408               | add                 esp, 8
            //   6800010000           | push                0x100
            //   68????????           |                     

        $sequence_14 = { 833800 750f c705????????01000000 e9???????? }
            // n = 4, score = 500
            //   833800               | cmp                 dword ptr [eax], 0
            //   750f                 | jne                 0x11
            //   c705????????01000000     |     
            //   e9????????           |                     

        $sequence_15 = { f7e7 8bea d1ed 33c0 }
            // n = 4, score = 500
            //   f7e7                 | mul                 edi
            //   8bea                 | mov                 ebp, edx
            //   d1ed                 | shr                 ebp, 1
            //   33c0                 | xor                 eax, eax

        $sequence_16 = { d1ed 33c0 83ef03 8a06 83c603 c1e802 41 }
            // n = 7, score = 500
            //   d1ed                 | shr                 ebp, 1
            //   33c0                 | xor                 eax, eax
            //   83ef03               | sub                 edi, 3
            //   8a06                 | mov                 al, byte ptr [esi]
            //   83c603               | add                 esi, 3
            //   c1e802               | shr                 eax, 2
            //   41                   | inc                 ecx

        $sequence_17 = { eb03 83caff 8b442410 c0e106 0aca 884d00 45 }
            // n = 7, score = 500
            //   eb03                 | jmp                 5
            //   83caff               | or                  edx, 0xffffffff
            //   8b442410             | mov                 eax, dword ptr [esp + 0x10]
            //   c0e106               | shl                 cl, 6
            //   0aca                 | or                  cl, dl
            //   884d00               | mov                 byte ptr [ebp], cl
            //   45                   | inc                 ebp

        $sequence_18 = { c644243423 c644243572 c64424367a c644243700 }
            // n = 4, score = 300
            //   c644243423           | mov                 byte ptr [esp + 0x34], 0x23
            //   c644243572           | mov                 byte ptr [esp + 0x35], 0x72
            //   c64424367a           | mov                 byte ptr [esp + 0x36], 0x7a
            //   c644243700           | mov                 byte ptr [esp + 0x37], 0

        $sequence_19 = { c8201cdd f7be5b408d58 1b7f01 d2cc }
            // n = 4, score = 200
            //   c8201cdd             | enter               0x1c20, -0x23
            //   f7be5b408d58         | idiv                dword ptr [esi + 0x588d405b]
            //   1b7f01               | sbb                 edi, dword ptr [edi + 1]
            //   d2cc                 | ror                 ah, cl

        $sequence_20 = { d2cc bbe3b46b7e 6aa2 dd45ff }
            // n = 4, score = 200
            //   d2cc                 | ror                 ah, cl
            //   bbe3b46b7e           | mov                 ebx, 0x7e6bb4e3
            //   6aa2                 | push                -0x5e
            //   dd45ff               | fld                 qword ptr [ebp - 1]

        $sequence_21 = { e8???????? 89442430 48c744244000000000 8b442430 }
            // n = 4, score = 100
            //   e8????????           |                     
            //   89442430             | mov                 dword ptr [esp + 0x2c], eax
            //   48c744244000000000     | mov    ecx, dword ptr [esp + 0x28]
            //   8b442430             | mov                 eax, dword ptr [esp + 0x2c]

        $sequence_22 = { e8???????? 89442428 e9???????? bf2d000000 488d542420 4d8bc5 }
            // n = 6, score = 100
            //   e8????????           |                     
            //   89442428             | lea                 edx, [esp + 0x20]
            //   e9????????           |                     
            //   bf2d000000           | mov                 dword ptr [esp + 0x28], eax
            //   488d542420           | mov                 edi, 0x2d
            //   4d8bc5               | dec                 eax

        $sequence_23 = { e8???????? 8944242c 8b4c2428 8b44242c }
            // n = 4, score = 100
            //   e8????????           |                     
            //   8944242c             | dec                 eax
            //   8b4c2428             | lea                 edx, [esp + 0x20]
            //   8b44242c             | dec                 ebp

        $sequence_24 = { e8???????? 89442428 e9???????? 8b4c2420 8b442428 01c8 }
            // n = 6, score = 100
            //   e8????????           |                     
            //   89442428             | mov                 dword ptr [esp + 0x28], eax
            //   e9????????           |                     
            //   8b4c2420             | mov                 ecx, dword ptr [esp + 0x20]
            //   8b442428             | mov                 eax, dword ptr [esp + 0x28]
            //   01c8                 | add                 eax, ecx

    condition:
        7 of them and filesize < 2957312
}