rule win_redyms_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.redyms."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.redyms"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 85c0 7414 8b4f04 57 }
            // n = 4, score = 100
            //   85c0                 | test                eax, eax
            //   7414                 | je                  0x16
            //   8b4f04               | mov                 ecx, dword ptr [edi + 4]
            //   57                   | push                edi

        $sequence_1 = { ffd6 57 ff15???????? 0fb6450b f7d8 5f 1bc0 }
            // n = 7, score = 100
            //   ffd6                 | call                esi
            //   57                   | push                edi
            //   ff15????????         |                     
            //   0fb6450b             | movzx               eax, byte ptr [ebp + 0xb]
            //   f7d8                 | neg                 eax
            //   5f                   | pop                 edi
            //   1bc0                 | sbb                 eax, eax

        $sequence_2 = { 2bc2 68???????? 6a03 b9???????? 8bd7 e8???????? 83c408 }
            // n = 7, score = 100
            //   2bc2                 | sub                 eax, edx
            //   68????????           |                     
            //   6a03                 | push                3
            //   b9????????           |                     
            //   8bd7                 | mov                 edx, edi
            //   e8????????           |                     
            //   83c408               | add                 esp, 8

        $sequence_3 = { 84c0 7467 807dfb00 7561 8b5514 }
            // n = 5, score = 100
            //   84c0                 | test                al, al
            //   7467                 | je                  0x69
            //   807dfb00             | cmp                 byte ptr [ebp - 5], 0
            //   7561                 | jne                 0x63
            //   8b5514               | mov                 edx, dword ptr [ebp + 0x14]

        $sequence_4 = { 8bf0 83c404 85f6 740e e8???????? 84c0 7405 }
            // n = 7, score = 100
            //   8bf0                 | mov                 esi, eax
            //   83c404               | add                 esp, 4
            //   85f6                 | test                esi, esi
            //   740e                 | je                  0x10
            //   e8????????           |                     
            //   84c0                 | test                al, al
            //   7405                 | je                  7

        $sequence_5 = { 55 8bec 83ec1c 8845f4 8b4508 8d5001 90 }
            // n = 7, score = 100
            //   55                   | push                ebp
            //   8bec                 | mov                 ebp, esp
            //   83ec1c               | sub                 esp, 0x1c
            //   8845f4               | mov                 byte ptr [ebp - 0xc], al
            //   8b4508               | mov                 eax, dword ptr [ebp + 8]
            //   8d5001               | lea                 edx, [eax + 1]
            //   90                   | nop                 

        $sequence_6 = { 898534feffff 85c0 745d 8dbd70ffffff b806000000 e8???????? 53 }
            // n = 7, score = 100
            //   898534feffff         | mov                 dword ptr [ebp - 0x1cc], eax
            //   85c0                 | test                eax, eax
            //   745d                 | je                  0x5f
            //   8dbd70ffffff         | lea                 edi, [ebp - 0x90]
            //   b806000000           | mov                 eax, 6
            //   e8????????           |                     
            //   53                   | push                ebx

        $sequence_7 = { 8975f4 895df8 ff15???????? 8bf8 }
            // n = 4, score = 100
            //   8975f4               | mov                 dword ptr [ebp - 0xc], esi
            //   895df8               | mov                 dword ptr [ebp - 8], ebx
            //   ff15????????         |                     
            //   8bf8                 | mov                 edi, eax

        $sequence_8 = { 7409 53 57 56 ff15???????? 8975d4 eb22 }
            // n = 7, score = 100
            //   7409                 | je                  0xb
            //   53                   | push                ebx
            //   57                   | push                edi
            //   56                   | push                esi
            //   ff15????????         |                     
            //   8975d4               | mov                 dword ptr [ebp - 0x2c], esi
            //   eb22                 | jmp                 0x24

        $sequence_9 = { 0f84b2000000 8d7ddc b825000000 e8???????? 8b4dd0 8b55d4 a1???????? }
            // n = 7, score = 100
            //   0f84b2000000         | je                  0xb8
            //   8d7ddc               | lea                 edi, [ebp - 0x24]
            //   b825000000           | mov                 eax, 0x25
            //   e8????????           |                     
            //   8b4dd0               | mov                 ecx, dword ptr [ebp - 0x30]
            //   8b55d4               | mov                 edx, dword ptr [ebp - 0x2c]
            //   a1????????           |                     

    condition:
        7 of them and filesize < 98304
}