rule win_remexi_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.remexi."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.remexi"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 56 c706ffffffff e8???????? 83c404 }
            // n = 4, score = 300
            //   56                   | push                esi
            //   c706ffffffff         | mov                 dword ptr [esi], 0xffffffff
            //   e8????????           |                     
            //   83c404               | add                 esp, 4

        $sequence_1 = { 6a00 50 6a02 ff15???????? 6a10 }
            // n = 5, score = 200
            //   6a00                 | push                0
            //   50                   | push                eax
            //   6a02                 | push                2
            //   ff15????????         |                     
            //   6a10                 | push                0x10

        $sequence_2 = { 52 6a00 68ffff1f00 ffd7 8bf0 }
            // n = 5, score = 200
            //   52                   | push                edx
            //   6a00                 | push                0
            //   68ffff1f00           | push                0x1fffff
            //   ffd7                 | call                edi
            //   8bf0                 | mov                 esi, eax

        $sequence_3 = { 53 50 ff15???????? 3dffffff00 }
            // n = 4, score = 200
            //   53                   | push                ebx
            //   50                   | push                eax
            //   ff15????????         |                     
            //   3dffffff00           | cmp                 eax, 0xffffff

        $sequence_4 = { a3???????? c705????????02000000 890d???????? ffd6 6a00 6a00 }
            // n = 6, score = 200
            //   a3????????           |                     
            //   c705????????02000000     |     
            //   890d????????         |                     
            //   ffd6                 | call                esi
            //   6a00                 | push                0
            //   6a00                 | push                0

        $sequence_5 = { 6a10 8d4ddc 8bf0 51 }
            // n = 4, score = 200
            //   6a10                 | push                0x10
            //   8d4ddc               | lea                 ecx, [ebp - 0x24]
            //   8bf0                 | mov                 esi, eax
            //   51                   | push                ecx

        $sequence_6 = { c705????????01000000 c705????????00000000 ff15???????? 8b0d???????? 51 ff15???????? }
            // n = 6, score = 200
            //   c705????????01000000     |     
            //   c705????????00000000     |     
            //   ff15????????         |                     
            //   8b0d????????         |                     
            //   51                   | push                ecx
            //   ff15????????         |                     

        $sequence_7 = { 7513 8b45d8 8b4818 8b5104 50 8955e0 }
            // n = 6, score = 200
            //   7513                 | jne                 0x15
            //   8b45d8               | mov                 eax, dword ptr [ebp - 0x28]
            //   8b4818               | mov                 ecx, dword ptr [eax + 0x18]
            //   8b5104               | mov                 edx, dword ptr [ecx + 4]
            //   50                   | push                eax
            //   8955e0               | mov                 dword ptr [ebp - 0x20], edx

        $sequence_8 = { ff15???????? 57 8b3d???????? ffd7 56 ffd7 5e }
            // n = 7, score = 200
            //   ff15????????         |                     
            //   57                   | push                edi
            //   8b3d????????         |                     
            //   ffd7                 | call                edi
            //   56                   | push                esi
            //   ffd7                 | call                edi
            //   5e                   | pop                 esi

        $sequence_9 = { 6828010000 8d8dccfeffff 6a00 51 }
            // n = 4, score = 200
            //   6828010000           | push                0x128
            //   8d8dccfeffff         | lea                 ecx, [ebp - 0x134]
            //   6a00                 | push                0
            //   51                   | push                ecx

        $sequence_10 = { 8945e4 8945e8 b802000000 51 668945dc }
            // n = 5, score = 200
            //   8945e4               | mov                 dword ptr [ebp - 0x1c], eax
            //   8945e8               | mov                 dword ptr [ebp - 0x18], eax
            //   b802000000           | mov                 eax, 2
            //   51                   | push                ecx
            //   668945dc             | mov                 word ptr [ebp - 0x24], ax

        $sequence_11 = { 6a00 6a02 c785ccfeffff28010000 ff15???????? }
            // n = 4, score = 200
            //   6a00                 | push                0
            //   6a02                 | push                2
            //   c785ccfeffff28010000     | mov    dword ptr [ebp - 0x134], 0x128
            //   ff15????????         |                     

        $sequence_12 = { a1???????? 68???????? 50 c705????????01000000 c705????????00000000 }
            // n = 5, score = 200
            //   a1????????           |                     
            //   68????????           |                     
            //   50                   | push                eax
            //   c705????????01000000     |     
            //   c705????????00000000     |     

        $sequence_13 = { 57 e8???????? 6a01 6a00 6a00 ff15???????? 8bf8 }
            // n = 7, score = 200
            //   57                   | push                edi
            //   e8????????           |                     
            //   6a01                 | push                1
            //   6a00                 | push                0
            //   6a00                 | push                0
            //   ff15????????         |                     
            //   8bf8                 | mov                 edi, eax

        $sequence_14 = { e8???????? 83ec1c 8bcc 89642430 6aff 53 }
            // n = 6, score = 200
            //   e8????????           |                     
            //   83ec1c               | sub                 esp, 0x1c
            //   8bcc                 | mov                 ecx, esp
            //   89642430             | mov                 dword ptr [esp + 0x30], esp
            //   6aff                 | push                -1
            //   53                   | push                ebx

        $sequence_15 = { 483305???????? 488bcb 488905???????? ff15???????? 488d15eb330100 }
            // n = 5, score = 100
            //   483305????????       |                     
            //   488bcb               | mov                 edx, ebx
            //   488905????????       |                     
            //   ff15????????         |                     
            //   488d15eb330100       | dec                 ecx

        $sequence_16 = { 015930 3b542408 0f8d10ffffff 8d3c52 }
            // n = 4, score = 100
            //   015930               | add                 dword ptr [ecx + 0x30], ebx
            //   3b542408             | cmp                 edx, dword ptr [esp + 8]
            //   0f8d10ffffff         | jge                 0xffffff16
            //   8d3c52               | lea                 edi, [edx + edx*2]

        $sequence_17 = { 015330 e9???????? 8b5314 3b5318 0f8d23020000 }
            // n = 5, score = 100
            //   015330               | add                 dword ptr [ebx + 0x30], edx
            //   e9????????           |                     
            //   8b5314               | mov                 edx, dword ptr [ebx + 0x14]
            //   3b5318               | cmp                 edx, dword ptr [ebx + 0x18]
            //   0f8d23020000         | jge                 0x229

        $sequence_18 = { 015330 41 894b0c e9???????? }
            // n = 4, score = 100
            //   015330               | add                 dword ptr [ebx + 0x30], edx
            //   41                   | inc                 ecx
            //   894b0c               | mov                 dword ptr [ebx + 0xc], ecx
            //   e9????????           |                     

        $sequence_19 = { 4c8d054d330100 488bd3 498bce e8???????? 85c0 0f8509010000 498b0c24 }
            // n = 7, score = 100
            //   4c8d054d330100       | jne                 0xfffffff4
            //   488bd3               | inc                 esp
            //   498bce               | mov                 eax, dword ptr [eax + 0x10]
            //   e8????????           |                     
            //   85c0                 | dec                 eax
            //   0f8509010000         | mov                 ecx, dword ptr [esi + 0x4e8]
            //   498b0c24             | nop                 

        $sequence_20 = { 016b24 89e8 83c44c 5b }
            // n = 4, score = 100
            //   016b24               | add                 dword ptr [ebx + 0x24], ebp
            //   89e8                 | mov                 eax, ebp
            //   83c44c               | add                 esp, 0x4c
            //   5b                   | pop                 ebx

        $sequence_21 = { 015518 8b5d14 85db 0f8565fbffff }
            // n = 4, score = 100
            //   015518               | add                 dword ptr [ebp + 0x18], edx
            //   8b5d14               | mov                 ebx, dword ptr [ebp + 0x14]
            //   85db                 | test                ebx, ebx
            //   0f8565fbffff         | jne                 0xfffffb6b

        $sequence_22 = { 014b30 bf???????? b903000000 8b742418 }
            // n = 4, score = 100
            //   014b30               | add                 dword ptr [ebx + 0x30], ecx
            //   bf????????           |                     
            //   b903000000           | mov                 ecx, 3
            //   8b742418             | mov                 esi, dword ptr [esp + 0x18]

        $sequence_23 = { 448b4010 488b8ee8040000 e8???????? 90 }
            // n = 4, score = 100
            //   448b4010             | add                 ebx, 0x28
            //   488b8ee8040000       | dec                 eax
            //   e8????????           |                     
            //   90                   | dec                 edi

        $sequence_24 = { 015330 8a10 eb84 8a5001 }
            // n = 4, score = 100
            //   015330               | add                 dword ptr [ebx + 0x30], edx
            //   8a10                 | mov                 dl, byte ptr [eax]
            //   eb84                 | jmp                 0xffffff86
            //   8a5001               | mov                 dl, byte ptr [eax + 1]

        $sequence_25 = { c744243030010000 33d2 8d4a02 ff15???????? }
            // n = 4, score = 100
            //   c744243030010000     | dec                 esp
            //   33d2                 | lea                 eax, [0x1334d]
            //   8d4a02               | dec                 eax
            //   ff15????????         |                     

        $sequence_26 = { 498bfc 4c89a5a8000000 48c74424400f000000 4c89642438 }
            // n = 4, score = 100
            //   498bfc               | mov                 dword ptr [esp + 0x30], 0x130
            //   4c89a5a8000000       | xor                 edx, edx
            //   48c74424400f000000     | lea    ecx, [edx + 2]
            //   4c89642438           | dec                 eax

        $sequence_27 = { e8???????? 48c785500100000f000000 4533f6 4c89b548010000 4488b538010000 488b442460 }
            // n = 6, score = 100
            //   e8????????           |                     
            //   48c785500100000f000000     | mov    ecx, ebx
            //   4533f6               | dec                 eax
            //   4c89b548010000       | lea                 edx, [0x133eb]
            //   4488b538010000       | dec                 eax
            //   488b442460           | mov                 dword ptr [esp + 8], ebx

        $sequence_28 = { 48895c2408 4889742410 57 4883ec20 488d3dea000200 }
            // n = 5, score = 100
            //   48895c2408           | mov                 ecx, esi
            //   4889742410           | test                eax, eax
            //   57                   | jne                 0x114
            //   4883ec20             | dec                 ecx
            //   488d3dea000200       | mov                 ecx, dword ptr [esp]

        $sequence_29 = { 488d1d5e6c0200 bf04000000 488bcb e8???????? 4883c328 48ffcf 75ef }
            // n = 7, score = 100
            //   488d1d5e6c0200       | dec                 eax
            //   bf04000000           | lea                 ebx, [0x26c5e]
            //   488bcb               | mov                 edi, 4
            //   e8????????           |                     
            //   4883c328             | dec                 eax
            //   48ffcf               | mov                 ecx, ebx
            //   75ef                 | dec                 eax

        $sequence_30 = { 016b04 83c41c 5b 5e }
            // n = 4, score = 100
            //   016b04               | add                 dword ptr [ebx + 4], ebp
            //   83c41c               | add                 esp, 0x1c
            //   5b                   | pop                 ebx
            //   5e                   | pop                 esi

    condition:
        7 of them and filesize < 614400
}