rule win_rerdom_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.rerdom."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.rerdom"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 33f6 85ff 740d 8b04b3 e8???????? 46 3bf7 }
            // n = 7, score = 200
            //   33f6                 | xor                 esi, esi
            //   85ff                 | test                edi, edi
            //   740d                 | je                  0xf
            //   8b04b3               | mov                 eax, dword ptr [ebx + esi*4]
            //   e8????????           |                     
            //   46                   | inc                 esi
            //   3bf7                 | cmp                 esi, edi

        $sequence_1 = { 57 ba???????? 52 e8???????? 52 ff15???????? e8???????? }
            // n = 7, score = 200
            //   57                   | push                edi
            //   ba????????           |                     
            //   52                   | push                edx
            //   e8????????           |                     
            //   52                   | push                edx
            //   ff15????????         |                     
            //   e8????????           |                     

        $sequence_2 = { 8b3e 8bc3 e8???????? 8945fc 83f8ff 751a 85db }
            // n = 7, score = 200
            //   8b3e                 | mov                 edi, dword ptr [esi]
            //   8bc3                 | mov                 eax, ebx
            //   e8????????           |                     
            //   8945fc               | mov                 dword ptr [ebp - 4], eax
            //   83f8ff               | cmp                 eax, -1
            //   751a                 | jne                 0x1c
            //   85db                 | test                ebx, ebx

        $sequence_3 = { 8d44244c 50 ff15???????? 6a01 53 53 }
            // n = 6, score = 200
            //   8d44244c             | lea                 eax, [esp + 0x4c]
            //   50                   | push                eax
            //   ff15????????         |                     
            //   6a01                 | push                1
            //   53                   | push                ebx
            //   53                   | push                ebx

        $sequence_4 = { 8bf0 58 c745f804000000 e8???????? 8bd0 8955f4 85d2 }
            // n = 7, score = 200
            //   8bf0                 | mov                 esi, eax
            //   58                   | pop                 eax
            //   c745f804000000       | mov                 dword ptr [ebp - 8], 4
            //   e8????????           |                     
            //   8bd0                 | mov                 edx, eax
            //   8955f4               | mov                 dword ptr [ebp - 0xc], edx
            //   85d2                 | test                edx, edx

        $sequence_5 = { 7576 8b4610 85c0 740a 8a00 3c0e 7404 }
            // n = 7, score = 200
            //   7576                 | jne                 0x78
            //   8b4610               | mov                 eax, dword ptr [esi + 0x10]
            //   85c0                 | test                eax, eax
            //   740a                 | je                  0xc
            //   8a00                 | mov                 al, byte ptr [eax]
            //   3c0e                 | cmp                 al, 0xe
            //   7404                 | je                  6

        $sequence_6 = { 6a0d 2bc6 5a 3bc2 7211 57 8bc2 }
            // n = 7, score = 200
            //   6a0d                 | push                0xd
            //   2bc6                 | sub                 eax, esi
            //   5a                   | pop                 edx
            //   3bc2                 | cmp                 eax, edx
            //   7211                 | jb                  0x13
            //   57                   | push                edi
            //   8bc2                 | mov                 eax, edx

        $sequence_7 = { ff7508 e8???????? 3bc7 0f85c4000000 8b450c 85c0 0f84b9000000 }
            // n = 7, score = 200
            //   ff7508               | push                dword ptr [ebp + 8]
            //   e8????????           |                     
            //   3bc7                 | cmp                 eax, edi
            //   0f85c4000000         | jne                 0xca
            //   8b450c               | mov                 eax, dword ptr [ebp + 0xc]
            //   85c0                 | test                eax, eax
            //   0f84b9000000         | je                  0xbf

        $sequence_8 = { 6a01 8d45cc e8???????? 84c0 0f84ab010000 8975fc 8975f8 }
            // n = 7, score = 200
            //   6a01                 | push                1
            //   8d45cc               | lea                 eax, [ebp - 0x34]
            //   e8????????           |                     
            //   84c0                 | test                al, al
            //   0f84ab010000         | je                  0x1b1
            //   8975fc               | mov                 dword ptr [ebp - 4], esi
            //   8975f8               | mov                 dword ptr [ebp - 8], esi

        $sequence_9 = { ffd7 53 ffd6 8325????????00 ff74241c ffd7 ff74241c }
            // n = 7, score = 200
            //   ffd7                 | call                edi
            //   53                   | push                ebx
            //   ffd6                 | call                esi
            //   8325????????00       |                     
            //   ff74241c             | push                dword ptr [esp + 0x1c]
            //   ffd7                 | call                edi
            //   ff74241c             | push                dword ptr [esp + 0x1c]

    condition:
        7 of them and filesize < 352256
}