rule win_retefe_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.retefe."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.retefe"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 6a00 6a01 ff15???????? 8bf0 85f6 7410 6a09 }
            // n = 7, score = 1200
            //   6a00                 | push                0
            //   6a01                 | push                1
            //   ff15????????         |                     
            //   8bf0                 | mov                 esi, eax
            //   85f6                 | test                esi, esi
            //   7410                 | je                  0x12
            //   6a09                 | push                9

        $sequence_1 = { 51 8bf8 ffd6 85c0 }
            // n = 4, score = 1200
            //   51                   | push                ecx
            //   8bf8                 | mov                 edi, eax
            //   ffd6                 | call                esi
            //   85c0                 | test                eax, eax

        $sequence_2 = { 68f5000000 50 ff15???????? b801000000 }
            // n = 4, score = 1200
            //   68f5000000           | push                0xf5
            //   50                   | push                eax
            //   ff15????????         |                     
            //   b801000000           | mov                 eax, 1

        $sequence_3 = { 8bec 83ec08 807e0800 7555 }
            // n = 4, score = 800
            //   8bec                 | mov                 ebp, esp
            //   83ec08               | sub                 esp, 8
            //   807e0800             | cmp                 byte ptr [esi + 8], 0
            //   7555                 | jne                 0x57

        $sequence_4 = { 894604 83c404 8bc6 e8???????? }
            // n = 4, score = 800
            //   894604               | mov                 dword ptr [esi + 4], eax
            //   83c404               | add                 esp, 4
            //   8bc6                 | mov                 eax, esi
            //   e8????????           |                     

        $sequence_5 = { 6a3c 6ad0 6a07 e8???????? 83c41c }
            // n = 5, score = 800
            //   6a3c                 | push                0x3c
            //   6ad0                 | push                -0x30
            //   6a07                 | push                7
            //   e8????????           |                     
            //   83c41c               | add                 esp, 0x1c

        $sequence_6 = { 6a79 6ac1 6aec 6a40 6a79 }
            // n = 5, score = 800
            //   6a79                 | push                0x79
            //   6ac1                 | push                -0x3f
            //   6aec                 | push                -0x14
            //   6a40                 | push                0x40
            //   6a79                 | push                0x79

        $sequence_7 = { e8???????? 6a08 e8???????? 894604 }
            // n = 4, score = 800
            //   e8????????           |                     
            //   6a08                 | push                8
            //   e8????????           |                     
            //   894604               | mov                 dword ptr [esi + 4], eax

        $sequence_8 = { e8???????? 8b4e04 8901 8b4e04 }
            // n = 4, score = 800
            //   e8????????           |                     
            //   8b4e04               | mov                 ecx, dword ptr [esi + 4]
            //   8901                 | mov                 dword ptr [ecx], eax
            //   8b4e04               | mov                 ecx, dword ptr [esi + 4]

        $sequence_9 = { 8901 8b4e04 33c0 83c404 }
            // n = 4, score = 800
            //   8901                 | mov                 dword ptr [ecx], eax
            //   8b4e04               | mov                 ecx, dword ptr [esi + 4]
            //   33c0                 | xor                 eax, eax
            //   83c404               | add                 esp, 4

        $sequence_10 = { 6a52 6af1 6a72 6a8a 6a3f 6a8e }
            // n = 6, score = 800
            //   6a52                 | push                0x52
            //   6af1                 | push                -0xf
            //   6a72                 | push                0x72
            //   6a8a                 | push                -0x76
            //   6a3f                 | push                0x3f
            //   6a8e                 | push                -0x72

        $sequence_11 = { 6a80 6a18 6aee 6a71 6ac7 }
            // n = 5, score = 800
            //   6a80                 | push                -0x80
            //   6a18                 | push                0x18
            //   6aee                 | push                -0x12
            //   6a71                 | push                0x71
            //   6ac7                 | push                -0x39

        $sequence_12 = { 8b4e04 40 3b4104 72ec }
            // n = 4, score = 800
            //   8b4e04               | mov                 ecx, dword ptr [esi + 4]
            //   40                   | inc                 eax
            //   3b4104               | cmp                 eax, dword ptr [ecx + 4]
            //   72ec                 | jb                  0xffffffee

        $sequence_13 = { 8a0485911c4300 8803 0fb6c5 8a0485911c4300 884301 }
            // n = 5, score = 100
            //   8a0485911c4300       | mov                 al, byte ptr [eax*4 + 0x431c91]
            //   8803                 | mov                 byte ptr [ebx], al
            //   0fb6c5               | movzx               eax, ch
            //   8a0485911c4300       | mov                 al, byte ptr [eax*4 + 0x431c91]
            //   884301               | mov                 byte ptr [ebx + 1], al

        $sequence_14 = { 50 e8???????? 53 8d8504ccffff }
            // n = 4, score = 100
            //   50                   | push                eax
            //   e8????????           |                     
            //   53                   | push                ebx
            //   8d8504ccffff         | lea                 eax, [ebp - 0x33fc]

        $sequence_15 = { e8???????? 68???????? 8d4508 897508 50 }
            // n = 5, score = 100
            //   e8????????           |                     
            //   68????????           |                     
            //   8d4508               | lea                 eax, [ebp + 8]
            //   897508               | mov                 dword ptr [ebp + 8], esi
            //   50                   | push                eax

        $sequence_16 = { 83f836 0f8f80000000 7477 83e816 83f80a }
            // n = 5, score = 100
            //   83f836               | cmp                 eax, 0x36
            //   0f8f80000000         | jg                  0x86
            //   7477                 | je                  0x79
            //   83e816               | sub                 eax, 0x16
            //   83f80a               | cmp                 eax, 0xa

        $sequence_17 = { 8b06 56 ff5008 ff15???????? 33c0 }
            // n = 5, score = 100
            //   8b06                 | mov                 eax, dword ptr [esi]
            //   56                   | push                esi
            //   ff5008               | call                dword ptr [eax + 8]
            //   ff15????????         |                     
            //   33c0                 | xor                 eax, eax

        $sequence_18 = { e8???????? 83c408 8906 8bce e8???????? c745fcffffffff }
            // n = 6, score = 100
            //   e8????????           |                     
            //   83c408               | add                 esp, 8
            //   8906                 | mov                 dword ptr [esi], eax
            //   8bce                 | mov                 ecx, esi
            //   e8????????           |                     
            //   c745fcffffffff       | mov                 dword ptr [ebp - 4], 0xffffffff

        $sequence_19 = { 50 8d8424f8010000 50 ffb42414030000 ffb42414030000 }
            // n = 5, score = 100
            //   50                   | push                eax
            //   8d8424f8010000       | lea                 eax, [esp + 0x1f8]
            //   50                   | push                eax
            //   ffb42414030000       | push                dword ptr [esp + 0x314]
            //   ffb42414030000       | push                dword ptr [esp + 0x314]

        $sequence_20 = { 660fd60f 8d7f08 8b048d043f4000 ffe0 f7c703000000 }
            // n = 5, score = 100
            //   660fd60f             | movq                qword ptr [edi], xmm1
            //   8d7f08               | lea                 edi, [edi + 8]
            //   8b048d043f4000       | mov                 eax, dword ptr [ecx*4 + 0x403f04]
            //   ffe0                 | jmp                 eax
            //   f7c703000000         | test                edi, 3

        $sequence_21 = { 8b45d4 886de5 8b1485a0bf4200 8a4c1a2d f6c104 7419 }
            // n = 6, score = 100
            //   8b45d4               | mov                 eax, dword ptr [ebp - 0x2c]
            //   886de5               | mov                 byte ptr [ebp - 0x1b], ch
            //   8b1485a0bf4200       | mov                 edx, dword ptr [eax*4 + 0x42bfa0]
            //   8a4c1a2d             | mov                 cl, byte ptr [edx + ebx + 0x2d]
            //   f6c104               | test                cl, 4
            //   7419                 | je                  0x1b

        $sequence_22 = { ff15???????? 85c0 7814 57 68???????? 6a17 }
            // n = 6, score = 100
            //   ff15????????         |                     
            //   85c0                 | test                eax, eax
            //   7814                 | js                  0x16
            //   57                   | push                edi
            //   68????????           |                     
            //   6a17                 | push                0x17

        $sequence_23 = { c1fb06 83e03f 6bd030 895de4 8b049da0bf4200 }
            // n = 5, score = 100
            //   c1fb06               | sar                 ebx, 6
            //   83e03f               | and                 eax, 0x3f
            //   6bd030               | imul                edx, eax, 0x30
            //   895de4               | mov                 dword ptr [ebp - 0x1c], ebx
            //   8b049da0bf4200       | mov                 eax, dword ptr [ebx*4 + 0x42bfa0]

        $sequence_24 = { c645f800 8d4847 304c05e4 40 83f814 72f3 8d45e4 }
            // n = 7, score = 100
            //   c645f800             | mov                 byte ptr [ebp - 8], 0
            //   8d4847               | lea                 ecx, [eax + 0x47]
            //   304c05e4             | xor                 byte ptr [ebp + eax - 0x1c], cl
            //   40                   | inc                 eax
            //   83f814               | cmp                 eax, 0x14
            //   72f3                 | jb                  0xfffffff5
            //   8d45e4               | lea                 eax, [ebp - 0x1c]

        $sequence_25 = { 0f2805???????? 33c0 0f1145e4 c745f42331373d }
            // n = 4, score = 100
            //   0f2805????????       |                     
            //   33c0                 | xor                 eax, eax
            //   0f1145e4             | movups              xmmword ptr [ebp - 0x1c], xmm0
            //   c745f42331373d       | mov                 dword ptr [ebp - 0xc], 0x3d373123

        $sequence_26 = { 50 8d8dd0efffff e8???????? 56 }
            // n = 4, score = 100
            //   50                   | push                eax
            //   8d8dd0efffff         | lea                 ecx, [ebp - 0x1030]
            //   e8????????           |                     
            //   56                   | push                esi

        $sequence_27 = { 8d8dd0efffff 8bd8 e8???????? 8d73fc }
            // n = 4, score = 100
            //   8d8dd0efffff         | lea                 ecx, [ebp - 0x1030]
            //   8bd8                 | mov                 ebx, eax
            //   e8????????           |                     
            //   8d73fc               | lea                 esi, [ebx - 4]

        $sequence_28 = { 6a2c 8d44244c 56 50 }
            // n = 4, score = 100
            //   6a2c                 | push                0x2c
            //   8d44244c             | lea                 eax, [esp + 0x4c]
            //   56                   | push                esi
            //   50                   | push                eax

    condition:
        7 of them and filesize < 843776
}