rule win_rhysida_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.rhysida."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.rhysida"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 4c21f8 488903 4c89d8 4c0face03c 4889c3 4c89d0 4d8b28 }
            // n = 7, score = 400
            //   4c21f8               | cmp                 byte ptr [ebx], 0
            //   488903               | je                  0x38f
            //   4c89d8               | dec                 eax
            //   4c0face03c           | mov                 ecx, ebx
            //   4889c3               | dec                 eax
            //   4c89d0               | test                ebx, ebx
            //   4d8b28               | mov                 dword ptr [eax], 0

        $sequence_1 = { 8b45f0 0145fc 8b45fc 3b45f4 7cbb 8b45f4 83c002 }
            // n = 7, score = 400
            //   8b45f0               | dec                 eax
            //   0145fc               | arpl                dx, dx
            //   8b45fc               | dec                 eax
            //   3b45f4               | shl                 edx, 3
            //   7cbb                 | dec                 eax
            //   8b45f4               | lea                 ebx, [eax + edx]
            //   83c002               | dec                 eax

        $sequence_2 = { 85c0 8944242c 0f8582000000 488b4c2438 ff5720 8b44242c 4883c440 }
            // n = 7, score = 400
            //   85c0                 | dec                 eax
            //   8944242c             | lea                 ecx, [0xfcd1]
            //   0f8582000000         | dec                 eax
            //   488b4c2438           | cmp                 dword ptr [ebx], -1
            //   ff5720               | je                  0x1dc
            //   8b44242c             | dec                 eax
            //   4883c440             | lea                 ecx, [0xfcbf]

        $sequence_3 = { f30f1045d4 f30f1145d0 f30f1045d0 f30f1145cc 90 488d55cc 488d45d8 }
            // n = 7, score = 400
            //   f30f1045d4           | inc                 ecx
            //   f30f1145d0           | mov                 eax, 0x24
            //   f30f1045d0           | pop                 edi
            //   f30f1145cc           | pop                 ebp
            //   90                   | ret                 
            //   488d55cc             | dec                 eax
            //   488d45d8             | lea                 edx, [0x524b6]

        $sequence_4 = { 85c0 740c c7452c00000000 e9???????? 488b4500 8b4014 85c0 }
            // n = 7, score = 400
            //   85c0                 | mov                 dword ptr [esp + 0x30], ecx
            //   740c                 | dec                 eax
            //   c7452c00000000       | lea                 ecx, [ebp + 0xf80]
            //   e9????????           |                     
            //   488b4500             | dec                 eax
            //   8b4014               | lea                 ecx, [0x3c071]
            //   85c0                 | inc                 ecx

        $sequence_5 = { 8b5010 8b45dc 01d0 f30f2ac0 f30f594514 f30f58450c 488b45f8 }
            // n = 7, score = 400
            //   8b5010               | dec                 ecx
            //   8b45dc               | mov                 dword ptr [ecx], edi
            //   01d0                 | dec                 eax
            //   f30f2ac0             | test                esi, esi
            //   f30f594514           | je                  0xd5
            //   f30f58450c           | mov                 edx, ecx
            //   488b45f8             | inc                 ebp

        $sequence_6 = { 4883c002 4889c1 e8???????? 668945f4 488b4510 4883c004 488945e8 }
            // n = 7, score = 400
            //   4883c002             | mov                 eax, edx
            //   4889c1               | mov                 edx, eax
            //   e8????????           |                     
            //   668945f4             | dec                 eax
            //   488b4510             | mov                 ecx, dword ptr [ebp + 0x10]
            //   4883c004             | movss               xmm1, dword ptr [ebp - 0x60]
            //   488945e8             | dec                 eax

        $sequence_7 = { e8???????? b801000000 4881c4a0110000 5d c3 55 57 }
            // n = 7, score = 400
            //   e8????????           |                     
            //   b801000000           | dec                 eax
            //   4881c4a0110000       | sub                 esp, 0x28
            //   5d                   | dec                 eax
            //   c3                   | test                ecx, ecx
            //   55                   | dec                 eax
            //   57                   | mov                 esi, ecx

        $sequence_8 = { 4801d1 4801d0 41d1e9 660f6f01 458d51ff ba10000000 0f1100 }
            // n = 7, score = 400
            //   4801d1               | mov                 edx, edi
            //   4801d0               | dec                 eax
            //   41d1e9               | mov                 ecx, edi
            //   660f6f01             | call                dword ptr [esi + 0x68]
            //   458d51ff             | call                dword ptr [esi + 0x60]
            //   ba10000000           | test                eax, eax
            //   0f1100               | jne                 0x19b3

        $sequence_9 = { 85c0 75ca 4889ea 4889d9 e8???????? 83c001 7448 }
            // n = 7, score = 400
            //   85c0                 | lea                 ecx, [0x271c4]
            //   75ca                 | dec                 eax
            //   4889ea               | mov                 dword ptr [ebx + 0x10], eax
            //   4889d9               | mov                 eax, esi
            //   e8????????           |                     
            //   83c001               | dec                 eax
            //   7448                 | add                 esp, 0x28

    condition:
        7 of them and filesize < 2369536
}