rule win_rifdoor_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.rifdoor."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.rifdoor"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 8d4318 b9???????? 895c2414 e8???????? }
            // n = 4, score = 200
            //   8d4318               | lea                 eax, [ebx + 0x18]
            //   b9????????           |                     
            //   895c2414             | mov                 dword ptr [esp + 0x14], ebx
            //   e8????????           |                     

        $sequence_1 = { 395c2414 7529 395c2418 7523 }
            // n = 4, score = 200
            //   395c2414             | cmp                 dword ptr [esp + 0x14], ebx
            //   7529                 | jne                 0x2b
            //   395c2418             | cmp                 dword ptr [esp + 0x18], ebx
            //   7523                 | jne                 0x25

        $sequence_2 = { 8b15???????? 83c408 6a00 6a12 8d4c240c 51 }
            // n = 6, score = 200
            //   8b15????????         |                     
            //   83c408               | add                 esp, 8
            //   6a00                 | push                0
            //   6a12                 | push                0x12
            //   8d4c240c             | lea                 ecx, [esp + 0xc]
            //   51                   | push                ecx

        $sequence_3 = { 40 0080a640008a 46 0323 }
            // n = 4, score = 200
            //   40                   | inc                 eax
            //   0080a640008a         | add                 byte ptr [eax - 0x75ffbf5a], al
            //   46                   | inc                 esi
            //   0323                 | add                 esp, dword ptr [ebx]

        $sequence_4 = { 8b542414 8bf8 52 57 e8???????? 83c40c }
            // n = 6, score = 200
            //   8b542414             | mov                 edx, dword ptr [esp + 0x14]
            //   8bf8                 | mov                 edi, eax
            //   52                   | push                edx
            //   57                   | push                edi
            //   e8????????           |                     
            //   83c40c               | add                 esp, 0xc

        $sequence_5 = { 83c40c 6bc930 8975e0 8db1304b4100 }
            // n = 4, score = 200
            //   83c40c               | add                 esp, 0xc
            //   6bc930               | imul                ecx, ecx, 0x30
            //   8975e0               | mov                 dword ptr [ebp - 0x20], esi
            //   8db1304b4100         | lea                 esi, [ecx + 0x414b30]

        $sequence_6 = { 33dd c1e311 c1e808 0bc3 }
            // n = 4, score = 200
            //   33dd                 | xor                 ebx, ebp
            //   c1e311               | shl                 ebx, 0x11
            //   c1e808               | shr                 eax, 8
            //   0bc3                 | or                  eax, ebx

        $sequence_7 = { ffd6 a3???????? 895c2410 8d4c2410 51 8d4310 }
            // n = 6, score = 200
            //   ffd6                 | call                esi
            //   a3????????           |                     
            //   895c2410             | mov                 dword ptr [esp + 0x10], ebx
            //   8d4c2410             | lea                 ecx, [esp + 0x10]
            //   51                   | push                ecx
            //   8d4310               | lea                 eax, [ebx + 0x10]

        $sequence_8 = { 8d95e8fbffff 52 ff15???????? 8d85e8fbffff 50 8bc8 51 }
            // n = 7, score = 100
            //   8d95e8fbffff         | lea                 edx, [ebp - 0x418]
            //   52                   | push                edx
            //   ff15????????         |                     
            //   8d85e8fbffff         | lea                 eax, [ebp - 0x418]
            //   50                   | push                eax
            //   8bc8                 | mov                 ecx, eax
            //   51                   | push                ecx

        $sequence_9 = { c745e888130000 ff15???????? 8bc6 8b4dfc 5f 33cd 5e }
            // n = 7, score = 100
            //   c745e888130000       | mov                 dword ptr [ebp - 0x18], 0x1388
            //   ff15????????         |                     
            //   8bc6                 | mov                 eax, esi
            //   8b4dfc               | mov                 ecx, dword ptr [ebp - 4]
            //   5f                   | pop                 edi
            //   33cd                 | xor                 ecx, ebp
            //   5e                   | pop                 esi

        $sequence_10 = { 46 8935???????? e9???????? 5f }
            // n = 4, score = 100
            //   46                   | inc                 esi
            //   8935????????         |                     
            //   e9????????           |                     
            //   5f                   | pop                 edi

        $sequence_11 = { 59 83f83c 762a 56 e8???????? 8d0445bc124100 }
            // n = 6, score = 100
            //   59                   | pop                 ecx
            //   83f83c               | cmp                 eax, 0x3c
            //   762a                 | jbe                 0x2c
            //   56                   | push                esi
            //   e8????????           |                     
            //   8d0445bc124100       | lea                 eax, [eax*2 + 0x4112bc]

        $sequence_12 = { 51 8d9574fcffff 52 6a00 6a00 56 50 }
            // n = 7, score = 100
            //   51                   | push                ecx
            //   8d9574fcffff         | lea                 edx, [ebp - 0x38c]
            //   52                   | push                edx
            //   6a00                 | push                0
            //   6a00                 | push                0
            //   56                   | push                esi
            //   50                   | push                eax

        $sequence_13 = { 83ffff 0f84bb000000 53 53 8d95f4f7ffff 52 }
            // n = 6, score = 100
            //   83ffff               | cmp                 edi, -1
            //   0f84bb000000         | je                  0xc1
            //   53                   | push                ebx
            //   53                   | push                ebx
            //   8d95f4f7ffff         | lea                 edx, [ebp - 0x80c]
            //   52                   | push                edx

        $sequence_14 = { 51 56 89b5f4feffff ffd7 85c0 7413 5f }
            // n = 7, score = 100
            //   51                   | push                ecx
            //   56                   | push                esi
            //   89b5f4feffff         | mov                 dword ptr [ebp - 0x10c], esi
            //   ffd7                 | call                edi
            //   85c0                 | test                eax, eax
            //   7413                 | je                  0x15
            //   5f                   | pop                 edi

        $sequence_15 = { 53 57 8d858cf8ffff 50 8d8d24ffffff }
            // n = 5, score = 100
            //   53                   | push                ebx
            //   57                   | push                edi
            //   8d858cf8ffff         | lea                 eax, [ebp - 0x774]
            //   50                   | push                eax
            //   8d8d24ffffff         | lea                 ecx, [ebp - 0xdc]

    condition:
        7 of them and filesize < 212992
}