rule win_rofin_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.rofin."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.rofin"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 49 8bd9 83fbfd 7605 e8???????? 8b6c245c 8b4d04 }
            // n = 7, score = 100
            //   49                   | dec                 ecx
            //   8bd9                 | mov                 ebx, ecx
            //   83fbfd               | cmp                 ebx, -3
            //   7605                 | jbe                 7
            //   e8????????           |                     
            //   8b6c245c             | mov                 ebp, dword ptr [esp + 0x5c]
            //   8b4d04               | mov                 ecx, dword ptr [ebp + 4]

        $sequence_1 = { 837c243c0a 7568 8b54241c 52 ff15???????? 89442410 8b44241a }
            // n = 7, score = 100
            //   837c243c0a           | cmp                 dword ptr [esp + 0x3c], 0xa
            //   7568                 | jne                 0x6a
            //   8b54241c             | mov                 edx, dword ptr [esp + 0x1c]
            //   52                   | push                edx
            //   ff15????????         |                     
            //   89442410             | mov                 dword ptr [esp + 0x10], eax
            //   8b44241a             | mov                 eax, dword ptr [esp + 0x1a]

        $sequence_2 = { 56 ff15???????? 8be8 ffd3 56 ff15???????? 33c0 }
            // n = 7, score = 100
            //   56                   | push                esi
            //   ff15????????         |                     
            //   8be8                 | mov                 ebp, eax
            //   ffd3                 | call                ebx
            //   56                   | push                esi
            //   ff15????????         |                     
            //   33c0                 | xor                 eax, eax

        $sequence_3 = { e8???????? 83c404 895c2418 8b84240c090000 3bc3 7409 50 }
            // n = 7, score = 100
            //   e8????????           |                     
            //   83c404               | add                 esp, 4
            //   895c2418             | mov                 dword ptr [esp + 0x18], ebx
            //   8b84240c090000       | mov                 eax, dword ptr [esp + 0x90c]
            //   3bc3                 | cmp                 eax, ebx
            //   7409                 | je                  0xb
            //   50                   | push                eax

        $sequence_4 = { 53 8bc8 8a1c38 c1f903 8d3411 8bc8 83e107 }
            // n = 7, score = 100
            //   53                   | push                ebx
            //   8bc8                 | mov                 ecx, eax
            //   8a1c38               | mov                 bl, byte ptr [eax + edi]
            //   c1f903               | sar                 ecx, 3
            //   8d3411               | lea                 esi, [ecx + edx]
            //   8bc8                 | mov                 ecx, eax
            //   83e107               | and                 ecx, 7

        $sequence_5 = { 3bc1 720a c744241202000000 eb3d 8b4c2422 8b461c 3bc8 }
            // n = 7, score = 100
            //   3bc1                 | cmp                 eax, ecx
            //   720a                 | jb                  0xc
            //   c744241202000000     | mov                 dword ptr [esp + 0x12], 2
            //   eb3d                 | jmp                 0x3f
            //   8b4c2422             | mov                 ecx, dword ptr [esp + 0x22]
            //   8b461c               | mov                 eax, dword ptr [esi + 0x1c]
            //   3bc8                 | cmp                 ecx, eax

        $sequence_6 = { f2ae f7d1 49 51 56 8d4c2418 e8???????? }
            // n = 7, score = 100
            //   f2ae                 | repne scasb         al, byte ptr es:[edi]
            //   f7d1                 | not                 ecx
            //   49                   | dec                 ecx
            //   51                   | push                ecx
            //   56                   | push                esi
            //   8d4c2418             | lea                 ecx, [esp + 0x18]
            //   e8????????           |                     

        $sequence_7 = { 3bc8 745d 8b4610 85c0 741b 8b7e0c 8d5f10 }
            // n = 7, score = 100
            //   3bc8                 | cmp                 ecx, eax
            //   745d                 | je                  0x5f
            //   8b4610               | mov                 eax, dword ptr [esi + 0x10]
            //   85c0                 | test                eax, eax
            //   741b                 | je                  0x1d
            //   8b7e0c               | mov                 edi, dword ptr [esi + 0xc]
            //   8d5f10               | lea                 ebx, [edi + 0x10]

        $sequence_8 = { ff15???????? 83f8ff 7508 ff15???????? 8bd8 8d54240c c744240c00000000 }
            // n = 7, score = 100
            //   ff15????????         |                     
            //   83f8ff               | cmp                 eax, -1
            //   7508                 | jne                 0xa
            //   ff15????????         |                     
            //   8bd8                 | mov                 ebx, eax
            //   8d54240c             | lea                 edx, [esp + 0xc]
            //   c744240c00000000     | mov                 dword ptr [esp + 0xc], 0

        $sequence_9 = { 83c604 83c410 83c714 81fe???????? 7cdf 8bcd e8???????? }
            // n = 7, score = 100
            //   83c604               | add                 esi, 4
            //   83c410               | add                 esp, 0x10
            //   83c714               | add                 edi, 0x14
            //   81fe????????         |                     
            //   7cdf                 | jl                  0xffffffe1
            //   8bcd                 | mov                 ecx, ebp
            //   e8????????           |                     

    condition:
        7 of them and filesize < 409600
}