rule win_romcom_rat_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.romcom_rat."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.romcom_rat"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 4e8d044580000000 33d2 498bcc e8???????? 498bc6 48ffc0 42381c28 }
            // n = 7, score = 100
            //   4e8d044580000000     | jne                 0x1ffe
            //   33d2                 | mov                 bl, byte ptr [esp + 0x33]
            //   498bcc               | inc                 esp
            //   e8????????           |                     
            //   498bc6               | mov                 ah, byte ptr [edi + 8]
            //   48ffc0               | dec                 esp
            //   42381c28             | mov                 eax, dword ptr [esp + 0x80]

        $sequence_1 = { 8a0401 41884500 49ffc5 ffc3 41b401 488b0f 4885c9 }
            // n = 7, score = 100
            //   8a0401               | mov                 eax, esi
            //   41884500             | inc                 ebp
            //   49ffc5               | test                al, al
            //   ffc3                 | je                  0x454
            //   41b401               | mov                 eax, 0x10
            //   488b0f               | and                 cl, bl
            //   4885c9               | shr                 eax, 8

        $sequence_2 = { e8???????? 488d05d4440800 4883c328 483bd8 75e8 488b5c2430 488bc7 }
            // n = 7, score = 100
            //   e8????????           |                     
            //   488d05d4440800       | inc                 esp
            //   4883c328             | mov                 edx, eax
            //   483bd8               | inc                 ebp
            //   75e8                 | xor                 eax, eax
            //   488b5c2430           | inc                 ebp
            //   488bc7               | lea                 ecx, [eax + 4]

        $sequence_3 = { 4889742410 55 488dac2440ffffff 4881ecc0010000 488b05???????? 4833c4 488985b0000000 }
            // n = 7, score = 100
            //   4889742410           | sub                 esp, 0x20
            //   55                   | dec                 eax
            //   488dac2440ffffff     | cmp                 dword ptr [edx + 0x18], 0x10
            //   4881ecc0010000       | dec                 eax
            //   488b05????????       |                     
            //   4833c4               | mov                 ebx, edx
            //   488985b0000000       | dec                 eax

        $sequence_4 = { 66413919 75f6 4c8bc6 488d542448 488d4c2470 e8???????? }
            // n = 6, score = 100
            //   66413919             | mov                 byte ptr [esi], bh
            //   75f6                 | jmp                 0x85d
            //   4c8bc6               | mov                 byte ptr [esi], bl
            //   488d542448           | dec                 eax
            //   488d4c2470           | mov                 edx, dword ptr [ebp - 0x31]
            //   e8????????           |                     

        $sequence_5 = { c744243810270000 89442430 488b05???????? 4889442428 488364242000 41ffd5 }
            // n = 6, score = 100
            //   c744243810270000     | lea                 eax, [esp + 0x78]
            //   89442430             | dec                 eax
            //   488b05????????       |                     
            //   4889442428           | mov                 dword ptr [esp + 0x20], eax
            //   488364242000         | mov                 edi, 0x109
            //   41ffd5               | inc                 esp

        $sequence_6 = { 4883f81f 0f87e7140000 e8???????? 488d85e8110000 49ffc6 46382430 75f7 }
            // n = 7, score = 100
            //   4883f81f             | xorps               xmm0, xmm0
            //   0f87e7140000         | xor                 eax, eax
            //   e8????????           |                     
            //   488d85e8110000       | movups              xmmword ptr [esp + 0x40], xmm0
            //   49ffc6               | dec                 eax
            //   46382430             | mov                 dword ptr [esp + 0x70], eax
            //   75f7                 | dec                 esp

        $sequence_7 = { 8ad9 eb0a 488b55c8 4c8b45b0 32db 41f6c410 }
            // n = 6, score = 100
            //   8ad9                 | dec                 eax
            //   eb0a                 | mov                 edi, eax
            //   488b55c8             | jmp                 0x11a0
            //   4c8b45b0             | inc                 ebp
            //   32db                 | xor                 ebp, ebp
            //   41f6c410             | dec                 esp

        $sequence_8 = { 4c8975b0 4c8b6de8 488b75d0 32c9 884da8 4533f6 4533e4 }
            // n = 7, score = 100
            //   4c8975b0             | mov                 dword ptr [esp + 0x58], 0x47007d
            //   4c8b6de8             | mov                 dword ptr [esp + 0x5c], 0x690062
            //   488b75d0             | mov                 dword ptr [esp + 0x60], 0x6a006d
            //   32c9                 | mov                 dword ptr [esp + 0x64], 0x67007e
            //   884da8               | mov                 dword ptr [esp + 0x68], 0x790033
            //   4533f6               | mov                 dword ptr [esp + 0x54], 0x76007c
            //   4533e4               | mov                 dword ptr [esp + 0x58], 0x780060

        $sequence_9 = { 498bd4 488bcf e8???????? 33db 84c0 758b 448bfe }
            // n = 7, score = 100
            //   498bd4               | xor                 ebx, ebx
            //   488bcf               | mov                 esi, 1
            //   e8????????           |                     
            //   33db                 | and                 dword ptr [ebx + 8], 0
            //   84c0                 | dec                 eax
            //   758b                 | lea                 eax, [0x57f37]
            //   448bfe               | dec                 eax

    condition:
        7 of them and filesize < 1211392
}