rule win_rover_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.rover."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.rover"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 33c0 eb76 83bb9802000000 7504 33c0 eb69 }
            // n = 6, score = 100
            //   33c0                 | xor                 eax, eax
            //   eb76                 | jmp                 0x78
            //   83bb9802000000       | cmp                 dword ptr [ebx + 0x298], 0
            //   7504                 | jne                 6
            //   33c0                 | xor                 eax, eax
            //   eb69                 | jmp                 0x6b

        $sequence_1 = { 33c0 eb05 1bc0 83d8ff 85c0 0f84a3020000 8d8424bc000000 }
            // n = 7, score = 100
            //   33c0                 | xor                 eax, eax
            //   eb05                 | jmp                 7
            //   1bc0                 | sbb                 eax, eax
            //   83d8ff               | sbb                 eax, -1
            //   85c0                 | test                eax, eax
            //   0f84a3020000         | je                  0x2a9
            //   8d8424bc000000       | lea                 eax, [esp + 0xbc]

        $sequence_2 = { 0f95c1 33c0 898e80020000 8b97f0020000 8996a0020000 398704040000 0f95c0 }
            // n = 7, score = 100
            //   0f95c1               | setne               cl
            //   33c0                 | xor                 eax, eax
            //   898e80020000         | mov                 dword ptr [esi + 0x280], ecx
            //   8b97f0020000         | mov                 edx, dword ptr [edi + 0x2f0]
            //   8996a0020000         | mov                 dword ptr [esi + 0x2a0], edx
            //   398704040000         | cmp                 dword ptr [edi + 0x404], eax
            //   0f95c0               | setne               al

        $sequence_3 = { 83c8ff 8b4c2450 64890d00000000 59 5e 5b 8b4c2440 }
            // n = 7, score = 100
            //   83c8ff               | or                  eax, 0xffffffff
            //   8b4c2450             | mov                 ecx, dword ptr [esp + 0x50]
            //   64890d00000000       | mov                 dword ptr fs:[0], ecx
            //   59                   | pop                 ecx
            //   5e                   | pop                 esi
            //   5b                   | pop                 ebx
            //   8b4c2440             | mov                 ecx, dword ptr [esp + 0x40]

        $sequence_4 = { 89870c030000 3bc3 0f854bfcffff 5b 5f 5e b81b000000 }
            // n = 7, score = 100
            //   89870c030000         | mov                 dword ptr [edi + 0x30c], eax
            //   3bc3                 | cmp                 eax, ebx
            //   0f854bfcffff         | jne                 0xfffffc51
            //   5b                   | pop                 ebx
            //   5f                   | pop                 edi
            //   5e                   | pop                 esi
            //   b81b000000           | mov                 eax, 0x1b

        $sequence_5 = { 751f 5f c6860301000001 5e 5d b801000000 5b }
            // n = 7, score = 100
            //   751f                 | jne                 0x21
            //   5f                   | pop                 edi
            //   c6860301000001       | mov                 byte ptr [esi + 0x103], 1
            //   5e                   | pop                 esi
            //   5d                   | pop                 ebp
            //   b801000000           | mov                 eax, 1
            //   5b                   | pop                 ebx

        $sequence_6 = { 396c245c 7508 c744245c22a14400 396e0c 7428 }
            // n = 5, score = 100
            //   396c245c             | cmp                 dword ptr [esp + 0x5c], ebp
            //   7508                 | jne                 0xa
            //   c744245c22a14400     | mov                 dword ptr [esp + 0x5c], 0x44a122
            //   396e0c               | cmp                 dword ptr [esi + 0xc], ebp
            //   7428                 | je                  0x2a

        $sequence_7 = { d1c6 83f905 72d9 8b4c2410 8b19 895c2410 85db }
            // n = 7, score = 100
            //   d1c6                 | rol                 esi, 1
            //   83f905               | cmp                 ecx, 5
            //   72d9                 | jb                  0xffffffdb
            //   8b4c2410             | mov                 ecx, dword ptr [esp + 0x10]
            //   8b19                 | mov                 ebx, dword ptr [ecx]
            //   895c2410             | mov                 dword ptr [esp + 0x10], ebx
            //   85db                 | test                ebx, ebx

        $sequence_8 = { 50 e8???????? 83c408 85c0 0f85bc010000 8d4c247c 894c240c }
            // n = 7, score = 100
            //   50                   | push                eax
            //   e8????????           |                     
            //   83c408               | add                 esp, 8
            //   85c0                 | test                eax, eax
            //   0f85bc010000         | jne                 0x1c2
            //   8d4c247c             | lea                 ecx, [esp + 0x7c]
            //   894c240c             | mov                 dword ptr [esp + 0xc], ecx

        $sequence_9 = { 8be8 83c408 85ed 743d 45 6a3a 55 }
            // n = 7, score = 100
            //   8be8                 | mov                 ebp, eax
            //   83c408               | add                 esp, 8
            //   85ed                 | test                ebp, ebp
            //   743d                 | je                  0x3f
            //   45                   | inc                 ebp
            //   6a3a                 | push                0x3a
            //   55                   | push                ebp

    condition:
        7 of them and filesize < 704512
}