rule win_ruckguv_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.ruckguv."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.ruckguv"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 53 56 fe4513 0fb64d13 8d3401 8a16 0055ff }
            // n = 7, score = 200
            //   53                   | push                ebx
            //   56                   | push                esi
            //   fe4513               | inc                 byte ptr [ebp + 0x13]
            //   0fb64d13             | movzx               ecx, byte ptr [ebp + 0x13]
            //   8d3401               | lea                 esi, [ecx + eax]
            //   8a16                 | mov                 dl, byte ptr [esi]
            //   0055ff               | add                 byte ptr [ebp - 1], dl

        $sequence_1 = { 85c0 747f 56 03c3 50 e8???????? }
            // n = 6, score = 200
            //   85c0                 | test                eax, eax
            //   747f                 | je                  0x81
            //   56                   | push                esi
            //   03c3                 | add                 eax, ebx
            //   50                   | push                eax
            //   e8????????           |                     

        $sequence_2 = { 8b4834 3bf1 7504 b001 eb7c 8b80a0000000 }
            // n = 6, score = 200
            //   8b4834               | mov                 ecx, dword ptr [eax + 0x34]
            //   3bf1                 | cmp                 esi, ecx
            //   7504                 | jne                 6
            //   b001                 | mov                 al, 1
            //   eb7c                 | jmp                 0x7e
            //   8b80a0000000         | mov                 eax, dword ptr [eax + 0xa0]

        $sequence_3 = { 6a01 e8???????? 83c428 8d8da0feffff 51 }
            // n = 5, score = 200
            //   6a01                 | push                1
            //   e8????????           |                     
            //   83c428               | add                 esp, 0x28
            //   8d8da0feffff         | lea                 ecx, [ebp - 0x160]
            //   51                   | push                ecx

        $sequence_4 = { 05f8000000 813f50450000 894508 0f851c010000 8b5f50 68fe6a7a69 }
            // n = 6, score = 200
            //   05f8000000           | add                 eax, 0xf8
            //   813f50450000         | cmp                 dword ptr [edi], 0x4550
            //   894508               | mov                 dword ptr [ebp + 8], eax
            //   0f851c010000         | jne                 0x122
            //   8b5f50               | mov                 ebx, dword ptr [edi + 0x50]
            //   68fe6a7a69           | push                0x697a6afe

        $sequence_5 = { 0fb645fe 03c1 8a18 fe45ff 881e 8810 660fb645ff }
            // n = 7, score = 200
            //   0fb645fe             | movzx               eax, byte ptr [ebp - 2]
            //   03c1                 | add                 eax, ecx
            //   8a18                 | mov                 bl, byte ptr [eax]
            //   fe45ff               | inc                 byte ptr [ebp - 1]
            //   881e                 | mov                 byte ptr [esi], bl
            //   8810                 | mov                 byte ptr [eax], dl
            //   660fb645ff           | movzx               ax, byte ptr [ebp - 1]

        $sequence_6 = { 8d859cfdffff 50 68???????? e8???????? 6814f1f808 6a01 897558 }
            // n = 7, score = 200
            //   8d859cfdffff         | lea                 eax, [ebp - 0x264]
            //   50                   | push                eax
            //   68????????           |                     
            //   e8????????           |                     
            //   6814f1f808           | push                0x8f8f114
            //   6a01                 | push                1
            //   897558               | mov                 dword ptr [ebp + 0x58], esi

        $sequence_7 = { ff74240c ff74240c ffd0 c3 685f70353a 6a01 e8???????? }
            // n = 7, score = 200
            //   ff74240c             | push                dword ptr [esp + 0xc]
            //   ff74240c             | push                dword ptr [esp + 0xc]
            //   ffd0                 | call                eax
            //   c3                   | ret                 
            //   685f70353a           | push                0x3a35705f
            //   6a01                 | push                1
            //   e8????????           |                     

        $sequence_8 = { 8b37 85f6 7503 8b7710 03f3 }
            // n = 5, score = 200
            //   8b37                 | mov                 esi, dword ptr [edi]
            //   85f6                 | test                esi, esi
            //   7503                 | jne                 5
            //   8b7710               | mov                 esi, dword ptr [edi + 0x10]
            //   03f3                 | add                 esi, ebx

        $sequence_9 = { 53 33d2 56 57 8855ff 8855fe 889100010000 }
            // n = 7, score = 200
            //   53                   | push                ebx
            //   33d2                 | xor                 edx, edx
            //   56                   | push                esi
            //   57                   | push                edi
            //   8855ff               | mov                 byte ptr [ebp - 1], dl
            //   8855fe               | mov                 byte ptr [ebp - 2], dl
            //   889100010000         | mov                 byte ptr [ecx + 0x100], dl

    condition:
        7 of them and filesize < 41024
}