rule win_rumish_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.rumish."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.rumish"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 898554ffffff 83bd54ffffff00 0f85de000000 c7854cffffff00000000 eb0f 8b854cffffff 83c001 }
            // n = 7, score = 100
            //   898554ffffff         | mov                 dword ptr [ebp - 0xac], eax
            //   83bd54ffffff00       | cmp                 dword ptr [ebp - 0xac], 0
            //   0f85de000000         | jne                 0xe4
            //   c7854cffffff00000000     | mov    dword ptr [ebp - 0xb4], 0
            //   eb0f                 | jmp                 0x11
            //   8b854cffffff         | mov                 eax, dword ptr [ebp - 0xb4]
            //   83c001               | add                 eax, 1

        $sequence_1 = { dc35???????? dc0d???????? dc05???????? d97df6 0fb745f6 0d000c0000 }
            // n = 6, score = 100
            //   dc35????????         |                     
            //   dc0d????????         |                     
            //   dc05????????         |                     
            //   d97df6               | fnstcw              word ptr [ebp - 0xa]
            //   0fb745f6             | movzx               eax, word ptr [ebp - 0xa]
            //   0d000c0000           | or                  eax, 0xc00

        $sequence_2 = { 8d4dd4 e8???????? 8b4db0 8908 8b55a0 3b55ec 7d27 }
            // n = 7, score = 100
            //   8d4dd4               | lea                 ecx, [ebp - 0x2c]
            //   e8????????           |                     
            //   8b4db0               | mov                 ecx, dword ptr [ebp - 0x50]
            //   8908                 | mov                 dword ptr [eax], ecx
            //   8b55a0               | mov                 edx, dword ptr [ebp - 0x60]
            //   3b55ec               | cmp                 edx, dword ptr [ebp - 0x14]
            //   7d27                 | jge                 0x29

        $sequence_3 = { 7738 8b951cffffff ff24957cf54300 68???????? 8d4d94 e8???????? eb1c }
            // n = 7, score = 100
            //   7738                 | ja                  0x3a
            //   8b951cffffff         | mov                 edx, dword ptr [ebp - 0xe4]
            //   ff24957cf54300       | jmp                 dword ptr [edx*4 + 0x43f57c]
            //   68????????           |                     
            //   8d4d94               | lea                 ecx, [ebp - 0x6c]
            //   e8????????           |                     
            //   eb1c                 | jmp                 0x1e

        $sequence_4 = { 8d8d68ffffff e8???????? 8d8d60ffffff 51 8d8d68ffffff e8???????? 8b9558ffffff }
            // n = 7, score = 100
            //   8d8d68ffffff         | lea                 ecx, [ebp - 0x98]
            //   e8????????           |                     
            //   8d8d60ffffff         | lea                 ecx, [ebp - 0xa0]
            //   51                   | push                ecx
            //   8d8d68ffffff         | lea                 ecx, [ebp - 0x98]
            //   e8????????           |                     
            //   8b9558ffffff         | mov                 edx, dword ptr [ebp - 0xa8]

        $sequence_5 = { 55 8bec 53 e8???????? b9???????? e8???????? }
            // n = 6, score = 100
            //   55                   | push                ebp
            //   8bec                 | mov                 ebp, esp
            //   53                   | push                ebx
            //   e8????????           |                     
            //   b9????????           |                     
            //   e8????????           |                     

        $sequence_6 = { eb10 68???????? 8d8d4cffffff e8???????? e9???????? 0fbf458c 8985d0feffff }
            // n = 7, score = 100
            //   eb10                 | jmp                 0x12
            //   68????????           |                     
            //   8d8d4cffffff         | lea                 ecx, [ebp - 0xb4]
            //   e8????????           |                     
            //   e9????????           |                     
            //   0fbf458c             | movsx               eax, word ptr [ebp - 0x74]
            //   8985d0feffff         | mov                 dword ptr [ebp - 0x130], eax

        $sequence_7 = { 83e10f c1e102 0fb655f5 81e2c0000000 c1fa06 0bca }
            // n = 6, score = 100
            //   83e10f               | and                 ecx, 0xf
            //   c1e102               | shl                 ecx, 2
            //   0fb655f5             | movzx               edx, byte ptr [ebp - 0xb]
            //   81e2c0000000         | and                 edx, 0xc0
            //   c1fa06               | sar                 edx, 6
            //   0bca                 | or                  ecx, edx

        $sequence_8 = { 8b85c0fcffff 83c001 8985c0fcffff 8b8dc0fcffff 3b8df4fcffff 0f8de4000000 8b95c4fcffff }
            // n = 7, score = 100
            //   8b85c0fcffff         | mov                 eax, dword ptr [ebp - 0x340]
            //   83c001               | add                 eax, 1
            //   8985c0fcffff         | mov                 dword ptr [ebp - 0x340], eax
            //   8b8dc0fcffff         | mov                 ecx, dword ptr [ebp - 0x340]
            //   3b8df4fcffff         | cmp                 ecx, dword ptr [ebp - 0x30c]
            //   0f8de4000000         | jge                 0xea
            //   8b95c4fcffff         | mov                 edx, dword ptr [ebp - 0x33c]

        $sequence_9 = { d918 8b8dc4feffff d901 dc1d???????? dfe0 f6c444 7b11 }
            // n = 7, score = 100
            //   d918                 | fstp                dword ptr [eax]
            //   8b8dc4feffff         | mov                 ecx, dword ptr [ebp - 0x13c]
            //   d901                 | fld                 dword ptr [ecx]
            //   dc1d????????         |                     
            //   dfe0                 | fnstsw              ax
            //   f6c444               | test                ah, 0x44
            //   7b11                 | jnp                 0x13

    condition:
        7 of them and filesize < 770048
}