rule win_saigon_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.saigon."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.saigon"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 488be9 215c2460 ff15???????? 4c8d4c2460 8bf0 4533c0 488bcd }
            // n = 7, score = 200
            //   488be9               | test                eax, eax
            //   215c2460             | jne                 0x2cb
            //   ff15????????         |                     
            //   4c8d4c2460           | inc                 eax
            //   8bf0                 | mov                 bh, ch
            //   4533c0               | jmp                 0x29e
            //   488bcd               | lea                 edi, [ebp + 1]

        $sequence_1 = { 41b800800000 488bcf ff15???????? eb08 ff15???????? 8bd8 }
            // n = 6, score = 200
            //   41b800800000         | cmp                 ebx, edi
            //   488bcf               | je                  0x1a0c
            //   ff15????????         |                     
            //   eb08                 | mov                 edx, dword ptr [esp + 0x238]
            //   ff15????????         |                     
            //   8bd8                 | mov                 ebx, eax

        $sequence_2 = { e8???????? 488d8c24b0040000 4c8bc3 33d2 }
            // n = 4, score = 200
            //   e8????????           |                     
            //   488d8c24b0040000     | js                  0xd71
            //   4c8bc3               | dec                 eax
            //   33d2                 | mov                 ebp, dword ptr [esp + 0x50]

        $sequence_3 = { 4533db e9???????? 33c0 4c8d4c2450 }
            // n = 4, score = 200
            //   4533db               | mov                 dword ptr [esp + ebx*8 + 8], eax
            //   e9????????           |                     
            //   33c0                 | dec                 ebp
            //   4c8d4c2450           | mov                 dword ptr [esp + ebx*8 + 0x18], edi

        $sequence_4 = { ff15???????? 33db 483beb 7412 }
            // n = 4, score = 200
            //   ff15????????         |                     
            //   33db                 | mov                 dword ptr [esp + 0x1c0], esi
            //   483beb               | dec                 eax
            //   7412                 | cmp                 eax, esi

        $sequence_5 = { 33d2 ff15???????? eb03 418bdf 448b8c24e0000000 488bbc24e0000000 }
            // n = 6, score = 200
            //   33d2                 | mov                 ebp, dword ptr [esp + 0x50]
            //   ff15????????         |                     
            //   eb03                 | and                 word ptr [esp + 0xf8], 0
            //   418bdf               | xor                 eax, eax
            //   448b8c24e0000000     | test                ebx, ebx
            //   488bbc24e0000000     | js                  0x6ff

        $sequence_6 = { 33d2 8bd8 ff15???????? eb0f bb08000000 }
            // n = 5, score = 200
            //   33d2                 | dec                 eax
            //   8bd8                 | lea                 ecx, [esp + 0x540]
            //   ff15????????         |                     
            //   eb0f                 | dec                 esp
            //   bb08000000           | mov                 eax, ebx

        $sequence_7 = { 4c8bc3 33d2 e8???????? 488d8c24c0000000 }
            // n = 4, score = 200
            //   4c8bc3               | mov                 ecx, edi
            //   33d2                 | mov                 dword ptr [esp + 0x30], eax
            //   e8????????           |                     
            //   488d8c24c0000000     | dec                 eax

        $sequence_8 = { 488d542468 4889442468 488b05???????? 418d4802 41b9e0930400 4889442470 ff15???????? }
            // n = 7, score = 200
            //   488d542468           | cmp                 esi, eax
            //   4889442468           | jl                  0x30b
            //   488b05????????       |                     
            //   418d4802             | inc                 ecx
            //   41b9e0930400         | mov                 eax, esp
            //   4889442470           | cdq                 
            //   ff15????????         |                     

        $sequence_9 = { 4183cfff 483bce 7439 33d2 }
            // n = 4, score = 200
            //   4183cfff             | cmp                 eax, esi
            //   483bce               | je                  0x1d1
            //   7439                 | dec                 eax
            //   33d2                 | lea                 ecx, [0xabe1]

    condition:
        7 of them and filesize < 147456
}