rule win_sality_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.sality."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.sality"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 6a00 8d85f4efffff 50 6a00 6a00 68???????? }
            // n = 6, score = 400
            //   6a00                 | push                0
            //   8d85f4efffff         | lea                 eax, [ebp - 0x100c]
            //   50                   | push                eax
            //   6a00                 | push                0
            //   6a00                 | push                0
            //   68????????           |                     

        $sequence_1 = { 51 ff15???????? ba01000000 85d2 742e }
            // n = 5, score = 400
            //   51                   | push                ecx
            //   ff15????????         |                     
            //   ba01000000           | mov                 edx, 1
            //   85d2                 | test                edx, edx
            //   742e                 | je                  0x30

        $sequence_2 = { 837d0804 0f8457020000 837d0803 0f844d020000 e8???????? 25ffff0000 33d2 }
            // n = 7, score = 400
            //   837d0804             | cmp                 dword ptr [ebp + 8], 4
            //   0f8457020000         | je                  0x25d
            //   837d0803             | cmp                 dword ptr [ebp + 8], 3
            //   0f844d020000         | je                  0x253
            //   e8????????           |                     
            //   25ffff0000           | and                 eax, 0xffff
            //   33d2                 | xor                 edx, edx

        $sequence_3 = { 51 ff15???????? c705????????00000000 8d9500f0ffff }
            // n = 4, score = 400
            //   51                   | push                ecx
            //   ff15????????         |                     
            //   c705????????00000000     |     
            //   8d9500f0ffff         | lea                 edx, [ebp - 0x1000]

        $sequence_4 = { 837d0804 0f84e9000000 8b551c 3b5520 }
            // n = 4, score = 400
            //   837d0804             | cmp                 dword ptr [ebp + 8], 4
            //   0f84e9000000         | je                  0xef
            //   8b551c               | mov                 edx, dword ptr [ebp + 0x1c]
            //   3b5520               | cmp                 edx, dword ptr [ebp + 0x20]

        $sequence_5 = { 51 ff15???????? c6850cebffff00 68???????? }
            // n = 4, score = 400
            //   51                   | push                ecx
            //   ff15????????         |                     
            //   c6850cebffff00       | mov                 byte ptr [ebp - 0x14f4], 0
            //   68????????           |                     

        $sequence_6 = { 6a00 8d85f4feffff 50 8b8dd0fdffff }
            // n = 4, score = 400
            //   6a00                 | push                0
            //   8d85f4feffff         | lea                 eax, [ebp - 0x10c]
            //   50                   | push                eax
            //   8b8dd0fdffff         | mov                 ecx, dword ptr [ebp - 0x230]

        $sequence_7 = { 0f8446010000 817d08a2000000 7517 e8???????? }
            // n = 4, score = 400
            //   0f8446010000         | je                  0x14c
            //   817d08a2000000       | cmp                 dword ptr [ebp + 8], 0xa2
            //   7517                 | jne                 0x19
            //   e8????????           |                     

        $sequence_8 = { ffe0 58 e9???????? 85c0 }
            // n = 4, score = 200
            //   ffe0                 | jmp                 eax
            //   58                   | pop                 eax
            //   e9????????           |                     
            //   85c0                 | test                eax, eax

        $sequence_9 = { 64ff30 8d8586134000 8920 896804 8d9dba114000 895808 646789260000 }
            // n = 7, score = 200
            //   64ff30               | push                dword ptr fs:[eax]
            //   8d8586134000         | lea                 eax, [ebp + 0x401386]
            //   8920                 | mov                 dword ptr [eax], esp
            //   896804               | mov                 dword ptr [eax + 4], ebp
            //   8d9dba114000         | lea                 ebx, [ebp + 0x4011ba]
            //   895808               | mov                 dword ptr [eax + 8], ebx
            //   646789260000         | mov                 dword ptr fs:[0], esp

        $sequence_10 = { 803fff 75e0 c3 ffb554134000 }
            // n = 4, score = 200
            //   803fff               | cmp                 byte ptr [edi], 0xff
            //   75e0                 | jne                 0xffffffe2
            //   c3                   | ret                 
            //   ffb554134000         | push                dword ptr [ebp + 0x401354]

        $sequence_11 = { c3 50 8d9578274000 52 50 }
            // n = 5, score = 200
            //   c3                   | ret                 
            //   50                   | push                eax
            //   8d9578274000         | lea                 edx, [ebp + 0x402778]
            //   52                   | push                edx
            //   50                   | push                eax

        $sequence_12 = { 03c7 8b00 0344240c eb02 33c0 64678f060000 }
            // n = 6, score = 200
            //   03c7                 | add                 eax, edi
            //   8b00                 | mov                 eax, dword ptr [eax]
            //   0344240c             | add                 eax, dword ptr [esp + 0xc]
            //   eb02                 | jmp                 4
            //   33c0                 | xor                 eax, eax
            //   64678f060000         | pop                 dword ptr fs:[0]

        $sequence_13 = { 750b 68c0270900 ff9503154000 6a00 }
            // n = 4, score = 200
            //   750b                 | jne                 0xd
            //   68c0270900           | push                0x927c0
            //   ff9503154000         | call                dword ptr [ebp + 0x401503]
            //   6a00                 | push                0

        $sequence_14 = { 50 ff954d144000 8d9533164000 52 }
            // n = 4, score = 200
            //   50                   | push                eax
            //   ff954d144000         | call                dword ptr [ebp + 0x40144d]
            //   8d9533164000         | lea                 edx, [ebp + 0x401633]
            //   52                   | push                edx

        $sequence_15 = { c9 c20800 fc b000 }
            // n = 4, score = 200
            //   c9                   | leave               
            //   c20800               | ret                 8
            //   fc                   | cld                 
            //   b000                 | mov                 al, 0

        $sequence_16 = { 0fb70c753a174200 8bc6 40 0fb704453a174200 03c8 }
            // n = 5, score = 100
            //   0fb70c753a174200     | movzx               ecx, word ptr [esi*2 + 0x42173a]
            //   8bc6                 | mov                 eax, esi
            //   40                   | inc                 eax
            //   0fb704453a174200     | movzx               eax, word ptr [eax*2 + 0x42173a]
            //   03c8                 | add                 ecx, eax

        $sequence_17 = { ab a1???????? e8???????? c60720 47 50 }
            // n = 6, score = 100
            //   ab                   | stosd               dword ptr es:[edi], eax
            //   a1????????           |                     
            //   e8????????           |                     
            //   c60720               | mov                 byte ptr [edi], 0x20
            //   47                   | inc                 edi
            //   50                   | push                eax

        $sequence_18 = { e8???????? a3???????? 833d????????00 7439 }
            // n = 4, score = 100
            //   e8????????           |                     
            //   a3????????           |                     
            //   833d????????00       |                     
            //   7439                 | je                  0x3b

        $sequence_19 = { 8b00 ebf4 83c008 03c3 5f 5e }
            // n = 6, score = 100
            //   8b00                 | mov                 eax, dword ptr [eax]
            //   ebf4                 | jmp                 0xfffffff6
            //   83c008               | add                 eax, 8
            //   03c3                 | add                 eax, ebx
            //   5f                   | pop                 edi
            //   5e                   | pop                 esi

        $sequence_20 = { 8d856cfeffff 50 a1???????? ff7038 e8???????? }
            // n = 5, score = 100
            //   8d856cfeffff         | lea                 eax, [ebp - 0x194]
            //   50                   | push                eax
            //   a1????????           |                     
            //   ff7038               | push                dword ptr [eax + 0x38]
            //   e8????????           |                     

        $sequence_21 = { c3 c8040000 53 56 }
            // n = 4, score = 100
            //   c3                   | ret                 
            //   c8040000             | enter               4, 0
            //   53                   | push                ebx
            //   56                   | push                esi

        $sequence_22 = { 56 6800200000 68ff000000 e8???????? }
            // n = 4, score = 100
            //   56                   | push                esi
            //   6800200000           | push                0x2000
            //   68ff000000           | push                0xff
            //   e8????????           |                     

        $sequence_23 = { 58 ff30 e8???????? 68???????? e8???????? 0fb745d1 }
            // n = 6, score = 100
            //   58                   | pop                 eax
            //   ff30                 | push                dword ptr [eax]
            //   e8????????           |                     
            //   68????????           |                     
            //   e8????????           |                     
            //   0fb745d1             | movzx               eax, word ptr [ebp - 0x2f]

    condition:
        7 of them and filesize < 1523712
}