rule win_scanline_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.scanline."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.scanline"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 68???????? e8???????? 017c2444 83c40c 03ef 4b 75e1 }
            // n = 7, score = 100
            //   68????????           |                     
            //   e8????????           |                     
            //   017c2444             | add                 dword ptr [esp + 0x44], edi
            //   83c40c               | add                 esp, 0xc
            //   03ef                 | add                 ebp, edi
            //   4b                   | dec                 ebx
            //   75e1                 | jne                 0xffffffe3

        $sequence_1 = { 7435 8a1a 4e 42 80fb40 7205 }
            // n = 6, score = 100
            //   7435                 | je                  0x37
            //   8a1a                 | mov                 bl, byte ptr [edx]
            //   4e                   | dec                 esi
            //   42                   | inc                 edx
            //   80fb40               | cmp                 bl, 0x40
            //   7205                 | jb                  7

        $sequence_2 = { 8bf1 33c0 394508 898618060000 0f84d6000000 39450c 0f84cd000000 }
            // n = 7, score = 100
            //   8bf1                 | mov                 esi, ecx
            //   33c0                 | xor                 eax, eax
            //   394508               | cmp                 dword ptr [ebp + 8], eax
            //   898618060000         | mov                 dword ptr [esi + 0x618], eax
            //   0f84d6000000         | je                  0xdc
            //   39450c               | cmp                 dword ptr [ebp + 0xc], eax
            //   0f84cd000000         | je                  0xd3

        $sequence_3 = { e8???????? 59 33c0 59 c3 53 56 }
            // n = 7, score = 100
            //   e8????????           |                     
            //   59                   | pop                 ecx
            //   33c0                 | xor                 eax, eax
            //   59                   | pop                 ecx
            //   c3                   | ret                 
            //   53                   | push                ebx
            //   56                   | push                esi

        $sequence_4 = { ff750c 66c745ec0200 ff15???????? 668945ee 8b4508 8945f0 }
            // n = 6, score = 100
            //   ff750c               | push                dword ptr [ebp + 0xc]
            //   66c745ec0200         | mov                 word ptr [ebp - 0x14], 2
            //   ff15????????         |                     
            //   668945ee             | mov                 word ptr [ebp - 0x12], ax
            //   8b4508               | mov                 eax, dword ptr [ebp + 8]
            //   8945f0               | mov                 dword ptr [ebp - 0x10], eax

        $sequence_5 = { f3a5 8bc8 83e103 f3a4 ff7304 e8???????? 8b45fc }
            // n = 7, score = 100
            //   f3a5                 | rep movsd           dword ptr es:[edi], dword ptr [esi]
            //   8bc8                 | mov                 ecx, eax
            //   83e103               | and                 ecx, 3
            //   f3a4                 | rep movsb           byte ptr es:[edi], byte ptr [esi]
            //   ff7304               | push                dword ptr [ebx + 4]
            //   e8????????           |                     
            //   8b45fc               | mov                 eax, dword ptr [ebp - 4]

        $sequence_6 = { 41 ebf7 49 890f 5f 5e 5b }
            // n = 7, score = 100
            //   41                   | inc                 ecx
            //   ebf7                 | jmp                 0xfffffff9
            //   49                   | dec                 ecx
            //   890f                 | mov                 dword ptr [edi], ecx
            //   5f                   | pop                 edi
            //   5e                   | pop                 esi
            //   5b                   | pop                 ebx

        $sequence_7 = { 56 57 8bf1 ff15???????? 8be8 33db }
            // n = 6, score = 100
            //   56                   | push                esi
            //   57                   | push                edi
            //   8bf1                 | mov                 esi, ecx
            //   ff15????????         |                     
            //   8be8                 | mov                 ebp, eax
            //   33db                 | xor                 ebx, ebx

        $sequence_8 = { 8d8db4f7ffff 897508 e8???????? 8d85c8feffff 56 50 ff15???????? }
            // n = 7, score = 100
            //   8d8db4f7ffff         | lea                 ecx, [ebp - 0x84c]
            //   897508               | mov                 dword ptr [ebp + 8], esi
            //   e8????????           |                     
            //   8d85c8feffff         | lea                 eax, [ebp - 0x138]
            //   56                   | push                esi
            //   50                   | push                eax
            //   ff15????????         |                     

        $sequence_9 = { 7510 80a11703000000 c6811603000008 eb15 807c24040d 750e c681160300000d }
            // n = 7, score = 100
            //   7510                 | jne                 0x12
            //   80a11703000000       | and                 byte ptr [ecx + 0x317], 0
            //   c6811603000008       | mov                 byte ptr [ecx + 0x316], 8
            //   eb15                 | jmp                 0x17
            //   807c24040d           | cmp                 byte ptr [esp + 4], 0xd
            //   750e                 | jne                 0x10
            //   c681160300000d       | mov                 byte ptr [ecx + 0x316], 0xd

    condition:
        7 of them and filesize < 151552
}