rule win_seasalt_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.seasalt."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.seasalt"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 33c0 f2ae f7d1 83c1f3 }
            // n = 4, score = 100
            //   33c0                 | xor                 eax, eax
            //   f2ae                 | repne scasb         al, byte ptr es:[edi]
            //   f7d1                 | not                 ecx
            //   83c1f3               | add                 ecx, -0xd

        $sequence_1 = { eb02 33c0 0fbe84c660a20010 c1f804 83f807 }
            // n = 5, score = 100
            //   eb02                 | jmp                 4
            //   33c0                 | xor                 eax, eax
            //   0fbe84c660a20010     | movsx               eax, byte ptr [esi + eax*8 + 0x1000a260]
            //   c1f804               | sar                 eax, 4
            //   83f807               | cmp                 eax, 7

        $sequence_2 = { 40 3d00010000 7cef b950000000 }
            // n = 4, score = 100
            //   40                   | inc                 eax
            //   3d00010000           | cmp                 eax, 0x100
            //   7cef                 | jl                  0xfffffff1
            //   b950000000           | mov                 ecx, 0x50

        $sequence_3 = { 8dbdd8fdffff 897de8 803f00 7433 }
            // n = 4, score = 100
            //   8dbdd8fdffff         | lea                 edi, [ebp - 0x228]
            //   897de8               | mov                 dword ptr [ebp - 0x18], edi
            //   803f00               | cmp                 byte ptr [edi], 0
            //   7433                 | je                  0x35

        $sequence_4 = { 89442420 b911000000 33c0 8d7c2424 f3ab }
            // n = 5, score = 100
            //   89442420             | mov                 dword ptr [esp + 0x20], eax
            //   b911000000           | mov                 ecx, 0x11
            //   33c0                 | xor                 eax, eax
            //   8d7c2424             | lea                 edi, [esp + 0x24]
            //   f3ab                 | rep stosd           dword ptr es:[edi], eax

        $sequence_5 = { 0fb6fa 3bc7 7714 8b55fc 8a92c0cc0010 089001da0010 }
            // n = 6, score = 100
            //   0fb6fa               | movzx               edi, dl
            //   3bc7                 | cmp                 eax, edi
            //   7714                 | ja                  0x16
            //   8b55fc               | mov                 edx, dword ptr [ebp - 4]
            //   8a92c0cc0010         | mov                 dl, byte ptr [edx + 0x1000ccc0]
            //   089001da0010         | or                  byte ptr [eax + 0x1000da01], dl

        $sequence_6 = { 891d???????? c705????????03000000 8935???????? 8935???????? ffd7 }
            // n = 5, score = 100
            //   891d????????         |                     
            //   c705????????03000000     |     
            //   8935????????         |                     
            //   8935????????         |                     
            //   ffd7                 | call                edi

        $sequence_7 = { 896c2428 ffd6 8d4c2410 53 51 68???????? 68???????? }
            // n = 7, score = 100
            //   896c2428             | mov                 dword ptr [esp + 0x28], ebp
            //   ffd6                 | call                esi
            //   8d4c2410             | lea                 ecx, [esp + 0x10]
            //   53                   | push                ebx
            //   51                   | push                ecx
            //   68????????           |                     
            //   68????????           |                     

        $sequence_8 = { 8dbc2419020000 c684241802000000 f3ab 66ab 6a00 }
            // n = 5, score = 100
            //   8dbc2419020000       | lea                 edi, [esp + 0x219]
            //   c684241802000000     | mov                 byte ptr [esp + 0x218], 0
            //   f3ab                 | rep stosd           dword ptr es:[edi], eax
            //   66ab                 | stosw               word ptr es:[edi], ax
            //   6a00                 | push                0

        $sequence_9 = { 7765 ff2485f4130010 8b0d???????? 68???????? }
            // n = 4, score = 100
            //   7765                 | ja                  0x67
            //   ff2485f4130010       | jmp                 dword ptr [eax*4 + 0x100013f4]
            //   8b0d????????         |                     
            //   68????????           |                     

    condition:
        7 of them and filesize < 139264
}