rule win_sepulcher_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.sepulcher."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.sepulcher"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { fe4123 5d c20800 55 8bec 51 53 }
            // n = 7, score = 100
            //   fe4123               | inc                 byte ptr [ecx + 0x23]
            //   5d                   | pop                 ebp
            //   c20800               | ret                 8
            //   55                   | push                ebp
            //   8bec                 | mov                 ebp, esp
            //   51                   | push                ecx
            //   53                   | push                ebx

        $sequence_1 = { be00001000 eb02 8bf1 81bd28d2ffffee030000 7525 6a00 8d8520d2ffff }
            // n = 7, score = 100
            //   be00001000           | mov                 esi, 0x100000
            //   eb02                 | jmp                 4
            //   8bf1                 | mov                 esi, ecx
            //   81bd28d2ffffee030000     | cmp    dword ptr [ebp - 0x2dd8], 0x3ee
            //   7525                 | jne                 0x27
            //   6a00                 | push                0
            //   8d8520d2ffff         | lea                 eax, [ebp - 0x2de0]

        $sequence_2 = { 59 33c0 8dbd68ffffff f3ab 8d8568ffffff }
            // n = 5, score = 100
            //   59                   | pop                 ecx
            //   33c0                 | xor                 eax, eax
            //   8dbd68ffffff         | lea                 edi, [ebp - 0x98]
            //   f3ab                 | rep stosd           dword ptr es:[edi], eax
            //   8d8568ffffff         | lea                 eax, [ebp - 0x98]

        $sequence_3 = { 56 53 e8???????? 85c0 743d 6a00 8d8520d2ffff }
            // n = 7, score = 100
            //   56                   | push                esi
            //   53                   | push                ebx
            //   e8????????           |                     
            //   85c0                 | test                eax, eax
            //   743d                 | je                  0x3f
            //   6a00                 | push                0
            //   8d8520d2ffff         | lea                 eax, [ebp - 0x2de0]

        $sequence_4 = { 50 6a00 8d85e8f9ffff 50 ff15???????? 85c0 }
            // n = 6, score = 100
            //   50                   | push                eax
            //   6a00                 | push                0
            //   8d85e8f9ffff         | lea                 eax, [ebp - 0x618]
            //   50                   | push                eax
            //   ff15????????         |                     
            //   85c0                 | test                eax, eax

        $sequence_5 = { 894db8 8975b4 8945bc 85f6 0f8497000000 85c0 }
            // n = 6, score = 100
            //   894db8               | mov                 dword ptr [ebp - 0x48], ecx
            //   8975b4               | mov                 dword ptr [ebp - 0x4c], esi
            //   8945bc               | mov                 dword ptr [ebp - 0x44], eax
            //   85f6                 | test                esi, esi
            //   0f8497000000         | je                  0x9d
            //   85c0                 | test                eax, eax

        $sequence_6 = { 6a00 50 e8???????? 83c40c 8d85e0f7ffff 68ff000000 }
            // n = 6, score = 100
            //   6a00                 | push                0
            //   50                   | push                eax
            //   e8????????           |                     
            //   83c40c               | add                 esp, 0xc
            //   8d85e0f7ffff         | lea                 eax, [ebp - 0x820]
            //   68ff000000           | push                0xff

        $sequence_7 = { 59 ebbd 8b470c 8903 05ffff0000 50 e8???????? }
            // n = 7, score = 100
            //   59                   | pop                 ecx
            //   ebbd                 | jmp                 0xffffffbf
            //   8b470c               | mov                 eax, dword ptr [edi + 0xc]
            //   8903                 | mov                 dword ptr [ebx], eax
            //   05ffff0000           | add                 eax, 0xffff
            //   50                   | push                eax
            //   e8????????           |                     

        $sequence_8 = { e8???????? 59 ff75bc 8bf8 8bce 57 e8???????? }
            // n = 7, score = 100
            //   e8????????           |                     
            //   59                   | pop                 ecx
            //   ff75bc               | push                dword ptr [ebp - 0x44]
            //   8bf8                 | mov                 edi, eax
            //   8bce                 | mov                 ecx, esi
            //   57                   | push                edi
            //   e8????????           |                     

        $sequence_9 = { d1e8 894234 8b4a38 0faf4a34 8b4214 }
            // n = 5, score = 100
            //   d1e8                 | shr                 eax, 1
            //   894234               | mov                 dword ptr [edx + 0x34], eax
            //   8b4a38               | mov                 ecx, dword ptr [edx + 0x38]
            //   0faf4a34             | imul                ecx, dword ptr [edx + 0x34]
            //   8b4214               | mov                 eax, dword ptr [edx + 0x14]

    condition:
        7 of them and filesize < 279552
}