rule win_servhelper_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2020-10-14"
        version = "1"
        description = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.5.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.servhelper"
        malpedia_rule_date = "20201014"
        malpedia_hash = "a7e3bd57eaf12bf3ea29a863c041091ba3af9ac9"
        malpedia_version = "20201014"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { e8???????? b8???????? b9d9d60000 8b15???????? e8???????? }
            // n = 5, score = 200
            //   e8????????           |                     
            //   b8????????           |                     
            //   b9d9d60000           | mov                 ecx, 0xd6d9
            //   8b15????????         |                     
            //   e8????????           |                     

        $sequence_1 = { 807da101 750b 8d5324 8b4644 e8???????? 837b3000 7506 }
            // n = 7, score = 200
            //   807da101             | cmp                 byte ptr [ebp - 0x5f], 1
            //   750b                 | jne                 0xd
            //   8d5324               | lea                 edx, [ebx + 0x24]
            //   8b4644               | mov                 eax, dword ptr [esi + 0x44]
            //   e8????????           |                     
            //   837b3000             | cmp                 dword ptr [ebx + 0x30], 0
            //   7506                 | jne                 8

        $sequence_2 = { 8bf8 8bc7 e8???????? 85ff 75ec 8b4604 }
            // n = 6, score = 200
            //   8bf8                 | mov                 edi, eax
            //   8bc7                 | mov                 eax, edi
            //   e8????????           |                     
            //   85ff                 | test                edi, edi
            //   75ec                 | jne                 0xffffffee
            //   8b4604               | mov                 eax, dword ptr [esi + 4]

        $sequence_3 = { 84c0 7406 66b82200 eb04 }
            // n = 4, score = 200
            //   84c0                 | test                al, al
            //   7406                 | je                  8
            //   66b82200             | mov                 ax, 0x22
            //   eb04                 | jmp                 6

        $sequence_4 = { 8945dc 33c0 8945e0 8d45d4 8b4dfc ba???????? }
            // n = 6, score = 200
            //   8945dc               | mov                 dword ptr [ebp - 0x24], eax
            //   33c0                 | xor                 eax, eax
            //   8945e0               | mov                 dword ptr [ebp - 0x20], eax
            //   8d45d4               | lea                 eax, [ebp - 0x2c]
            //   8b4dfc               | mov                 ecx, dword ptr [ebp - 4]
            //   ba????????           |                     

        $sequence_5 = { 8bf0 e8???????? 3db7000000 750a }
            // n = 4, score = 200
            //   8bf0                 | mov                 esi, eax
            //   e8????????           |                     
            //   3db7000000           | cmp                 eax, 0xb7
            //   750a                 | jne                 0xc

        $sequence_6 = { 134900 4e 004600 4e 004100 4e 00ac08c07503b0 }
            // n = 7, score = 200
            //   134900               | adc                 ecx, dword ptr [ecx]
            //   4e                   | dec                 esi
            //   004600               | add                 byte ptr [esi], al
            //   4e                   | dec                 esi
            //   004100               | add                 byte ptr [ecx], al
            //   4e                   | dec                 esi
            //   00ac08c07503b0       | add                 byte ptr [eax + ecx - 0x4ffc8a40], ch

        $sequence_7 = { 1b55d4 52 50 8bc6 }
            // n = 4, score = 200
            //   1b55d4               | sbb                 edx, dword ptr [ebp - 0x2c]
            //   52                   | push                edx
            //   50                   | push                eax
            //   8bc6                 | mov                 eax, esi

        $sequence_8 = { 7700 69006e006800 7400 7400 7000 2e0064006c }
            // n = 6, score = 200
            //   7700                 | ja                  2
            //   69006e006800         | imul                eax, dword ptr [eax], 0x68006e
            //   7400                 | je                  2
            //   7400                 | je                  2
            //   7000                 | jo                  2
            //   2e0064006c           | add                 byte ptr cs:[eax + eax + 0x6c], ah

        $sequence_9 = { 8b58fc 48 8b09 e8???????? }
            // n = 4, score = 100
            //   8b58fc               | mov                 ebx, dword ptr [eax - 4]
            //   48                   | dec                 eax
            //   8b09                 | mov                 ecx, dword ptr [ecx]
            //   e8????????           |                     

        $sequence_10 = { 8b58fc 48 0fb74542 66894548 }
            // n = 4, score = 100
            //   8b58fc               | mov                 ebx, dword ptr [eax - 4]
            //   48                   | dec                 eax
            //   0fb74542             | movzx               eax, word ptr [ebp + 0x42]
            //   66894548             | mov                 word ptr [ebp + 0x48], ax

        $sequence_11 = { 8b58f8 48 8b4538 48 8d3418 48 }
            // n = 6, score = 100
            //   8b58f8               | mov                 ebx, dword ptr [eax - 8]
            //   48                   | dec                 eax
            //   8b4538               | mov                 eax, dword ptr [ebp + 0x38]
            //   48                   | dec                 eax
            //   8d3418               | lea                 esi, [eax + ebx]
            //   48                   | dec                 eax

        $sequence_12 = { 8b58fc 48 8b4520 48 }
            // n = 4, score = 100
            //   8b58fc               | mov                 ebx, dword ptr [eax - 4]
            //   48                   | dec                 eax
            //   8b4520               | mov                 eax, dword ptr [ebp + 0x20]
            //   48                   | dec                 eax

        $sequence_13 = { 8b58f8 48 8b4548 48 }
            // n = 4, score = 100
            //   8b58f8               | mov                 ebx, dword ptr [eax - 8]
            //   48                   | dec                 eax
            //   8b4548               | mov                 eax, dword ptr [ebp + 0x48]
            //   48                   | dec                 eax

        $sequence_14 = { 8b58fc 48 89d1 e8???????? }
            // n = 4, score = 100
            //   8b58fc               | mov                 ebx, dword ptr [eax - 4]
            //   48                   | dec                 eax
            //   89d1                 | mov                 ecx, edx
            //   e8????????           |                     

    condition:
        7 of them and filesize < 6717440
}