rule win_sfile_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.sfile."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.sfile"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 8945f4 8b45f4 8945fc 8b4dfc c7412800000000 8b55fc c7422000000000 }
            // n = 7, score = 300
            //   8945f4               | mov                 dword ptr [ebp - 0xc], eax
            //   8b45f4               | mov                 eax, dword ptr [ebp - 0xc]
            //   8945fc               | mov                 dword ptr [ebp - 4], eax
            //   8b4dfc               | mov                 ecx, dword ptr [ebp - 4]
            //   c7412800000000       | mov                 dword ptr [ecx + 0x28], 0
            //   8b55fc               | mov                 edx, dword ptr [ebp - 4]
            //   c7422000000000       | mov                 dword ptr [edx + 0x20], 0

        $sequence_1 = { 8b888c050000 51 e8???????? 8b55f8 8b4a14 e8???????? 8945ec }
            // n = 7, score = 300
            //   8b888c050000         | mov                 ecx, dword ptr [eax + 0x58c]
            //   51                   | push                ecx
            //   e8????????           |                     
            //   8b55f8               | mov                 edx, dword ptr [ebp - 8]
            //   8b4a14               | mov                 ecx, dword ptr [edx + 0x14]
            //   e8????????           |                     
            //   8945ec               | mov                 dword ptr [ebp - 0x14], eax

        $sequence_2 = { 8b55fc 894210 894a14 8b4508 833800 7413 8b4d08 }
            // n = 7, score = 300
            //   8b55fc               | mov                 edx, dword ptr [ebp - 4]
            //   894210               | mov                 dword ptr [edx + 0x10], eax
            //   894a14               | mov                 dword ptr [edx + 0x14], ecx
            //   8b4508               | mov                 eax, dword ptr [ebp + 8]
            //   833800               | cmp                 dword ptr [eax], 0
            //   7413                 | je                  0x15
            //   8b4d08               | mov                 ecx, dword ptr [ebp + 8]

        $sequence_3 = { ff15???????? 8b45ec 50 8b4df8 }
            // n = 4, score = 300
            //   ff15????????         |                     
            //   8b45ec               | mov                 eax, dword ptr [ebp - 0x14]
            //   50                   | push                eax
            //   8b4df8               | mov                 ecx, dword ptr [ebp - 8]

        $sequence_4 = { e8???????? 8b4df8 83795800 740d 8b55f8 }
            // n = 5, score = 300
            //   e8????????           |                     
            //   8b4df8               | mov                 ecx, dword ptr [ebp - 8]
            //   83795800             | cmp                 dword ptr [ecx + 0x58], 0
            //   740d                 | je                  0xf
            //   8b55f8               | mov                 edx, dword ptr [ebp - 8]

        $sequence_5 = { e8???????? 83c404 8b4510 8b4858 894df8 }
            // n = 5, score = 300
            //   e8????????           |                     
            //   83c404               | add                 esp, 4
            //   8b4510               | mov                 eax, dword ptr [ebp + 0x10]
            //   8b4858               | mov                 ecx, dword ptr [eax + 0x58]
            //   894df8               | mov                 dword ptr [ebp - 8], ecx

        $sequence_6 = { 33c0 e9???????? eb21 837d1003 751b }
            // n = 5, score = 300
            //   33c0                 | xor                 eax, eax
            //   e9????????           |                     
            //   eb21                 | jmp                 0x23
            //   837d1003             | cmp                 dword ptr [ebp + 0x10], 3
            //   751b                 | jne                 0x1d

        $sequence_7 = { 8b45e8 8b4df8 8b511c 8910 }
            // n = 4, score = 300
            //   8b45e8               | mov                 eax, dword ptr [ebp - 0x18]
            //   8b4df8               | mov                 ecx, dword ptr [ebp - 8]
            //   8b511c               | mov                 edx, dword ptr [ecx + 0x1c]
            //   8910                 | mov                 dword ptr [eax], edx

        $sequence_8 = { 8b5158 52 e8???????? 83c404 8b4510 }
            // n = 5, score = 300
            //   8b5158               | mov                 edx, dword ptr [ecx + 0x58]
            //   52                   | push                edx
            //   e8????????           |                     
            //   83c404               | add                 esp, 4
            //   8b4510               | mov                 eax, dword ptr [ebp + 0x10]

        $sequence_9 = { 8b4204 ffd0 8b4df8 c7412000000000 833d????????ff }
            // n = 5, score = 300
            //   8b4204               | mov                 eax, dword ptr [edx + 4]
            //   ffd0                 | call                eax
            //   8b4df8               | mov                 ecx, dword ptr [ebp - 8]
            //   c7412000000000       | mov                 dword ptr [ecx + 0x20], 0
            //   833d????????ff       |                     

    condition:
        7 of them and filesize < 588800
}