rule win_sharpknot_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.sharpknot."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.sharpknot"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 85c0 0f84b6000000 8d942454020000 8d4608 52 }
            // n = 5, score = 100
            //   85c0                 | test                eax, eax
            //   0f84b6000000         | je                  0xbc
            //   8d942454020000       | lea                 edx, [esp + 0x254]
            //   8d4608               | lea                 eax, [esi + 8]
            //   52                   | push                edx

        $sequence_1 = { 747a 8b842460040000 8d54243c 52 }
            // n = 4, score = 100
            //   747a                 | je                  0x7c
            //   8b842460040000       | mov                 eax, dword ptr [esp + 0x460]
            //   8d54243c             | lea                 edx, [esp + 0x3c]
            //   52                   | push                edx

        $sequence_2 = { c60300 f2ae f7d1 2bf9 8d542410 8bc1 8bf7 }
            // n = 7, score = 100
            //   c60300               | mov                 byte ptr [ebx], 0
            //   f2ae                 | repne scasb         al, byte ptr es:[edi]
            //   f7d1                 | not                 ecx
            //   2bf9                 | sub                 edi, ecx
            //   8d542410             | lea                 edx, [esp + 0x10]
            //   8bc1                 | mov                 eax, ecx
            //   8bf7                 | mov                 esi, edi

        $sequence_3 = { 7419 83e818 83ea18 b906000000 8bf0 8bfa }
            // n = 6, score = 100
            //   7419                 | je                  0x1b
            //   83e818               | sub                 eax, 0x18
            //   83ea18               | sub                 edx, 0x18
            //   b906000000           | mov                 ecx, 6
            //   8bf0                 | mov                 esi, eax
            //   8bfa                 | mov                 edi, edx

        $sequence_4 = { 8bc8 8d942c2c020000 83e103 f3a4 8d8c2428010000 51 }
            // n = 6, score = 100
            //   8bc8                 | mov                 ecx, eax
            //   8d942c2c020000       | lea                 edx, [esp + ebp + 0x22c]
            //   83e103               | and                 ecx, 3
            //   f3a4                 | rep movsb           byte ptr es:[edi], byte ptr [esi]
            //   8d8c2428010000       | lea                 ecx, [esp + 0x128]
            //   51                   | push                ecx

        $sequence_5 = { 2bcd f7e9 c1fa02 8bc2 c1e81f 03d0 83fa01 }
            // n = 7, score = 100
            //   2bcd                 | sub                 ecx, ebp
            //   f7e9                 | imul                ecx
            //   c1fa02               | sar                 edx, 2
            //   8bc2                 | mov                 eax, edx
            //   c1e81f               | shr                 eax, 0x1f
            //   03d0                 | add                 edx, eax
            //   83fa01               | cmp                 edx, 1

        $sequence_6 = { b801000000 5b 83c41c c3 ffd3 57 ffd3 }
            // n = 7, score = 100
            //   b801000000           | mov                 eax, 1
            //   5b                   | pop                 ebx
            //   83c41c               | add                 esp, 0x1c
            //   c3                   | ret                 
            //   ffd3                 | call                ebx
            //   57                   | push                edi
            //   ffd3                 | call                ebx

        $sequence_7 = { 8d442404 56 68???????? 50 e8???????? 8b15???????? 8d4c2410 }
            // n = 7, score = 100
            //   8d442404             | lea                 eax, [esp + 4]
            //   56                   | push                esi
            //   68????????           |                     
            //   50                   | push                eax
            //   e8????????           |                     
            //   8b15????????         |                     
            //   8d4c2410             | lea                 ecx, [esp + 0x10]

        $sequence_8 = { f3a4 b910000000 8d7c2414 f3ab 8d442454 8d4c2410 50 }
            // n = 7, score = 100
            //   f3a4                 | rep movsb           byte ptr es:[edi], byte ptr [esi]
            //   b910000000           | mov                 ecx, 0x10
            //   8d7c2414             | lea                 edi, [esp + 0x14]
            //   f3ab                 | rep stosd           dword ptr es:[edi], eax
            //   8d442454             | lea                 eax, [esp + 0x54]
            //   8d4c2410             | lea                 ecx, [esp + 0x10]
            //   50                   | push                eax

        $sequence_9 = { c1f805 59 8a4dff 8d3c8540e64400 }
            // n = 4, score = 100
            //   c1f805               | sar                 eax, 5
            //   59                   | pop                 ecx
            //   8a4dff               | mov                 cl, byte ptr [ebp - 1]
            //   8d3c8540e64400       | lea                 edi, [eax*4 + 0x44e640]

    condition:
        7 of them and filesize < 1032192
}