rule win_smokeloader_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.smokeloader."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.smokeloader"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { ff15???????? 8d45f0 50 8d45e8 50 8d45e0 50 }
            // n = 7, score = 1300
            //   ff15????????         |                     
            //   8d45f0               | lea                 eax, [ebp - 0x10]
            //   50                   | push                eax
            //   8d45e8               | lea                 eax, [ebp - 0x18]
            //   50                   | push                eax
            //   8d45e0               | lea                 eax, [ebp - 0x20]
            //   50                   | push                eax

        $sequence_1 = { 50 8d45e0 50 56 ff15???????? 56 ff15???????? }
            // n = 7, score = 1100
            //   50                   | push                eax
            //   8d45e0               | lea                 eax, [ebp - 0x20]
            //   50                   | push                eax
            //   56                   | push                esi
            //   ff15????????         |                     
            //   56                   | push                esi
            //   ff15????????         |                     

        $sequence_2 = { 6a00 53 ff15???????? 8d45f0 }
            // n = 4, score = 1100
            //   6a00                 | push                0
            //   53                   | push                ebx
            //   ff15????????         |                     
            //   8d45f0               | lea                 eax, [ebp - 0x10]

        $sequence_3 = { 57 ff15???????? 6a00 6800000002 6a03 6a00 6a03 }
            // n = 7, score = 1100
            //   57                   | push                edi
            //   ff15????????         |                     
            //   6a00                 | push                0
            //   6800000002           | push                0x2000000
            //   6a03                 | push                3
            //   6a00                 | push                0
            //   6a03                 | push                3

        $sequence_4 = { 8bf0 8d45dc 50 6a00 53 }
            // n = 5, score = 1100
            //   8bf0                 | mov                 esi, eax
            //   8d45dc               | lea                 eax, [ebp - 0x24]
            //   50                   | push                eax
            //   6a00                 | push                0
            //   53                   | push                ebx

        $sequence_5 = { 0fb64405dc 50 8d45ec 50 }
            // n = 4, score = 900
            //   0fb64405dc           | movzx               eax, byte ptr [ebp + eax - 0x24]
            //   50                   | push                eax
            //   8d45ec               | lea                 eax, [ebp - 0x14]
            //   50                   | push                eax

        $sequence_6 = { e8???????? 8bf0 8d45fc 50 ff75fc 56 }
            // n = 6, score = 900
            //   e8????????           |                     
            //   8bf0                 | push                eax
            //   8d45fc               | push                esi
            //   50                   | push                0
            //   ff75fc               | mov                 eax, dword ptr [edi]
            //   56                   | add                 eax, ebx

        $sequence_7 = { 740a 83c104 83f920 72f0 }
            // n = 4, score = 900
            //   740a                 | je                  0xc
            //   83c104               | add                 ecx, 4
            //   83f920               | cmp                 ecx, 0x20
            //   72f0                 | jb                  0xfffffff2

        $sequence_8 = { 50 56 681f000f00 57 }
            // n = 4, score = 900
            //   50                   | je                  0xb
            //   56                   | mov                 ax, gs
            //   681f000f00           | test                ax, ax
            //   57                   | je                  0xb

        $sequence_9 = { 56 8d45fc 50 57 57 6a19 }
            // n = 6, score = 900
            //   56                   | push                eax
            //   8d45fc               | mov                 ax, gs
            //   50                   | test                ax, ax
            //   57                   | je                  0xb
            //   57                   | mov                 ax, gs
            //   6a19                 | test                ax, ax

        $sequence_10 = { ff15???????? bf90010000 8bcf e8???????? }
            // n = 4, score = 900
            //   ff15????????         |                     
            //   bf90010000           | mov                 edi, 0x190
            //   8bcf                 | mov                 ecx, edi
            //   e8????????           |                     

        $sequence_11 = { 668ce8 6685c0 7406 fe05???????? }
            // n = 4, score = 900
            //   668ce8               | lea                 eax, [ebp - 0x20]
            //   6685c0               | mov                 esi, eax
            //   7406                 | lea                 eax, [ebp - 0x24]
            //   fe05????????         |                     

        $sequence_12 = { 56 ff15???????? 50 56 6a00 ff15???????? }
            // n = 6, score = 800
            //   56                   | push                0
            //   ff15????????         |                     
            //   50                   | push                0x2000000
            //   56                   | lea                 eax, [ebp - 0x24]
            //   6a00                 | push                eax
            //   ff15????????         |                     

        $sequence_13 = { 8b07 03c3 50 ff15???????? }
            // n = 4, score = 800
            //   8b07                 | push                esi
            //   03c3                 | push                esi
            //   50                   | push                edi
            //   ff15????????         |                     

        $sequence_14 = { 33c0 e9???????? e8???????? b904010000 }
            // n = 4, score = 800
            //   33c0                 | xor                 eax, eax
            //   e9????????           |                     
            //   e8????????           |                     
            //   b904010000           | mov                 ecx, 0x104

        $sequence_15 = { 6a40 56 6a01 8d45f8 50 }
            // n = 5, score = 800
            //   6a40                 | push                0x19
            //   56                   | push                eax
            //   6a01                 | push                esi
            //   8d45f8               | push                0xf001f
            //   50                   | push                edi

        $sequence_16 = { 03e8 03e9 81e5ff000000 8a442c18 88443c18 47 }
            // n = 6, score = 700
            //   03e8                 | mov                 esi, eax
            //   03e9                 | lea                 eax, [ebp - 4]
            //   81e5ff000000         | push                eax
            //   8a442c18             | push                dword ptr [ebp - 4]
            //   88443c18             | push                esi
            //   47                   | push                esi

        $sequence_17 = { 8bde 8bfe 399c241c010000 7644 8b6c2410 47 }
            // n = 6, score = 700
            //   8bde                 | push                0xf001f
            //   8bfe                 | push                edi
            //   399c241c010000       | movzx               eax, byte ptr [ebp + eax - 0x24]
            //   7644                 | push                eax
            //   8b6c2410             | lea                 eax, [ebp - 0x14]
            //   47                   | push                eax

        $sequence_18 = { 0fb64c3c18 0fb6c2 03c8 81e1ff000000 8a440c18 30042b 43 }
            // n = 7, score = 700
            //   0fb64c3c18           | lea                 eax, [ebp - 4]
            //   0fb6c2               | push                eax
            //   03c8                 | push                dword ptr [ebp - 4]
            //   81e1ff000000         | push                esi
            //   8a440c18             | push                0x19
            //   30042b               | push                eax
            //   43                   | push                esi

        $sequence_19 = { 8d8de8fdffff 50 50 50 }
            // n = 4, score = 500
            //   8d8de8fdffff         | lea                 ecx, [ebp - 0x218]
            //   50                   | push                eax
            //   50                   | push                eax
            //   50                   | push                eax

        $sequence_20 = { 8985ecfdffff ffb5f0fdffff 50 53 e8???????? }
            // n = 5, score = 500
            //   8985ecfdffff         | mov                 dword ptr [ebp - 0x214], eax
            //   ffb5f0fdffff         | push                dword ptr [ebp - 0x210]
            //   50                   | push                eax
            //   53                   | push                ebx
            //   e8????????           |                     

        $sequence_21 = { 8d85f0fdffff 8b750c 8b7d10 50 57 56 }
            // n = 6, score = 500
            //   8d85f0fdffff         | lea                 eax, [ebp - 0x210]
            //   8b750c               | mov                 esi, dword ptr [ebp + 0xc]
            //   8b7d10               | mov                 edi, dword ptr [ebp + 0x10]
            //   50                   | push                eax
            //   57                   | push                edi
            //   56                   | push                esi

        $sequence_22 = { 89c6 6804010000 56 57 }
            // n = 4, score = 500
            //   89c6                 | mov                 esi, eax
            //   6804010000           | push                0x104
            //   56                   | push                esi
            //   57                   | push                edi

        $sequence_23 = { 8b4514 898608020000 56 6aff }
            // n = 4, score = 500
            //   8b4514               | mov                 eax, dword ptr [ebp + 0x14]
            //   898608020000         | mov                 dword ptr [esi + 0x208], eax
            //   56                   | push                esi
            //   6aff                 | push                -1

        $sequence_24 = { 53 e8???????? 8d8decfdffff 8d95f0fdffff }
            // n = 4, score = 500
            //   53                   | push                ebx
            //   e8????????           |                     
            //   8d8decfdffff         | lea                 ecx, [ebp - 0x214]
            //   8d95f0fdffff         | lea                 edx, [ebp - 0x210]

        $sequence_25 = { c60653 56 6a00 6a00 }
            // n = 4, score = 500
            //   c60653               | mov                 byte ptr [esi], 0x53
            //   56                   | push                esi
            //   6a00                 | push                0
            //   6a00                 | push                0

        $sequence_26 = { 8d95f0fdffff c70200000000 6800800000 52 }
            // n = 4, score = 500
            //   8d95f0fdffff         | lea                 edx, [ebp - 0x210]
            //   c70200000000         | mov                 dword ptr [edx], 0
            //   6800800000           | push                0x8000
            //   52                   | push                edx

        $sequence_27 = { 89e5 81ec5c060000 53 56 }
            // n = 4, score = 400
            //   89e5                 | mov                 ebp, esp
            //   81ec5c060000         | sub                 esp, 0x65c
            //   53                   | push                ebx
            //   56                   | push                esi

        $sequence_28 = { fc 5f 5e 5b }
            // n = 4, score = 400
            //   fc                   | jne                 9
            //   5f                   | je                  9
            //   5e                   | insd                dword ptr es:[edi], dx
            //   5b                   | pop                 ebp

        $sequence_29 = { 60 89c6 89cf fc }
            // n = 4, score = 400
            //   60                   | cld                 
            //   89c6                 | mov                 dl, 0x80
            //   89cf                 | xor                 ebx, ebx
            //   fc                   | movsb               byte ptr es:[edi], byte ptr [esi]

        $sequence_30 = { 30d0 aa e2f3 7505 }
            // n = 4, score = 400
            //   30d0                 | xor                 al, dl
            //   aa                   | stosb               byte ptr es:[edi], al
            //   e2f3                 | loop                0xfffffff5
            //   7505                 | jne                 7

        $sequence_31 = { 89cf fc b280 31db a4 b302 }
            // n = 6, score = 400
            //   89cf                 | mov                 ecx, 0x104
            //   fc                   | mov                 eax, dword ptr [ebp - 0x29]
            //   b280                 | inc                 ecx
            //   31db                 | add                 eax, ebp
            //   a4                   | inc                 esp
            //   b302                 | mov                 dword ptr [ebx + 0x17], ebp

        $sequence_32 = { 4d 01c4 ffc9 49 }
            // n = 4, score = 300
            //   4d                   | dec                 ebp
            //   01c4                 | add                 esp, eax
            //   ffc9                 | dec                 ecx
            //   49                   | dec                 ecx

        $sequence_33 = { 48896c2410 4889742418 57 4883ec30 65488b042560000000 4c8b15???????? }
            // n = 6, score = 300
            //   48896c2410           | dec                 eax
            //   4889742418           | mov                 ecx, dword ptr [ebx]
            //   57                   | mov                 cl, byte ptr [eax]
            //   4883ec30             | dec                 eax
            //   65488b042560000000     | mov    dword ptr [esp + 0x10], ebp
            //   4c8b15????????       |                     

        $sequence_34 = { 4883f814 72ea 488b0d???????? ff15???????? 488b0d???????? ff15???????? 488b0d???????? }
            // n = 7, score = 300
            //   4883f814             | mov                 eax, dword ptr [0x60]
            //   72ea                 | dec                 eax
            //   488b0d????????       |                     
            //   ff15????????         |                     
            //   488b0d????????       |                     
            //   ff15????????         |                     
            //   488b0d????????       |                     

        $sequence_35 = { 8bd7 4c8bc3 4889442420 ff15???????? 488b0b ff15???????? 8a08 }
            // n = 7, score = 300
            //   8bd7                 | mov                 edx, edi
            //   4c8bc3               | dec                 esp
            //   4889442420           | mov                 eax, ebx
            //   ff15????????         |                     
            //   488b0b               | dec                 eax
            //   ff15????????         |                     
            //   8a08                 | mov                 dword ptr [esp + 0x20], eax

        $sequence_36 = { 41b800300000 ff15???????? 448b4754 488bd6 }
            // n = 4, score = 300
            //   41b800300000         | dec                 eax
            //   ff15????????         |                     
            //   448b4754             | sub                 esp, 0x30
            //   488bd6               | dec                 eax

        $sequence_37 = { 55 89e5 81ec54040000 53 }
            // n = 4, score = 300
            //   55                   | push                eax
            //   89e5                 | push                esi
            //   81ec54040000         | lea                 ecx, [ebp - 0x214]
            //   53                   | lea                 edx, [ebp - 0x210]

        $sequence_38 = { 01c2 31c0 ac 01c2 85c0 }
            // n = 5, score = 300
            //   01c2                 | add                 edx, eax
            //   31c0                 | xor                 eax, eax
            //   ac                   | lodsb               al, byte ptr [esi]
            //   01c2                 | add                 edx, eax
            //   85c0                 | test                eax, eax

        $sequence_39 = { 488bd8 ff15???????? 4c8d4c2454 4c8d44244c }
            // n = 4, score = 300
            //   488bd8               | dec                 eax
            //   ff15????????         |                     
            //   4c8d4c2454           | mov                 dword ptr [esp + 0x18], esi
            //   4c8d44244c           | push                edi

        $sequence_40 = { 8b4b18 45 8b6320 4d }
            // n = 4, score = 300
            //   8b4b18               | mov                 ecx, dword ptr [ebx + 0x18]
            //   45                   | inc                 ebp
            //   8b6320               | mov                 esp, dword ptr [ebx + 0x20]
            //   4d                   | dec                 ebp

        $sequence_41 = { 49 8d3c8c 8b37 4c 01c6 }
            // n = 5, score = 300
            //   49                   | dec                 ecx
            //   8d3c8c               | lea                 edi, [esp + ecx*4]
            //   8b37                 | mov                 esi, dword ptr [edi]
            //   4c                   | dec                 esp
            //   01c6                 | add                 esi, eax

        $sequence_42 = { 8b7b24 4c 01c7 668b0c4f 41 8b7b1c }
            // n = 6, score = 300
            //   8b7b24               | mov                 edi, dword ptr [ebx + 0x24]
            //   4c                   | dec                 esp
            //   01c7                 | add                 edi, eax
            //   668b0c4f             | mov                 cx, word ptr [edi + ecx*2]
            //   41                   | inc                 ecx
            //   8b7b1c               | mov                 edi, dword ptr [ebx + 0x1c]

        $sequence_43 = { 01c7 8b048f 4c 01c0 }
            // n = 4, score = 300
            //   01c7                 | add                 edi, eax
            //   8b048f               | mov                 eax, dword ptr [edi + ecx*4]
            //   4c                   | dec                 esp
            //   01c0                 | add                 eax, eax

        $sequence_44 = { 8b4da0 8b55b8 89516c 687cda686e 8b45e4 50 }
            // n = 6, score = 200
            //   8b4da0               | dec                 eax
            //   8b55b8               | cmp                 eax, 0x14
            //   89516c               | jb                  0xfffffff0
            //   687cda686e           | jne                 0x2f
            //   8b45e4               | dec                 eax
            //   50                   | mov                 ecx, dword ptr [esp + 0x58]

        $sequence_45 = { 8945f8 8b45f8 8b4868 894df4 }
            // n = 4, score = 200
            //   8945f8               | mov                 esi, dword ptr [ecx + 0x20]
            //   8b45f8               | test                esi, esi
            //   8b4868               | je                  0x2d
            //   894df4               | cmp                 esi, 0x100007f

        $sequence_46 = { 31d1 75ec 58 29c6 d1ee }
            // n = 5, score = 200
            //   31d1                 | mov                 edi, ecx
            //   75ec                 | cld                 
            //   58                   | mov                 edi, ecx
            //   29c6                 | cld                 
            //   d1ee                 | mov                 dl, 0x80

        $sequence_47 = { 57 007508 bbb84340c1 4a }
            // n = 4, score = 200
            //   57                   | xor                 ebx, ebx
            //   007508               | movsb               byte ptr es:[edi], byte ptr [esi]
            //   bbb84340c1           | pushal              
            //   4a                   | mov                 esi, eax

        $sequence_48 = { 5b c9 c20800 55 89e5 83ec04 }
            // n = 6, score = 200
            //   5b                   | mov                 ebp, esp
            //   c9                   | sub                 esp, 0x454
            //   c20800               | push                ebx
            //   55                   | ret                 0x10
            //   89e5                 | push                ebp
            //   83ec04               | mov                 ebp, esp

        $sequence_49 = { aa e2f3 7506 7404 }
            // n = 4, score = 200
            //   aa                   | push                esi
            //   e2f3                 | leave               
            //   7506                 | ret                 0x10
            //   7404                 | push                ebp

        $sequence_50 = { 8b4da0 8b5580 895150 681256e9cc 8b45e4 50 }
            // n = 6, score = 200
            //   8b4da0               | je                  0x2d
            //   8b5580               | jmp                 0xd
            //   895150               | mov                 edx, dword ptr [ebp + 8]
            //   681256e9cc           | add                 edx, dword ptr [ebp - 0x10]
            //   8b45e4               | mov                 al, byte ptr [ebp - 0x13]
            //   50                   | mov                 byte ptr [edx], al

        $sequence_51 = { 3345e4 8845e3 8b4dfc 034d10 8b55f0 0355fc 034df8 }
            // n = 7, score = 200
            //   3345e4               | mov                 ecx, dword ptr [ebp + 0x10]
            //   8845e3               | add                 ecx, dword ptr [ebp - 4]
            //   8b4dfc               | mov                 ecx, dword ptr [ebp - 0x60]
            //   034d10               | mov                 edx, dword ptr [ebp - 0x48]
            //   8b55f0               | mov                 dword ptr [ecx + 0x6c], edx
            //   0355fc               | push                0x6e68da7c
            //   034df8               | mov                 eax, dword ptr [ebp - 0x1c]

        $sequence_52 = { 01e8 31c9 c1c108 3208 40 }
            // n = 5, score = 200
            //   01e8                 | cld                 
            //   31c9                 | mov                 dl, 0x80
            //   c1c108               | xor                 ebx, ebx
            //   3208                 | pushal              
            //   40                   | mov                 esi, eax

        $sequence_53 = { 8b5514 0355b4 39559c 7316 }
            // n = 4, score = 200
            //   8b5514               | mov                 ecx, dword ptr [ebp - 4]
            //   0355b4               | add                 ecx, dword ptr [ebp + 0x10]
            //   39559c               | mov                 edx, dword ptr [ebp - 0x10]
            //   7316                 | add                 edx, dword ptr [ebp - 4]

        $sequence_54 = { 8b453c 8b7c2878 01ef 8b7720 01ee 56 }
            // n = 6, score = 200
            //   8b453c               | pop                 eax
            //   8b7c2878             | sub                 esi, eax
            //   01ef                 | shr                 esi, 1
            //   8b7720               | push                edi
            //   01ee                 | add                 byte ptr [ebp + 8], dh
            //   56                   | mov                 ebx, 0xc14043b8

        $sequence_55 = { 1e 53 56 57 }
            // n = 4, score = 200
            //   1e                   | mov                 dl, 0x80
            //   53                   | xor                 ebx, ebx
            //   56                   | add                 eax, ebp
            //   57                   | xor                 ecx, ecx

        $sequence_56 = { 29c6 d1ee 037724 0fb7442efe }
            // n = 4, score = 200
            //   29c6                 | movsb               byte ptr es:[edi], byte ptr [esi]
            //   d1ee                 | mov                 esi, eax
            //   037724               | mov                 edi, ecx
            //   0fb7442efe           | cld                 

        $sequence_57 = { 394dfc 750e 8b55e4 2b5510 8b45f8 2bc2 8945f8 }
            // n = 7, score = 200
            //   394dfc               | mov                 edx, dword ptr [ebp - 0x80]
            //   750e                 | mov                 dword ptr [ecx + 0x50], edx
            //   8b55e4               | push                0xcce95612
            //   2b5510               | mov                 eax, dword ptr [ebp - 0x1c]
            //   8b45f8               | push                eax
            //   2bc2                 | xor                 eax, dword ptr [ebp - 0x1c]
            //   8945f8               | mov                 byte ptr [ebp - 0x1d], al

        $sequence_58 = { eb0b 8b5508 0355f0 8a45ed 8802 8b4d10 034dfc }
            // n = 7, score = 200
            //   eb0b                 | dec                 eax
            //   8b5508               | cmp                 eax, 0x14
            //   0355f0               | jb                  0xffffffec
            //   8a45ed               | dec                 eax
            //   8802                 | lea                 edi, [edi + 4]
            //   8b4d10               | dec                 eax
            //   034dfc               | arpl                bx, ax

        $sequence_59 = { 8bec 83ec08 8b4510 2d10bf3400 8b4d0c c1e103 }
            // n = 6, score = 200
            //   8bec                 | push                eax
            //   83ec08               | mov                 dword ptr [ebp - 8], eax
            //   8b4510               | mov                 eax, dword ptr [ebp - 8]
            //   2d10bf3400           | mov                 ecx, dword ptr [eax + 0x68]
            //   8b4d0c               | mov                 dword ptr [ebp - 0xc], ecx
            //   c1e103               | mov                 ecx, dword ptr [ebp - 0x60]

        $sequence_60 = { 5d 5d a2???????? 95 }
            // n = 4, score = 100
            //   5d                   | loop                0xfffffff6
            //   5d                   | jne                 0xb
            //   a2????????           |                     
            //   95                   | in                  eax, dx

        $sequence_61 = { 17 c74424fc7c2e0000 83ec04 7504 7402 6d }
            // n = 6, score = 100
            //   17                   | ret                 8
            //   c74424fc7c2e0000     | push                ebp
            //   83ec04               | mov                 ebp, esp
            //   7504                 | sub                 esp, 4
            //   7402                 | xor                 al, dl
            //   6d                   | stosb               byte ptr es:[edi], al

        $sequence_62 = { ad 37 5d 0aa228b9a2ce c9 5d }
            // n = 6, score = 100
            //   ad                   | stosb               byte ptr es:[edi], al
            //   37                   | loop                0xfffffff5
            //   5d                   | jne                 0xa
            //   0aa228b9a2ce         | je                  0xa
            //   c9                   | pop                 ebx
            //   5d                   | leave               

        $sequence_63 = { d4ad d6 1d51d61d41 d6 1d55d89d52 }
            // n = 5, score = 100
            //   d4ad                 | salc                
            //   d6                   | adc                 byte ptr [ebp - 0x24], cl
            //   1d51d61d41           | pushfd              
            //   d6                   | lodsd               eax, dword ptr [esi]
            //   1d55d89d52           | aaa                 

        $sequence_64 = { a2???????? ed d6 104ddc 9c }
            // n = 5, score = 100
            //   a2????????           |                     
            //   ed                   | stosb               byte ptr es:[edi], al
            //   d6                   | loop                0xfffffff6
            //   104ddc               | jne                 0xb
            //   9c                   | je                  0xb

    condition:
        7 of them and filesize < 245760
}