rule win_snifula_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.snifula."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.snifula"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { ff35???????? 89442410 6a01 57 ff15???????? 89442410 3bc7 }
            // n = 7, score = 200
            //   ff35????????         |                     
            //   89442410             | mov                 dword ptr [esp + 0x10], eax
            //   6a01                 | push                1
            //   57                   | push                edi
            //   ff15????????         |                     
            //   89442410             | mov                 dword ptr [esp + 0x10], eax
            //   3bc7                 | cmp                 eax, edi

        $sequence_1 = { 8bf8 3bfe 752f 8d45f8 50 56 ff75fc }
            // n = 7, score = 200
            //   8bf8                 | mov                 edi, eax
            //   3bfe                 | cmp                 edi, esi
            //   752f                 | jne                 0x31
            //   8d45f8               | lea                 eax, [ebp - 8]
            //   50                   | push                eax
            //   56                   | push                esi
            //   ff75fc               | push                dword ptr [ebp - 4]

        $sequence_2 = { 743b ff15???????? 8bf8 68???????? 57 ffd6 59 }
            // n = 7, score = 200
            //   743b                 | je                  0x3d
            //   ff15????????         |                     
            //   8bf8                 | mov                 edi, eax
            //   68????????           |                     
            //   57                   | push                edi
            //   ffd6                 | call                esi
            //   59                   | pop                 ecx

        $sequence_3 = { 53 33db 56 895dfc 3bfb 0f848b000000 8bc7 }
            // n = 7, score = 200
            //   53                   | push                ebx
            //   33db                 | xor                 ebx, ebx
            //   56                   | push                esi
            //   895dfc               | mov                 dword ptr [ebp - 4], ebx
            //   3bfb                 | cmp                 edi, ebx
            //   0f848b000000         | je                  0x91
            //   8bc7                 | mov                 eax, edi

        $sequence_4 = { 51 8365fc00 57 8bf8 85ff 7431 }
            // n = 6, score = 200
            //   51                   | push                ecx
            //   8365fc00             | and                 dword ptr [ebp - 4], 0
            //   57                   | push                edi
            //   8bf8                 | mov                 edi, eax
            //   85ff                 | test                edi, edi
            //   7431                 | je                  0x33

        $sequence_5 = { 895dd8 8945dc 33d2 8b4ddc 8d4104 8b09 }
            // n = 6, score = 200
            //   895dd8               | mov                 dword ptr [ebp - 0x28], ebx
            //   8945dc               | mov                 dword ptr [ebp - 0x24], eax
            //   33d2                 | xor                 edx, edx
            //   8b4ddc               | mov                 ecx, dword ptr [ebp - 0x24]
            //   8d4104               | lea                 eax, [ecx + 4]
            //   8b09                 | mov                 ecx, dword ptr [ecx]

        $sequence_6 = { e8???????? 8325????????00 5f 56 53 8b5d08 }
            // n = 6, score = 200
            //   e8????????           |                     
            //   8325????????00       |                     
            //   5f                   | pop                 edi
            //   56                   | push                esi
            //   53                   | push                ebx
            //   8b5d08               | mov                 ebx, dword ptr [ebp + 8]

        $sequence_7 = { 68???????? 56 ff15???????? 85c0 7414 56 6a00 }
            // n = 7, score = 200
            //   68????????           |                     
            //   56                   | push                esi
            //   ff15????????         |                     
            //   85c0                 | test                eax, eax
            //   7414                 | je                  0x16
            //   56                   | push                esi
            //   6a00                 | push                0

        $sequence_8 = { 8b03 e8???????? 8945fc 85c0 750f 394508 750a }
            // n = 7, score = 200
            //   8b03                 | mov                 eax, dword ptr [ebx]
            //   e8????????           |                     
            //   8945fc               | mov                 dword ptr [ebp - 4], eax
            //   85c0                 | test                eax, eax
            //   750f                 | jne                 0x11
            //   394508               | cmp                 dword ptr [ebp + 8], eax
            //   750a                 | jne                 0xc

        $sequence_9 = { ff35???????? ff35???????? 68???????? ff75f4 ffd7 83c42c ff36 }
            // n = 7, score = 200
            //   ff35????????         |                     
            //   ff35????????         |                     
            //   68????????           |                     
            //   ff75f4               | push                dword ptr [ebp - 0xc]
            //   ffd7                 | call                edi
            //   83c42c               | add                 esp, 0x2c
            //   ff36                 | push                dword ptr [esi]

    condition:
        7 of them and filesize < 188416
}