rule win_spaceship_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.spaceship."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.spaceship"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 8bc1 8bf7 8bfa c1e902 f3a5 8bc8 6a22 }
            // n = 7, score = 100
            //   8bc1                 | mov                 eax, ecx
            //   8bf7                 | mov                 esi, edi
            //   8bfa                 | mov                 edi, edx
            //   c1e902               | shr                 ecx, 2
            //   f3a5                 | rep movsd           dword ptr es:[edi], dword ptr [esi]
            //   8bc8                 | mov                 ecx, eax
            //   6a22                 | push                0x22

        $sequence_1 = { 2bf9 8bc1 8bf7 8bfa 8b94245c090000 c1e902 }
            // n = 6, score = 100
            //   2bf9                 | sub                 edi, ecx
            //   8bc1                 | mov                 eax, ecx
            //   8bf7                 | mov                 esi, edi
            //   8bfa                 | mov                 edi, edx
            //   8b94245c090000       | mov                 edx, dword ptr [esp + 0x95c]
            //   c1e902               | shr                 ecx, 2

        $sequence_2 = { 58 c3 33c0 c3 6800000300 }
            // n = 5, score = 100
            //   58                   | pop                 eax
            //   c3                   | ret                 
            //   33c0                 | xor                 eax, eax
            //   c3                   | ret                 
            //   6800000300           | push                0x30000

        $sequence_3 = { 0bc1 8d0c40 894c2428 e8???????? 8b442424 8b0d???????? 56 }
            // n = 7, score = 100
            //   0bc1                 | or                  eax, ecx
            //   8d0c40               | lea                 ecx, [eax + eax*2]
            //   894c2428             | mov                 dword ptr [esp + 0x28], ecx
            //   e8????????           |                     
            //   8b442424             | mov                 eax, dword ptr [esp + 0x24]
            //   8b0d????????         |                     
            //   56                   | push                esi

        $sequence_4 = { f3a4 8d4c240c 51 e8???????? 83c408 85c0 0f84d7000000 }
            // n = 7, score = 100
            //   f3a4                 | rep movsb           byte ptr es:[edi], byte ptr [esi]
            //   8d4c240c             | lea                 ecx, [esp + 0xc]
            //   51                   | push                ecx
            //   e8????????           |                     
            //   83c408               | add                 esp, 8
            //   85c0                 | test                eax, eax
            //   0f84d7000000         | je                  0xdd

        $sequence_5 = { 66899c24d6030000 c78424d803000080684100 66c78424dc0300001a00 66899424de030000 c78424e003000078684100 }
            // n = 5, score = 100
            //   66899c24d6030000     | mov                 word ptr [esp + 0x3d6], bx
            //   c78424d803000080684100     | mov    dword ptr [esp + 0x3d8], 0x416880
            //   66c78424dc0300001a00     | mov    word ptr [esp + 0x3dc], 0x1a
            //   66899424de030000     | mov                 word ptr [esp + 0x3de], dx
            //   c78424e003000078684100     | mov    dword ptr [esp + 0x3e0], 0x416878

        $sequence_6 = { 8d8c2410020000 68ac5d0000 51 68???????? 68???????? }
            // n = 5, score = 100
            //   8d8c2410020000       | lea                 ecx, [esp + 0x210]
            //   68ac5d0000           | push                0x5dac
            //   51                   | push                ecx
            //   68????????           |                     
            //   68????????           |                     

        $sequence_7 = { 85c0 741a 8078ff3a 7506 c6400100 eb03 }
            // n = 6, score = 100
            //   85c0                 | test                eax, eax
            //   741a                 | je                  0x1c
            //   8078ff3a             | cmp                 byte ptr [eax - 1], 0x3a
            //   7506                 | jne                 8
            //   c6400100             | mov                 byte ptr [eax + 1], 0
            //   eb03                 | jmp                 5

        $sequence_8 = { 8bc2 83e103 f3a4 5f 5e 81c40c010000 c3 }
            // n = 7, score = 100
            //   8bc2                 | mov                 eax, edx
            //   83e103               | and                 ecx, 3
            //   f3a4                 | rep movsb           byte ptr es:[edi], byte ptr [esi]
            //   5f                   | pop                 edi
            //   5e                   | pop                 esi
            //   81c40c010000         | add                 esp, 0x10c
            //   c3                   | ret                 

        $sequence_9 = { f2ae f7d1 2bf9 8bc1 8bf7 8bfa 8b942470060000 }
            // n = 7, score = 100
            //   f2ae                 | repne scasb         al, byte ptr es:[edi]
            //   f7d1                 | not                 ecx
            //   2bf9                 | sub                 edi, ecx
            //   8bc1                 | mov                 eax, ecx
            //   8bf7                 | mov                 esi, edi
            //   8bfa                 | mov                 edi, edx
            //   8b942470060000       | mov                 edx, dword ptr [esp + 0x670]

    condition:
        7 of them and filesize < 262144
}