rule win_splitloader_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.splitloader."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.splitloader"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 488bc8 ff15???????? 4c8bd8 488905???????? 4885c0 7422 488d151d420000 }
            // n = 7, score = 100
            //   488bc8               | mov                 eax, 0x206
            //   ff15????????         |                     
            //   4c8bd8               | mov                 word ptr [ebp + 0x90], si
            //   488905????????       |                     
            //   4885c0               | mov                 word ptr [ebp + 0x4b0], si
            //   7422                 | inc                 esp
            //   488d151d420000       | mov                 eax, esi

        $sequence_1 = { 48014d00 418b4c241c 418984240cab0000 418b8424f82a0000 894d4c 488b8c2488000000 3bce }
            // n = 7, score = 100
            //   48014d00             | dec                 ecx
            //   418b4c241c           | cmp                 eax, ecx
            //   418984240cab0000     | jb                  0x1c
            //   418b8424f82a0000     | dec                 eax
            //   894d4c               | inc                 edi
            //   488b8c2488000000     | inc                 ebp
            //   3bce                 | cmp                 ecx, ebx

        $sequence_2 = { 4c8d5801 4889442448 4c85d8 0f85ff150000 }
            // n = 4, score = 100
            //   4c8d5801             | dec                 eax
            //   4889442448           | mov                 ecx, dword ptr [eax + ecx*8]
            //   4c85d8               | dec                 eax
            //   0f85ff150000         | mov                 ecx, dword ptr [ebp - 0x20]

        $sequence_3 = { 488bc8 458d4104 4889742420 ff15???????? 4533c9 }
            // n = 5, score = 100
            //   488bc8               | mov                 eax, ebx
            //   458d4104             | dec                 eax
            //   4889742420           | lea                 edx, [0x9267]
            //   ff15????????         |                     
            //   4533c9               | jmp                 0x69d

        $sequence_4 = { e9???????? 8a03 488d1535c30000 ffc7 4a8b0ce2 4188440f4c 4a8b04e2 }
            // n = 7, score = 100
            //   e9????????           |                     
            //   8a03                 | test                edx, edx
            //   488d1535c30000       | je                  0x43d
            //   ffc7                 | mov                 word ptr [edx], cx
            //   4a8b0ce2             | dec                 eax
            //   4188440f4c           | add                 edx, 2
            //   4a8b04e2             | movzx               ecx, word ptr [eax + 2]

        $sequence_5 = { 895dac 895dbc 895df0 4c894dd0 }
            // n = 4, score = 100
            //   895dac               | lea                 edx, [0x66dc]
            //   895dbc               | dec                 eax
            //   895df0               | lea                 ecx, [0x66cd]
            //   4c894dd0             | nop                 

        $sequence_6 = { 0f8c92000000 41838c24042b000001 85c0 0f84ad000000 8b4118 4c8b4910 488b11 }
            // n = 7, score = 100
            //   0f8c92000000         | cmp                 dword ptr [ecx + 0x14], ebx
            //   41838c24042b000001     | dec    edx
            //   85c0                 | mov                 ecx, dword ptr [eax]
            //   0f84ad000000         | dec                 ecx
            //   8b4118               | mov                 ecx, dword ptr [edi + ecx]
            //   4c8b4910             | sete                bl
            //   488b11               | dec                 eax

        $sequence_7 = { 782e 3b0d???????? 7326 4863c9 488d150c930000 488bc1 }
            // n = 6, score = 100
            //   782e                 | nop                 dword ptr [eax]
            //   3b0d????????         |                     
            //   7326                 | dec                 eax
            //   4863c9               | arpl                dx, ax
            //   488d150c930000       | movzx               ecx, byte ptr [esp + eax + 0x50]
            //   488bc1               | xor                 byte ptr [edi + ebx], cl

        $sequence_8 = { eb77 4c89ac2400080000 4c8b6808 488b00 39b08c000000 744a 8b9888000000 }
            // n = 7, score = 100
            //   eb77                 | jb                  0x53b
            //   4c89ac2400080000     | inc                 esp
            //   4c8b6808             | mov                 ebx, dword ptr [esp + 0x40]
            //   488b00               | inc                 ecx
            //   39b08c000000         | mov                 eax, ebx
            //   744a                 | mov                 ecx, 0x40
            //   8b9888000000         | inc                 ecx

        $sequence_9 = { 4c8d0513700000 41b903000000 488d4c45bc 488bc1 492bc5 48d1f8 }
            // n = 6, score = 100
            //   4c8d0513700000       | mov                 dword ptr [eax], esi
            //   41b903000000         | dec                 eax
            //   488d4c45bc           | mov                 eax, dword ptr [esp + 0x70]
            //   488bc1               | dec                 esp
            //   492bc5               | sub                 ebx, ebx
            //   48d1f8               | dec                 esp

    condition:
        7 of them and filesize < 174080
}