rule win_stalin_locker_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2020-10-14"
        version = "1"
        description = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.5.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.stalin_locker"
        malpedia_rule_date = "20201014"
        malpedia_hash = "a7e3bd57eaf12bf3ea29a863c041091ba3af9ac9"
        malpedia_version = "20201014"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 0a925609e2de 0bd4 4b 2b79a6 daa7503aabb5 631d???????? 51 }
            // n = 7, score = 100
            //   0a925609e2de         | or                  dl, byte ptr [edx - 0x211df6aa]
            //   0bd4                 | or                  edx, esp
            //   4b                   | dec                 ebx
            //   2b79a6               | sub                 edi, dword ptr [ecx - 0x5a]
            //   daa7503aabb5         | fisub               dword ptr [edi - 0x4a54c5b0]
            //   631d????????         |                     
            //   51                   | push                ecx

        $sequence_1 = { 07 e715 64ab 9c 8092f77c21fb66 f2a4 }
            // n = 6, score = 100
            //   07                   | pop                 es
            //   e715                 | out                 0x15, eax
            //   64ab                 | stosd               dword ptr es:[edi], eax
            //   9c                   | pushfd              
            //   8092f77c21fb66       | adc                 byte ptr [edx - 0x4de8309], 0x66
            //   f2a4                 | repne movsb         byte ptr es:[edi], byte ptr [esi]

        $sequence_2 = { 884eb6 64f8 00db 0cc7 31cc 238aace2849d d40a }
            // n = 7, score = 100
            //   884eb6               | mov                 byte ptr [esi - 0x4a], cl
            //   64f8                 | clc                 
            //   00db                 | add                 bl, bl
            //   0cc7                 | or                  al, 0xc7
            //   31cc                 | xor                 esp, ecx
            //   238aace2849d         | and                 ecx, dword ptr [edx - 0x627b1d54]
            //   d40a                 | aam                 

        $sequence_3 = { ec 0c0d 7456 4a 3120 60 }
            // n = 6, score = 100
            //   ec                   | in                  al, dx
            //   0c0d                 | or                  al, 0xd
            //   7456                 | je                  0x58
            //   4a                   | dec                 edx
            //   3120                 | xor                 dword ptr [eax], esp
            //   60                   | pushal              

        $sequence_4 = { 43 30f0 011c02 5f }
            // n = 4, score = 100
            //   43                   | inc                 ebx
            //   30f0                 | xor                 al, dh
            //   011c02               | add                 dword ptr [edx + eax], ebx
            //   5f                   | pop                 edi

        $sequence_5 = { c008f0 6494 b09a 6d }
            // n = 4, score = 100
            //   c008f0               | ror                 byte ptr [eax], 0xf0
            //   6494                 | xchg                eax, esp
            //   b09a                 | mov                 al, 0x9a
            //   6d                   | insd                dword ptr es:[edi], dx

        $sequence_6 = { 90 2a68c0 d86107 43 }
            // n = 4, score = 100
            //   90                   | nop                 
            //   2a68c0               | sub                 ch, byte ptr [eax - 0x40]
            //   d86107               | fsub                dword ptr [ecx + 7]
            //   43                   | inc                 ebx

        $sequence_7 = { f7ff fc 61 78df 2442 7303 8b4b03 }
            // n = 7, score = 100
            //   f7ff                 | idiv                edi
            //   fc                   | cld                 
            //   61                   | popal               
            //   78df                 | js                  0xffffffe1
            //   2442                 | and                 al, 0x42
            //   7303                 | jae                 5
            //   8b4b03               | mov                 ecx, dword ptr [ebx + 3]

        $sequence_8 = { 98 05bce0a0b6 0f6288bf084202 7150 }
            // n = 4, score = 100
            //   98                   | cwde                
            //   05bce0a0b6           | add                 eax, 0xb6a0e0bc
            //   0f6288bf084202       | punpckldq           mm1, qword ptr [eax + 0x24208bf]
            //   7150                 | jno                 0x52

        $sequence_9 = { b221 d10f 54 7676 }
            // n = 4, score = 100
            //   b221                 | mov                 dl, 0x21
            //   d10f                 | ror                 dword ptr [edi], 1
            //   54                   | push                esp
            //   7676                 | jbe                 0x78

    condition:
        7 of them and filesize < 8650752
}