rule win_stration_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.stration."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.stration"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 57 8d54240c 52 33f6 56 8d442418 50 }
            // n = 7, score = 100
            //   57                   | push                edi
            //   8d54240c             | lea                 edx, [esp + 0xc]
            //   52                   | push                edx
            //   33f6                 | xor                 esi, esi
            //   56                   | push                esi
            //   8d442418             | lea                 eax, [esp + 0x18]
            //   50                   | push                eax

        $sequence_1 = { a1???????? 80f253 83ec24 85c0 8815???????? }
            // n = 5, score = 100
            //   a1????????           |                     
            //   80f253               | xor                 dl, 0x53
            //   83ec24               | sub                 esp, 0x24
            //   85c0                 | test                eax, eax
            //   8815????????         |                     

        $sequence_2 = { c744241000000000 eb0c 8a0d???????? 880d???????? 6a01 56 }
            // n = 6, score = 100
            //   c744241000000000     | mov                 dword ptr [esp + 0x10], 0
            //   eb0c                 | jmp                 0xe
            //   8a0d????????         |                     
            //   880d????????         |                     
            //   6a01                 | push                1
            //   56                   | push                esi

        $sequence_3 = { 52 e8???????? a3???????? 8b4c2420 51 }
            // n = 5, score = 100
            //   52                   | push                edx
            //   e8????????           |                     
            //   a3????????           |                     
            //   8b4c2420             | mov                 ecx, dword ptr [esp + 0x20]
            //   51                   | push                ecx

        $sequence_4 = { ba11010000 8bce e8???????? c705????????00000000 }
            // n = 4, score = 100
            //   ba11010000           | mov                 edx, 0x111
            //   8bce                 | mov                 ecx, esi
            //   e8????????           |                     
            //   c705????????00000000     |     

        $sequence_5 = { 8b15???????? 89442404 a1???????? 894c2408 8a0d???????? 89442410 8954240c }
            // n = 7, score = 100
            //   8b15????????         |                     
            //   89442404             | mov                 dword ptr [esp + 4], eax
            //   a1????????           |                     
            //   894c2408             | mov                 dword ptr [esp + 8], ecx
            //   8a0d????????         |                     
            //   89442410             | mov                 dword ptr [esp + 0x10], eax
            //   8954240c             | mov                 dword ptr [esp + 0xc], edx

        $sequence_6 = { 8bff 8a1404 8a4c240c 32d1 881404 40 83f80d }
            // n = 7, score = 100
            //   8bff                 | mov                 edi, edi
            //   8a1404               | mov                 dl, byte ptr [esp + eax]
            //   8a4c240c             | mov                 cl, byte ptr [esp + 0xc]
            //   32d1                 | xor                 dl, cl
            //   881404               | mov                 byte ptr [esp + eax], dl
            //   40                   | inc                 eax
            //   83f80d               | cmp                 eax, 0xd

        $sequence_7 = { 8a1404 8a4c240c 32d1 881404 }
            // n = 4, score = 100
            //   8a1404               | mov                 dl, byte ptr [esp + eax]
            //   8a4c240c             | mov                 cl, byte ptr [esp + 0xc]
            //   32d1                 | xor                 dl, cl
            //   881404               | mov                 byte ptr [esp + eax], dl

        $sequence_8 = { 8d8c24b4000000 51 33f6 e8???????? }
            // n = 4, score = 100
            //   8d8c24b4000000       | lea                 ecx, [esp + 0xb4]
            //   51                   | push                ecx
            //   33f6                 | xor                 esi, esi
            //   e8????????           |                     

        $sequence_9 = { 83f825 7cec 8b3d???????? 68???????? }
            // n = 4, score = 100
            //   83f825               | cmp                 eax, 0x25
            //   7cec                 | jl                  0xffffffee
            //   8b3d????????         |                     
            //   68????????           |                     

    condition:
        7 of them and filesize < 49152
}