rule win_strelastealer_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.strelastealer."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.strelastealer"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 4053 4883ec20 488d058bf80000 488bda 4a8b04c0 483902 7416 }
            // n = 7, score = 100
            //   4053                 | mov                 eax, 0x104
            //   4883ec20             | xor                 edx, edx
            //   488d058bf80000       | dec                 eax
            //   488bda               | lea                 ecx, [ebp + 0x1c0]
            //   4a8b04c0             | inc                 ecx
            //   483902               | mov                 eax, 0x104
            //   7416                 | dec                 eax

        $sequence_1 = { 51 8d94246c010000 52 8d842478020000 }
            // n = 4, score = 100
            //   51                   | dec                 eax
            //   8d94246c010000       | lea                 ecx, [esp + 0x30]
            //   52                   | movups              xmm1, xmmword ptr [eax + 0x10]
            //   8d842478020000       | movups              xmmword ptr [ecx], xmm0

        $sequence_2 = { e9???????? e8???????? 488d1d8a4f0100 41b804010000 488bd3 33c9 }
            // n = 6, score = 100
            //   e9????????           |                     
            //   e8????????           |                     
            //   488d1d8a4f0100       | add                 esp, 0x20
            //   41b804010000         | pop                 edi
            //   488bd3               | mov                 ecx, dword ptr [edx]
            //   33c9                 | nop                 

        $sequence_3 = { 6a0d 8bf8 e8???????? 8b0d???????? 8bf0 890e 8b15???????? }
            // n = 7, score = 100
            //   6a0d                 | dec                 edx
            //   8bf8                 | mov                 eax, dword ptr [eax + eax*8]
            //   e8????????           |                     
            //   8b0d????????         |                     
            //   8bf0                 | dec                 eax
            //   890e                 | cmp                 dword ptr [edx], eax
            //   8b15????????         |                     

        $sequence_4 = { 4883c118 41b801010000 e8???????? 33d2 488d7b0c 0fb7c2 4c8d0d56150100 }
            // n = 7, score = 100
            //   4883c118             | dec                 eax
            //   41b801010000         | lea                 ebx, [0x14fa2]
            //   e8????????           |                     
            //   33d2                 | xor                 edx, edx
            //   488d7b0c             | dec                 eax
            //   0fb7c2               | lea                 ecx, [ebp + 0x3e0]
            //   4c8d0d56150100       | inc                 ecx

        $sequence_5 = { 8bf0 57 4e ffd3 33c9 }
            // n = 5, score = 100
            //   8bf0                 | sub                 esp, 0x20
            //   57                   | dec                 eax
            //   4e                   | lea                 eax, [0xf88b]
            //   ffd3                 | dec                 eax
            //   33c9                 | mov                 ebx, edx

        $sequence_6 = { 488b6c2438 488bc3 488b5c2430 488b742448 4883c420 5f }
            // n = 6, score = 100
            //   488b6c2438           | dec                 eax
            //   488bc3               | mov                 dword ptr [esp + 0x30], eax
            //   488b5c2430           | dec                 esp
            //   488b742448           | lea                 eax, [ebp - 0x60]
            //   4883c420             | dec                 eax
            //   5f                   | lea                 eax, [ebp - 0x78]

        $sequence_7 = { ffd5 85c0 7566 8b4c2428 89442440 89442444 89442434 }
            // n = 7, score = 100
            //   ffd5                 | dec                 ecx
            //   85c0                 | mov                 ecx, eax
            //   7566                 | dec                 esp
            //   8b4c2428             | lea                 edx, [0xcd41]
            //   89442440             | and                 ecx, 0x3f
            //   89442444             | dec                 ecx
            //   89442434             | mov                 eax, eax

        $sequence_8 = { 4889442438 4c8d4c2470 488d8500060000 c785400a000000040000 4889442430 4c8d45a0 488d4588 }
            // n = 7, score = 100
            //   4889442438           | dec                 eax
            //   4c8d4c2470           | mov                 dword ptr [esp + 0x38], eax
            //   488d8500060000       | dec                 esp
            //   c785400a000000040000     | lea    ecx, [esp + 0x70]
            //   4889442430           | dec                 eax
            //   4c8d45a0             | lea                 eax, [ebp + 0x600]
            //   488d4588             | mov                 dword ptr [ebp + 0xa40], 0x400

        $sequence_9 = { 8b0a e8???????? 90 488d1da24f0100 }
            // n = 4, score = 100
            //   8b0a                 | dec                 eax
            //   e8????????           |                     
            //   90                   | mov                 ebp, dword ptr [esp + 0x38]
            //   488d1da24f0100       | dec                 eax

        $sequence_10 = { 8d842470030000 50 8d8c247c040000 51 8d942470020000 52 68???????? }
            // n = 7, score = 100
            //   8d842470030000       | je                  0x29
            //   50                   | dec                 esp
            //   8d8c247c040000       | mov                 edx, dword ptr [ebp + 0x77]
            //   51                   | dec                 eax
            //   8d942470020000       | lea                 eax, [0xdce1]
            //   52                   | movups              xmm0, xmmword ptr [eax]
            //   68????????           |                     

        $sequence_11 = { 68???????? ff15???????? 6a0d 8bf8 }
            // n = 4, score = 100
            //   68????????           |                     
            //   ff15????????         |                     
            //   6a0d                 | dec                 esp
            //   8bf8                 | mov                 ebx, ecx

        $sequence_12 = { 4c8b5577 488d05e1dc0000 0f1000 4c8bd9 488d4c2430 0f104810 0f1101 }
            // n = 7, score = 100
            //   4c8b5577             | lea                 ebx, [0x14f8a]
            //   488d05e1dc0000       | inc                 ecx
            //   0f1000               | mov                 eax, 0x104
            //   4c8bd9               | dec                 eax
            //   488d4c2430           | mov                 edx, ebx
            //   0f104810             | xor                 ecx, ecx
            //   0f1101               | dec                 eax

        $sequence_13 = { ff15???????? ff15???????? 3db7000000 740a e8???????? }
            // n = 5, score = 100
            //   ff15????????         |                     
            //   ff15????????         |                     
            //   3db7000000           | dec                 eax
            //   740a                 | lea                 edi, [ebx + 0xc]
            //   e8????????           |                     

        $sequence_14 = { 85c0 0f842f020000 6804010000 8d8c247c030000 6a00 51 e8???????? }
            // n = 7, score = 100
            //   85c0                 | movzx               eax, dx
            //   0f842f020000         | dec                 esp
            //   6804010000           | lea                 ecx, [0x11556]
            //   8d8c247c030000       | inc                 eax
            //   6a00                 | push                ebx
            //   51                   | dec                 eax
            //   e8????????           |                     

        $sequence_15 = { 33d2 488d8de0030000 41b804010000 e8???????? 33d2 488d8dc0010000 41b804010000 }
            // n = 7, score = 100
            //   33d2                 | mov                 eax, ebx
            //   488d8de0030000       | dec                 eax
            //   41b804010000         | mov                 ebx, dword ptr [esp + 0x30]
            //   e8????????           |                     
            //   33d2                 | dec                 eax
            //   488d8dc0010000       | mov                 esi, dword ptr [esp + 0x48]
            //   41b804010000         | dec                 eax

    condition:
        7 of them and filesize < 266240
}