rule win_sunorcal_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.sunorcal."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.sunorcal"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 6a03 e8???????? cc 55 8bec 83ec0c }
            // n = 6, score = 200
            //   6a03                 | push                3
            //   e8????????           |                     
            //   cc                   | int3                
            //   55                   | push                ebp
            //   8bec                 | mov                 ebp, esp
            //   83ec0c               | sub                 esp, 0xc

        $sequence_1 = { 5b c21000 8b442404 8b00 }
            // n = 4, score = 200
            //   5b                   | pop                 ebx
            //   c21000               | ret                 0x10
            //   8b442404             | mov                 eax, dword ptr [esp + 4]
            //   8b00                 | mov                 eax, dword ptr [eax]

        $sequence_2 = { 7c02 eb0e e8???????? e8???????? 85c0 }
            // n = 5, score = 200
            //   7c02                 | jl                  4
            //   eb0e                 | jmp                 0x10
            //   e8????????           |                     
            //   e8????????           |                     
            //   85c0                 | test                eax, eax

        $sequence_3 = { 5b c21000 8b442404 8b00 813863736de0 752a }
            // n = 6, score = 200
            //   5b                   | pop                 ebx
            //   c21000               | ret                 0x10
            //   8b442404             | mov                 eax, dword ptr [esp + 4]
            //   8b00                 | mov                 eax, dword ptr [eax]
            //   813863736de0         | cmp                 dword ptr [eax], 0xe06d7363
            //   752a                 | jne                 0x2c

        $sequence_4 = { 5b c21000 8b442404 8b00 813863736de0 752a 83781003 }
            // n = 7, score = 200
            //   5b                   | pop                 ebx
            //   c21000               | ret                 0x10
            //   8b442404             | mov                 eax, dword ptr [esp + 4]
            //   8b00                 | mov                 eax, dword ptr [eax]
            //   813863736de0         | cmp                 dword ptr [eax], 0xe06d7363
            //   752a                 | jne                 0x2c
            //   83781003             | cmp                 dword ptr [eax + 0x10], 3

        $sequence_5 = { 5e 5b c21000 8b442404 8b00 813863736de0 752a }
            // n = 7, score = 200
            //   5e                   | pop                 esi
            //   5b                   | pop                 ebx
            //   c21000               | ret                 0x10
            //   8b442404             | mov                 eax, dword ptr [esp + 4]
            //   8b00                 | mov                 eax, dword ptr [eax]
            //   813863736de0         | cmp                 dword ptr [eax], 0xe06d7363
            //   752a                 | jne                 0x2c

        $sequence_6 = { eb0e e8???????? e8???????? 85c0 }
            // n = 4, score = 200
            //   eb0e                 | jmp                 0x10
            //   e8????????           |                     
            //   e8????????           |                     
            //   85c0                 | test                eax, eax

        $sequence_7 = { 50 6a00 ff15???????? 6800040000 e8???????? }
            // n = 5, score = 200
            //   50                   | push                eax
            //   6a00                 | push                0
            //   ff15????????         |                     
            //   6800040000           | push                0x400
            //   e8????????           |                     

        $sequence_8 = { ff15???????? 68b7000000 ff15???????? 6a64 68???????? }
            // n = 5, score = 200
            //   ff15????????         |                     
            //   68b7000000           | push                0xb7
            //   ff15????????         |                     
            //   6a64                 | push                0x64
            //   68????????           |                     

        $sequence_9 = { c21000 8b442404 8b00 813863736de0 752a 83781003 }
            // n = 6, score = 200
            //   c21000               | ret                 0x10
            //   8b442404             | mov                 eax, dword ptr [esp + 4]
            //   8b00                 | mov                 eax, dword ptr [eax]
            //   813863736de0         | cmp                 dword ptr [eax], 0xe06d7363
            //   752a                 | jne                 0x2c
            //   83781003             | cmp                 dword ptr [eax + 0x10], 3

    condition:
        7 of them and filesize < 172032
}