rule win_swen_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.swen."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.swen"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 6a03 68000000c0 8d8574ffffff 50 8b1d???????? }
            // n = 5, score = 100
            //   6a03                 | push                3
            //   68000000c0           | push                0xc0000000
            //   8d8574ffffff         | lea                 eax, [ebp - 0x8c]
            //   50                   | push                eax
            //   8b1d????????         |                     

        $sequence_1 = { 834dfcff e9???????? e8???????? 85c0 0f8609010000 83a5388affff00 6a00 }
            // n = 7, score = 100
            //   834dfcff             | or                  dword ptr [ebp - 4], 0xffffffff
            //   e9????????           |                     
            //   e8????????           |                     
            //   85c0                 | test                eax, eax
            //   0f8609010000         | jbe                 0x10f
            //   83a5388affff00       | and                 dword ptr [ebp - 0x75c8], 0
            //   6a00                 | push                0

        $sequence_2 = { 50 ff7508 57 8d85e0feffff 50 ffd6 83c410 }
            // n = 7, score = 100
            //   50                   | push                eax
            //   ff7508               | push                dword ptr [ebp + 8]
            //   57                   | push                edi
            //   8d85e0feffff         | lea                 eax, [ebp - 0x120]
            //   50                   | push                eax
            //   ffd6                 | call                esi
            //   83c410               | add                 esp, 0x10

        $sequence_3 = { 85c0 0f8401030000 68???????? 68???????? 8d8574ffffff 50 8b35???????? }
            // n = 7, score = 100
            //   85c0                 | test                eax, eax
            //   0f8401030000         | je                  0x307
            //   68????????           |                     
            //   68????????           |                     
            //   8d8574ffffff         | lea                 eax, [ebp - 0x8c]
            //   50                   | push                eax
            //   8b35????????         |                     

        $sequence_4 = { e8???????? 8d8504fbffff 50 57 e8???????? 6a70 57 }
            // n = 7, score = 100
            //   e8????????           |                     
            //   8d8504fbffff         | lea                 eax, [ebp - 0x4fc]
            //   50                   | push                eax
            //   57                   | push                edi
            //   e8????????           |                     
            //   6a70                 | push                0x70
            //   57                   | push                edi

        $sequence_5 = { 8bf8 897dd8 85ff 7510 8b8570ffffff 8dbc0560dfffff 897dd8 }
            // n = 7, score = 100
            //   8bf8                 | mov                 edi, eax
            //   897dd8               | mov                 dword ptr [ebp - 0x28], edi
            //   85ff                 | test                edi, edi
            //   7510                 | jne                 0x12
            //   8b8570ffffff         | mov                 eax, dword ptr [ebp - 0x90]
            //   8dbc0560dfffff       | lea                 edi, [ebp + eax - 0x20a0]
            //   897dd8               | mov                 dword ptr [ebp - 0x28], edi

        $sequence_6 = { 6a03 bf000000c0 57 68???????? 8d850cffffff 50 e8???????? }
            // n = 7, score = 100
            //   6a03                 | push                3
            //   bf000000c0           | mov                 edi, 0xc0000000
            //   57                   | push                edi
            //   68????????           |                     
            //   8d850cffffff         | lea                 eax, [ebp - 0xf4]
            //   50                   | push                eax
            //   e8????????           |                     

        $sequence_7 = { ff15???????? 8945e0 3bc6 740e 6a01 56 }
            // n = 6, score = 100
            //   ff15????????         |                     
            //   8945e0               | mov                 dword ptr [ebp - 0x20], eax
            //   3bc6                 | cmp                 eax, esi
            //   740e                 | je                  0x10
            //   6a01                 | push                1
            //   56                   | push                esi

        $sequence_8 = { 53 6a06 ff15???????? 53 ff15???????? 8b4df0 64890d00000000 }
            // n = 7, score = 100
            //   53                   | push                ebx
            //   6a06                 | push                6
            //   ff15????????         |                     
            //   53                   | push                ebx
            //   ff15????????         |                     
            //   8b4df0               | mov                 ecx, dword ptr [ebp - 0x10]
            //   64890d00000000       | mov                 dword ptr fs:[0], ecx

        $sequence_9 = { ff7508 ff75e4 8d85d8feffff 50 e8???????? 83c40c }
            // n = 6, score = 100
            //   ff7508               | push                dword ptr [ebp + 8]
            //   ff75e4               | push                dword ptr [ebp - 0x1c]
            //   8d85d8feffff         | lea                 eax, [ebp - 0x128]
            //   50                   | push                eax
            //   e8????????           |                     
            //   83c40c               | add                 esp, 0xc

    condition:
        7 of them and filesize < 286720
}