rule win_sword_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.sword."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.sword"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 8d4c2430 6a01 51 e8???????? 83c410 }
            // n = 5, score = 100
            //   8d4c2430             | lea                 ecx, [esp + 0x30]
            //   6a01                 | push                1
            //   51                   | push                ecx
            //   e8????????           |                     
            //   83c410               | add                 esp, 0x10

        $sequence_1 = { 8dbc24d40b0000 f3ab ebb7 8b542414 }
            // n = 4, score = 100
            //   8dbc24d40b0000       | lea                 edi, [esp + 0xbd4]
            //   f3ab                 | rep stosd           dword ptr es:[edi], eax
            //   ebb7                 | jmp                 0xffffffb9
            //   8b542414             | mov                 edx, dword ptr [esp + 0x14]

        $sequence_2 = { 8b442410 50 ffd6 8d8c2484020000 }
            // n = 4, score = 100
            //   8b442410             | mov                 eax, dword ptr [esp + 0x10]
            //   50                   | push                eax
            //   ffd6                 | call                esi
            //   8d8c2484020000       | lea                 ecx, [esp + 0x284]

        $sequence_3 = { 81c408020000 c3 83c9ff 33c0 f2ae f7d1 2bf9 }
            // n = 7, score = 100
            //   81c408020000         | add                 esp, 0x208
            //   c3                   | ret                 
            //   83c9ff               | or                  ecx, 0xffffffff
            //   33c0                 | xor                 eax, eax
            //   f2ae                 | repne scasb         al, byte ptr es:[edi]
            //   f7d1                 | not                 ecx
            //   2bf9                 | sub                 edi, ecx

        $sequence_4 = { 49 885c29ff 807d0022 7520 8d7d01 83c9ff }
            // n = 6, score = 100
            //   49                   | dec                 ecx
            //   885c29ff             | mov                 byte ptr [ecx + ebp - 1], bl
            //   807d0022             | cmp                 byte ptr [ebp], 0x22
            //   7520                 | jne                 0x22
            //   8d7d01               | lea                 edi, [ebp + 1]
            //   83c9ff               | or                  ecx, 0xffffffff

        $sequence_5 = { 81c4c40f0000 c3 8bb424d80f0000 8b442410 }
            // n = 4, score = 100
            //   81c4c40f0000         | add                 esp, 0xfc4
            //   c3                   | ret                 
            //   8bb424d80f0000       | mov                 esi, dword ptr [esp + 0xfd8]
            //   8b442410             | mov                 eax, dword ptr [esp + 0x10]

        $sequence_6 = { b940000000 33c0 8d7c2419 8894241c010000 f3ab }
            // n = 5, score = 100
            //   b940000000           | mov                 ecx, 0x40
            //   33c0                 | xor                 eax, eax
            //   8d7c2419             | lea                 edi, [esp + 0x19]
            //   8894241c010000       | mov                 byte ptr [esp + 0x11c], dl
            //   f3ab                 | rep stosd           dword ptr es:[edi], eax

        $sequence_7 = { 8d4c2420 6a3a 51 e8???????? 83c410 85c0 }
            // n = 6, score = 100
            //   8d4c2420             | lea                 ecx, [esp + 0x20]
            //   6a3a                 | push                0x3a
            //   51                   | push                ecx
            //   e8????????           |                     
            //   83c410               | add                 esp, 0x10
            //   85c0                 | test                eax, eax

        $sequence_8 = { f2ae f7d1 49 bf???????? 894c2414 83c9ff }
            // n = 6, score = 100
            //   f2ae                 | repne scasb         al, byte ptr es:[edi]
            //   f7d1                 | not                 ecx
            //   49                   | dec                 ecx
            //   bf????????           |                     
            //   894c2414             | mov                 dword ptr [esp + 0x14], ecx
            //   83c9ff               | or                  ecx, 0xffffffff

        $sequence_9 = { f7d1 49 83f903 77c8 bf???????? }
            // n = 5, score = 100
            //   f7d1                 | not                 ecx
            //   49                   | dec                 ecx
            //   83f903               | cmp                 ecx, 3
            //   77c8                 | ja                  0xffffffca
            //   bf????????           |                     

    condition:
        7 of them and filesize < 106496
}