rule win_sys10_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.sys10."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.sys10"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 8d4c2413 51 6800400000 52 }
            // n = 4, score = 200
            //   8d4c2413             | lea                 ecx, [esp + 0x13]
            //   51                   | push                ecx
            //   6800400000           | push                0x4000
            //   52                   | push                edx

        $sequence_1 = { 8b542408 6a03 50 8b44240c 51 }
            // n = 5, score = 200
            //   8b542408             | mov                 edx, dword ptr [esp + 8]
            //   6a03                 | push                3
            //   50                   | push                eax
            //   8b44240c             | mov                 eax, dword ptr [esp + 0xc]
            //   51                   | push                ecx

        $sequence_2 = { 53 ff15???????? 8b06 50 e8???????? 8b442418 }
            // n = 6, score = 200
            //   53                   | push                ebx
            //   ff15????????         |                     
            //   8b06                 | mov                 eax, dword ptr [esi]
            //   50                   | push                eax
            //   e8????????           |                     
            //   8b442418             | mov                 eax, dword ptr [esp + 0x18]

        $sequence_3 = { 8b442410 8b4c240c 8b542408 6a03 50 }
            // n = 5, score = 200
            //   8b442410             | mov                 eax, dword ptr [esp + 0x10]
            //   8b4c240c             | mov                 ecx, dword ptr [esp + 0xc]
            //   8b542408             | mov                 edx, dword ptr [esp + 8]
            //   6a03                 | push                3
            //   50                   | push                eax

        $sequence_4 = { 7407 53 ff15???????? 8b06 50 }
            // n = 5, score = 200
            //   7407                 | je                  9
            //   53                   | push                ebx
            //   ff15????????         |                     
            //   8b06                 | mov                 eax, dword ptr [esi]
            //   50                   | push                eax

        $sequence_5 = { 6a03 68???????? 68???????? 51 52 }
            // n = 5, score = 200
            //   6a03                 | push                3
            //   68????????           |                     
            //   68????????           |                     
            //   51                   | push                ecx
            //   52                   | push                edx

        $sequence_6 = { 52 ffd7 8b4308 50 }
            // n = 4, score = 200
            //   52                   | push                edx
            //   ffd7                 | call                edi
            //   8b4308               | mov                 eax, dword ptr [ebx + 8]
            //   50                   | push                eax

        $sequence_7 = { 6800400000 52 50 e8???????? 8bf8 83c410 }
            // n = 6, score = 200
            //   6800400000           | push                0x4000
            //   52                   | push                edx
            //   50                   | push                eax
            //   e8????????           |                     
            //   8bf8                 | mov                 edi, eax
            //   83c410               | add                 esp, 0x10

        $sequence_8 = { ff15???????? 8bf8 ffd6 85ff 8b3d???????? }
            // n = 5, score = 200
            //   ff15????????         |                     
            //   8bf8                 | mov                 edi, eax
            //   ffd6                 | call                esi
            //   85ff                 | test                edi, edi
            //   8b3d????????         |                     

        $sequence_9 = { 6810270000 ff15???????? 33c0 59 c20c00 8b442410 c70044020000 }
            // n = 7, score = 200
            //   6810270000           | push                0x2710
            //   ff15????????         |                     
            //   33c0                 | xor                 eax, eax
            //   59                   | pop                 ecx
            //   c20c00               | ret                 0xc
            //   8b442410             | mov                 eax, dword ptr [esp + 0x10]
            //   c70044020000         | mov                 dword ptr [eax], 0x244

    condition:
        7 of them and filesize < 286720
}