rule win_sysget_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.sysget."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.sysget"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 0f84f2000000 6a08 6a18 53 53 8d45e4 }
            // n = 6, score = 400
            //   0f84f2000000         | je                  0xf8
            //   6a08                 | push                8
            //   6a18                 | push                0x18
            //   53                   | push                ebx
            //   53                   | push                ebx
            //   8d45e4               | lea                 eax, [ebp - 0x1c]

        $sequence_1 = { 8bd3 59 2bd0 8a08 880c02 }
            // n = 5, score = 400
            //   8bd3                 | mov                 edx, ebx
            //   59                   | pop                 ecx
            //   2bd0                 | sub                 edx, eax
            //   8a08                 | mov                 cl, byte ptr [eax]
            //   880c02               | mov                 byte ptr [edx + eax], cl

        $sequence_2 = { 56 8975d0 8975a4 ff15???????? 8b3d???????? }
            // n = 5, score = 400
            //   56                   | push                esi
            //   8975d0               | mov                 dword ptr [ebp - 0x30], esi
            //   8975a4               | mov                 dword ptr [ebp - 0x5c], esi
            //   ff15????????         |                     
            //   8b3d????????         |                     

        $sequence_3 = { ffd6 682b010000 8d85d5fdffff 53 50 }
            // n = 5, score = 400
            //   ffd6                 | call                esi
            //   682b010000           | push                0x12b
            //   8d85d5fdffff         | lea                 eax, [ebp - 0x22b]
            //   53                   | push                ebx
            //   50                   | push                eax

        $sequence_4 = { 83c702 6685c0 75f4 4b 53 8d85e4fbffff }
            // n = 6, score = 400
            //   83c702               | add                 edi, 2
            //   6685c0               | test                ax, ax
            //   75f4                 | jne                 0xfffffff6
            //   4b                   | dec                 ebx
            //   53                   | push                ebx
            //   8d85e4fbffff         | lea                 eax, [ebp - 0x41c]

        $sequence_5 = { 8b450c 8d95e4fbffff 83c40c 2bd0 0fb708 66890c02 }
            // n = 6, score = 400
            //   8b450c               | mov                 eax, dword ptr [ebp + 0xc]
            //   8d95e4fbffff         | lea                 edx, [ebp - 0x41c]
            //   83c40c               | add                 esp, 0xc
            //   2bd0                 | sub                 edx, eax
            //   0fb708               | movzx               ecx, word ptr [eax]
            //   66890c02             | mov                 word ptr [edx + eax], cx

        $sequence_6 = { 59 8bc8 85d2 7407 c60100 }
            // n = 5, score = 400
            //   59                   | pop                 ecx
            //   8bc8                 | mov                 ecx, eax
            //   85d2                 | test                edx, edx
            //   7407                 | je                  9
            //   c60100               | mov                 byte ptr [ecx], 0

        $sequence_7 = { a5 6a30 8985f8feffff 8d850cffffff 6a00 50 }
            // n = 6, score = 400
            //   a5                   | movsd               dword ptr es:[edi], dword ptr [esi]
            //   6a30                 | push                0x30
            //   8985f8feffff         | mov                 dword ptr [ebp - 0x108], eax
            //   8d850cffffff         | lea                 eax, [ebp - 0xf4]
            //   6a00                 | push                0
            //   50                   | push                eax

        $sequence_8 = { 395dfc 7508 6a7b 58 e9???????? }
            // n = 5, score = 400
            //   395dfc               | cmp                 dword ptr [ebp - 4], ebx
            //   7508                 | jne                 0xa
            //   6a7b                 | push                0x7b
            //   58                   | pop                 eax
            //   e9????????           |                     

        $sequence_9 = { 53 ff75f8 ff15???????? 5f 5e 33c0 }
            // n = 6, score = 400
            //   53                   | push                ebx
            //   ff75f8               | push                dword ptr [ebp - 8]
            //   ff15????????         |                     
            //   5f                   | pop                 edi
            //   5e                   | pop                 esi
            //   33c0                 | xor                 eax, eax

    condition:
        7 of them and filesize < 352256
}