rule win_taleret_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.taleret."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.taleret"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 742a 8d4c2434 e8???????? 8d4c2434 c684247016000001 }
            // n = 5, score = 100
            //   742a                 | je                  0x2c
            //   8d4c2434             | lea                 ecx, [esp + 0x34]
            //   e8????????           |                     
            //   8d4c2434             | lea                 ecx, [esp + 0x34]
            //   c684247016000001     | mov                 byte ptr [esp + 0x1670], 1

        $sequence_1 = { bf00f34084 ff15???????? 83c40c 85c0 }
            // n = 4, score = 100
            //   bf00f34084           | mov                 edi, 0x8440f300
            //   ff15????????         |                     
            //   83c40c               | add                 esp, 0xc
            //   85c0                 | test                eax, eax

        $sequence_2 = { 8d842458020000 8d4c2420 50 68???????? 51 e8???????? 83c40c }
            // n = 7, score = 100
            //   8d842458020000       | lea                 eax, [esp + 0x258]
            //   8d4c2420             | lea                 ecx, [esp + 0x20]
            //   50                   | push                eax
            //   68????????           |                     
            //   51                   | push                ecx
            //   e8????????           |                     
            //   83c40c               | add                 esp, 0xc

        $sequence_3 = { 8b442414 85c0 0f84b4000000 8b4c2410 03f0 2bc8 }
            // n = 6, score = 100
            //   8b442414             | mov                 eax, dword ptr [esp + 0x14]
            //   85c0                 | test                eax, eax
            //   0f84b4000000         | je                  0xba
            //   8b4c2410             | mov                 ecx, dword ptr [esp + 0x10]
            //   03f0                 | add                 esi, eax
            //   2bc8                 | sub                 ecx, eax

        $sequence_4 = { e8???????? 8d4c2430 c68424a80300000c e8???????? 8d4c2424 c68424a80300000b e8???????? }
            // n = 7, score = 100
            //   e8????????           |                     
            //   8d4c2430             | lea                 ecx, [esp + 0x30]
            //   c68424a80300000c     | mov                 byte ptr [esp + 0x3a8], 0xc
            //   e8????????           |                     
            //   8d4c2424             | lea                 ecx, [esp + 0x24]
            //   c68424a80300000b     | mov                 byte ptr [esp + 0x3a8], 0xb
            //   e8????????           |                     

        $sequence_5 = { 33f6 68???????? 89742444 e8???????? }
            // n = 4, score = 100
            //   33f6                 | xor                 esi, esi
            //   68????????           |                     
            //   89742444             | mov                 dword ptr [esp + 0x44], esi
            //   e8????????           |                     

        $sequence_6 = { ff15???????? eb1e 83f905 7519 8b4301 8d542420 50 }
            // n = 7, score = 100
            //   ff15????????         |                     
            //   eb1e                 | jmp                 0x20
            //   83f905               | cmp                 ecx, 5
            //   7519                 | jne                 0x1b
            //   8b4301               | mov                 eax, dword ptr [ebx + 1]
            //   8d542420             | lea                 edx, [esp + 0x20]
            //   50                   | push                eax

        $sequence_7 = { 83e003 8b74242c c1e006 0bd8 }
            // n = 4, score = 100
            //   83e003               | and                 eax, 3
            //   8b74242c             | mov                 esi, dword ptr [esp + 0x2c]
            //   c1e006               | shl                 eax, 6
            //   0bd8                 | or                  ebx, eax

        $sequence_8 = { 03f2 03c6 25ff000000 50 51 68???????? a3???????? }
            // n = 7, score = 100
            //   03f2                 | add                 esi, edx
            //   03c6                 | add                 eax, esi
            //   25ff000000           | and                 eax, 0xff
            //   50                   | push                eax
            //   51                   | push                ecx
            //   68????????           |                     
            //   a3????????           |                     

        $sequence_9 = { 8b6c2418 8b4c242c 3bcd 0f8df5000000 2be9 }
            // n = 5, score = 100
            //   8b6c2418             | mov                 ebp, dword ptr [esp + 0x18]
            //   8b4c242c             | mov                 ecx, dword ptr [esp + 0x2c]
            //   3bcd                 | cmp                 ecx, ebp
            //   0f8df5000000         | jge                 0xfb
            //   2be9                 | sub                 ebp, ecx

    condition:
        7 of them and filesize < 73728
}