rule win_tandfuy_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.tandfuy."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.tandfuy"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { c3 b910000000 33c0 8d7c240c 8a54244d f3ab bf???????? }
            // n = 7, score = 100
            //   c3                   | ret                 
            //   b910000000           | mov                 ecx, 0x10
            //   33c0                 | xor                 eax, eax
            //   8d7c240c             | lea                 edi, [esp + 0xc]
            //   8a54244d             | mov                 dl, byte ptr [esp + 0x4d]
            //   f3ab                 | rep stosd           dword ptr es:[edi], eax
            //   bf????????           |                     

        $sequence_1 = { 8d44240c 50 c644241032 88542440 e8???????? 84c0 88442408 }
            // n = 7, score = 100
            //   8d44240c             | lea                 eax, [esp + 0xc]
            //   50                   | push                eax
            //   c644241032           | mov                 byte ptr [esp + 0x10], 0x32
            //   88542440             | mov                 byte ptr [esp + 0x40], dl
            //   e8????????           |                     
            //   84c0                 | test                al, al
            //   88442408             | mov                 byte ptr [esp + 8], al

        $sequence_2 = { 50 e8???????? b93f000000 33c0 8dbdecfdffff f3ab 66ab }
            // n = 7, score = 100
            //   50                   | push                eax
            //   e8????????           |                     
            //   b93f000000           | mov                 ecx, 0x3f
            //   33c0                 | xor                 eax, eax
            //   8dbdecfdffff         | lea                 edi, [ebp - 0x214]
            //   f3ab                 | rep stosd           dword ptr es:[edi], eax
            //   66ab                 | stosw               word ptr es:[edi], ax

        $sequence_3 = { 83c408 85c0 7418 8b5c2418 3bf3 7412 57 }
            // n = 7, score = 100
            //   83c408               | add                 esp, 8
            //   85c0                 | test                eax, eax
            //   7418                 | je                  0x1a
            //   8b5c2418             | mov                 ebx, dword ptr [esp + 0x18]
            //   3bf3                 | cmp                 esi, ebx
            //   7412                 | je                  0x14
            //   57                   | push                edi

        $sequence_4 = { 33c0 59 c3 8b44240c 50 ff15???????? b801000000 }
            // n = 7, score = 100
            //   33c0                 | xor                 eax, eax
            //   59                   | pop                 ecx
            //   c3                   | ret                 
            //   8b44240c             | mov                 eax, dword ptr [esp + 0xc]
            //   50                   | push                eax
            //   ff15????????         |                     
            //   b801000000           | mov                 eax, 1

        $sequence_5 = { 8dbc24c4020000 8d9424c4020000 f3ab 8d7c242c 83c9ff f2ae }
            // n = 6, score = 100
            //   8dbc24c4020000       | lea                 edi, [esp + 0x2c4]
            //   8d9424c4020000       | lea                 edx, [esp + 0x2c4]
            //   f3ab                 | rep stosd           dword ptr es:[edi], eax
            //   8d7c242c             | lea                 edi, [esp + 0x2c]
            //   83c9ff               | or                  ecx, 0xffffffff
            //   f2ae                 | repne scasb         al, byte ptr es:[edi]

        $sequence_6 = { 8d4c2408 89442400 51 8b4c2418 }
            // n = 4, score = 100
            //   8d4c2408             | lea                 ecx, [esp + 8]
            //   89442400             | mov                 dword ptr [esp], eax
            //   51                   | push                ecx
            //   8b4c2418             | mov                 ecx, dword ptr [esp + 0x18]

        $sequence_7 = { 83c408 85c0 7418 8b5c2418 3bf3 7412 }
            // n = 6, score = 100
            //   83c408               | add                 esp, 8
            //   85c0                 | test                eax, eax
            //   7418                 | je                  0x1a
            //   8b5c2418             | mov                 ebx, dword ptr [esp + 0x18]
            //   3bf3                 | cmp                 esi, ebx
            //   7412                 | je                  0x14

        $sequence_8 = { e8???????? ffb69cd76e00 8d8560ffffff 50 e8???????? 6810200100 8d8560ffffff }
            // n = 7, score = 100
            //   e8????????           |                     
            //   ffb69cd76e00         | push                dword ptr [esi + 0x6ed79c]
            //   8d8560ffffff         | lea                 eax, [ebp - 0xa0]
            //   50                   | push                eax
            //   e8????????           |                     
            //   6810200100           | push                0x12010
            //   8d8560ffffff         | lea                 eax, [ebp - 0xa0]

        $sequence_9 = { 85c0 0f84ea000000 8d4c2424 51 68???????? 53 ff15???????? }
            // n = 7, score = 100
            //   85c0                 | test                eax, eax
            //   0f84ea000000         | je                  0xf0
            //   8d4c2424             | lea                 ecx, [esp + 0x24]
            //   51                   | push                ecx
            //   68????????           |                     
            //   53                   | push                ebx
            //   ff15????????         |                     

    condition:
        7 of them and filesize < 155648
}