rule win_tellyouthepass_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.tellyouthepass."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.tellyouthepass"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 4d21da 4d01d1 eb7c 4584c0 7409 833d????????00 7417 }
            // n = 7, score = 100
            //   4d21da               | dec                 eax
            //   4d01d1               | mov                 dword ptr [esp + 0xa8], ebx
            //   eb7c                 | dec                 ecx
            //   4584c0               | mov                 ebp, 0
            //   7409                 | dec                 esp
            //   833d????????00       |                     
            //   7417                 | mov                 dword ptr [esp + 0x88], ebp

        $sequence_1 = { e8???????? e8???????? 4889c3 488d05c54b0d00 0f1f440000 e8???????? 488d05b44b0d00 }
            // n = 7, score = 100
            //   e8????????           |                     
            //   e8????????           |                     
            //   4889c3               | lea                 eax, [0xf86ea]
            //   488d05c54b0d00       | dec                 eax
            //   0f1f440000           | mov                 dword ptr [eax + 8], 0x1f
            //   e8????????           |                     
            //   488d05b44b0d00       | dec                 eax

        $sequence_2 = { e9???????? 4c8b542448 80fae2 0f85ae000000 4d8d5701 4d39d4 0f8650040000 }
            // n = 7, score = 100
            //   e9????????           |                     
            //   4c8b542448           | nop                 dword ptr [eax]
            //   80fae2               | test                byte ptr [eax], al
            //   0f85ae000000         | dec                 eax
            //   4d8d5701             | lea                 ecx, [0x6714d]
            //   4d39d4               | dec                 eax
            //   0f8650040000         | mov                 dword ptr [eax + 0x20], ecx

        $sequence_3 = { 48895c2410 488d0dcfcf0800 4839c8 7405 bb00000000 7578 488b0b }
            // n = 7, score = 100
            //   48895c2410           | mov                 ebx, edi
            //   488d0dcfcf0800       | jae                 0x1101
            //   4839c8               | mov                 dword ptr [esp + 0x44], eax
            //   7405                 | dec                 eax
            //   bb00000000           | lea                 eax, [0x49816]
            //   7578                 | dec                 eax
            //   488b0b               | mov                 edi, ecx

        $sequence_4 = { 488d8c24d0010000 e8???????? b801000000 488bac24c8030000 4881c4d0030000 c3 4c8b9424d8030000 }
            // n = 7, score = 100
            //   488d8c24d0010000     | add                 esp, 0x18
            //   e8????????           |                     
            //   b801000000           | jmp                 0x1460
            //   488bac24c8030000     | dec                 eax
            //   4881c4d0030000       | lea                 edi, [0x2ccb7a]
            //   c3                   | nop                 
            //   4c8b9424d8030000     | dec                 eax

        $sequence_5 = { 8402 4881c2c0160000 4889d0 6690 e8???????? 488b4c2420 488d4101 }
            // n = 7, score = 100
            //   8402                 | mov                 ebx, dword ptr [esp + 0x40]
            //   4881c2c0160000       | xor                 ecx, ecx
            //   4889d0               | xor                 edi, edi
            //   6690                 | dec                 eax
            //   e8????????           |                     
            //   488b4c2420           | mov                 ebp, dword ptr [esp + 0x78]
            //   488d4101             | dec                 eax

        $sequence_6 = { 7425 488905???????? 833d????????00 7509 48891d???????? eb0c 488d3daeb21b00 }
            // n = 7, score = 100
            //   7425                 | mov                 ebx, edi
            //   488905????????       |                     
            //   833d????????00       |                     
            //   7509                 | dec                 eax
            //   48891d????????       |                     
            //   eb0c                 | mov                 edi, ecx
            //   488d3daeb21b00       | dec                 eax

        $sequence_7 = { 4d8d52d9 41803a00 0f1f00 0f84b2000000 90 4a8b4cc2f0 4a8b5cc2f8 }
            // n = 7, score = 100
            //   4d8d52d9             | lea                 esi, [ebx + 1]
            //   41803a00             | dec                 eax
            //   0f1f00               | mov                 edx, dword ptr [esp + 0xa8]
            //   0f84b2000000         | dec                 eax
            //   90                   | mov                 ebx, dword ptr [esp + 0x148]
            //   4a8b4cc2f0           | dec                 eax
            //   4a8b5cc2f8           | mov                 ebx, eax

        $sequence_8 = { 7d34 884c2445 bb01000000 e8???????? 660f1f440000 84c0 0f842d150000 }
            // n = 7, score = 100
            //   7d34                 | ret                 
            //   884c2445             | dec                 eax
            //   bb01000000           | lea                 eax, [0x895db]
            //   e8????????           |                     
            //   660f1f440000         | dec                 eax
            //   84c0                 | mov                 ebx, dword ptr [esp + 0x18]
            //   0f842d150000         | dec                 eax

        $sequence_9 = { bb17000000 e8???????? 488b442428 e8???????? 488d05ee551900 bb0a000000 e8???????? }
            // n = 7, score = 100
            //   bb17000000           | dec                 eax
            //   e8????????           |                     
            //   488b442428           | mov                 ebx, dword ptr [esp + 0x150]
            //   e8????????           |                     
            //   488d05ee551900       | dec                 ecx
            //   bb0a000000           | mov                 eax, eax
            //   e8????????           |                     

    condition:
        7 of them and filesize < 7152640
}