rule win_terminator_rat_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.terminator_rat."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.terminator_rat"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 53 8d8700fcffff 56 50 }
            // n = 4, score = 500
            //   53                   | push                ebx
            //   8d8700fcffff         | lea                 eax, [edi - 0x400]
            //   56                   | push                esi
            //   50                   | push                eax

        $sequence_1 = { 8913 83c304 49 75f3 }
            // n = 4, score = 500
            //   8913                 | mov                 dword ptr [ebx], edx
            //   83c304               | add                 ebx, 4
            //   49                   | dec                 ecx
            //   75f3                 | jne                 0xfffffff5

        $sequence_2 = { c0c803 3441 c0c803 aa e2e3 }
            // n = 5, score = 500
            //   c0c803               | ror                 al, 3
            //   3441                 | xor                 al, 0x41
            //   c0c803               | ror                 al, 3
            //   aa                   | stosb               byte ptr es:[edi], al
            //   e2e3                 | loop                0xffffffe5

        $sequence_3 = { 50 e8???????? 8b852d010000 8b4804 }
            // n = 4, score = 500
            //   50                   | push                eax
            //   e8????????           |                     
            //   8b852d010000         | mov                 eax, dword ptr [ebp + 0x12d]
            //   8b4804               | mov                 ecx, dword ptr [eax + 4]

        $sequence_4 = { ffb7f0fbffff 50 e8???????? 8b4604 8987fcfbffff 8d87f8fbffff 50 }
            // n = 7, score = 500
            //   ffb7f0fbffff         | push                dword ptr [edi - 0x410]
            //   50                   | push                eax
            //   e8????????           |                     
            //   8b4604               | mov                 eax, dword ptr [esi + 4]
            //   8987fcfbffff         | mov                 dword ptr [edi - 0x404], eax
            //   8d87f8fbffff         | lea                 eax, [edi - 0x408]
            //   50                   | push                eax

        $sequence_5 = { 58 7506 898529010000 81c400040000 5f c3 }
            // n = 6, score = 500
            //   58                   | pop                 eax
            //   7506                 | jne                 8
            //   898529010000         | mov                 dword ptr [ebp + 0x129], eax
            //   81c400040000         | add                 esp, 0x400
            //   5f                   | pop                 edi
            //   c3                   | ret                 

        $sequence_6 = { 56 ff5565 85c0 7403 894569 61 }
            // n = 6, score = 500
            //   56                   | push                esi
            //   ff5565               | call                dword ptr [ebp + 0x65]
            //   85c0                 | test                eax, eax
            //   7403                 | je                  5
            //   894569               | mov                 dword ptr [ebp + 0x69], eax
            //   61                   | popal               

        $sequence_7 = { c7001a010000 e8???????? 83f8ff 7405 6a01 }
            // n = 5, score = 500
            //   c7001a010000         | mov                 dword ptr [eax], 0x11a
            //   e8????????           |                     
            //   83f8ff               | cmp                 eax, -1
            //   7405                 | je                  7
            //   6a01                 | push                1

        $sequence_8 = { 5d 55 57 8bc7 83c004 837d0400 7413 }
            // n = 7, score = 500
            //   5d                   | pop                 ebp
            //   55                   | push                ebp
            //   57                   | push                edi
            //   8bc7                 | mov                 eax, edi
            //   83c004               | add                 eax, 4
            //   837d0400             | cmp                 dword ptr [ebp + 4], 0
            //   7413                 | je                  0x15

        $sequence_9 = { 8bfc 83ec0c 53 56 8b7708 ff77fc ffb51d010000 }
            // n = 7, score = 500
            //   8bfc                 | mov                 edi, esp
            //   83ec0c               | sub                 esp, 0xc
            //   53                   | push                ebx
            //   56                   | push                esi
            //   8b7708               | mov                 esi, dword ptr [edi + 8]
            //   ff77fc               | push                dword ptr [edi - 4]
            //   ffb51d010000         | push                dword ptr [ebp + 0x11d]

    condition:
        7 of them and filesize < 73728
}