rule win_tinymet_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.tinymet."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.tinymet"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { e9???????? 6a01 eb1b 6a01 }
            // n = 4, score = 100
            //   e9????????           |                     
            //   6a01                 | push                1
            //   eb1b                 | jmp                 0x1d
            //   6a01                 | push                1

        $sequence_1 = { e8???????? 59 3bf0 72ee 5f 5e }
            // n = 6, score = 100
            //   e8????????           |                     
            //   59                   | pop                 ecx
            //   3bf0                 | cmp                 esi, eax
            //   72ee                 | jb                  0xfffffff0
            //   5f                   | pop                 edi
            //   5e                   | pop                 esi

        $sequence_2 = { 56 668907 e8???????? 83c702 a3???????? 6a5f }
            // n = 6, score = 100
            //   56                   | push                esi
            //   668907               | mov                 word ptr [edi], ax
            //   e8????????           |                     
            //   83c702               | add                 edi, 2
            //   a3????????           |                     
            //   6a5f                 | push                0x5f

        $sequence_3 = { a3???????? 5e c3 68???????? e8???????? 59 }
            // n = 6, score = 100
            //   a3????????           |                     
            //   5e                   | pop                 esi
            //   c3                   | ret                 
            //   68????????           |                     
            //   e8????????           |                     
            //   59                   | pop                 ecx

        $sequence_4 = { 50 e8???????? 83c40c 83f85c 75e4 }
            // n = 5, score = 100
            //   50                   | push                eax
            //   e8????????           |                     
            //   83c40c               | add                 esp, 0xc
            //   83f85c               | cmp                 eax, 0x5c
            //   75e4                 | jne                 0xffffffe6

        $sequence_5 = { e9???????? 8b400c ff750c 8b00 8b00 }
            // n = 5, score = 100
            //   e9????????           |                     
            //   8b400c               | mov                 eax, dword ptr [eax + 0xc]
            //   ff750c               | push                dword ptr [ebp + 0xc]
            //   8b00                 | mov                 eax, dword ptr [eax]
            //   8b00                 | mov                 eax, dword ptr [eax]

        $sequence_6 = { 83feff 751b 68???????? e9???????? ff15???????? 85c0 }
            // n = 6, score = 100
            //   83feff               | cmp                 esi, -1
            //   751b                 | jne                 0x1d
            //   68????????           |                     
            //   e9????????           |                     
            //   ff15????????         |                     
            //   85c0                 | test                eax, eax

        $sequence_7 = { 85f6 7509 a1???????? 8b30 eb03 83c602 }
            // n = 6, score = 100
            //   85f6                 | test                esi, esi
            //   7509                 | jne                 0xb
            //   a1????????           |                     
            //   8b30                 | mov                 esi, dword ptr [eax]
            //   eb03                 | jmp                 5
            //   83c602               | add                 esi, 2

    condition:
        7 of them and filesize < 57344
}