rule win_tinynuke_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.tinynuke."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.tinynuke"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { c3 55 8bec 817d0c00040000 }
            // n = 4, score = 1600
            //   c3                   | ret                 
            //   55                   | push                ebp
            //   8bec                 | mov                 ebp, esp
            //   817d0c00040000       | cmp                 dword ptr [ebp + 0xc], 0x400

        $sequence_1 = { 59 85db 7416 57 53 6aff }
            // n = 6, score = 1400
            //   59                   | pop                 ecx
            //   85db                 | test                ebx, ebx
            //   7416                 | je                  0x18
            //   57                   | push                edi
            //   53                   | push                ebx
            //   6aff                 | push                -1

        $sequence_2 = { 3b750c 72e5 5f 5b 5e 5d c3 }
            // n = 7, score = 1400
            //   3b750c               | cmp                 esi, dword ptr [ebp + 0xc]
            //   72e5                 | jb                  0xffffffe7
            //   5f                   | pop                 edi
            //   5b                   | pop                 ebx
            //   5e                   | pop                 esi
            //   5d                   | pop                 ebp
            //   c3                   | ret                 

        $sequence_3 = { ff35???????? a3???????? ff75f4 ff15???????? ff35???????? a3???????? ff75f4 }
            // n = 7, score = 1400
            //   ff35????????         |                     
            //   a3????????           |                     
            //   ff75f4               | push                dword ptr [ebp - 0xc]
            //   ff15????????         |                     
            //   ff35????????         |                     
            //   a3????????           |                     
            //   ff75f4               | push                dword ptr [ebp - 0xc]

        $sequence_4 = { 8d45f8 50 56 57 ff35???????? ff75fc }
            // n = 6, score = 1400
            //   8d45f8               | lea                 eax, [ebp - 8]
            //   50                   | push                eax
            //   56                   | push                esi
            //   57                   | push                edi
            //   ff35????????         |                     
            //   ff75fc               | push                dword ptr [ebp - 4]

        $sequence_5 = { 8d8530f6ffff 50 6802020000 ff15???????? 85c0 }
            // n = 5, score = 1400
            //   8d8530f6ffff         | lea                 eax, [ebp - 0x9d0]
            //   50                   | push                eax
            //   6802020000           | push                0x202
            //   ff15????????         |                     
            //   85c0                 | test                eax, eax

        $sequence_6 = { 83c418 a3???????? 5f 5e 5b c9 c3 }
            // n = 7, score = 1400
            //   83c418               | add                 esp, 0x18
            //   a3????????           |                     
            //   5f                   | pop                 edi
            //   5e                   | pop                 esi
            //   5b                   | pop                 ebx
            //   c9                   | leave               
            //   c3                   | ret                 

        $sequence_7 = { 8945f4 8d85d4feffff 50 ff15???????? }
            // n = 4, score = 1400
            //   8945f4               | mov                 dword ptr [ebp - 0xc], eax
            //   8d85d4feffff         | lea                 eax, [ebp - 0x12c]
            //   50                   | push                eax
            //   ff15????????         |                     

        $sequence_8 = { ff75ec ff75fc e8???????? 83c40c 5f }
            // n = 5, score = 1300
            //   ff75ec               | push                dword ptr [ebp - 0x14]
            //   ff75fc               | push                dword ptr [ebp - 4]
            //   e8????????           |                     
            //   83c40c               | add                 esp, 0xc
            //   5f                   | pop                 edi

        $sequence_9 = { ff35???????? 8d85a4feffff 50 ff15???????? ff35???????? 8d85a4feffff 50 }
            // n = 7, score = 1300
            //   ff35????????         |                     
            //   8d85a4feffff         | lea                 eax, [ebp - 0x15c]
            //   50                   | push                eax
            //   ff15????????         |                     
            //   ff35????????         |                     
            //   8d85a4feffff         | lea                 eax, [ebp - 0x15c]
            //   50                   | push                eax

        $sequence_10 = { ff15???????? ff35???????? 8d85a8feffff 50 }
            // n = 4, score = 900
            //   ff15????????         |                     
            //   ff35????????         |                     
            //   8d85a8feffff         | lea                 eax, [ebp - 0x158]
            //   50                   | push                eax

        $sequence_11 = { c70604000000 e8???????? eb18 83f803 }
            // n = 4, score = 800
            //   c70604000000         | mov                 dword ptr [esi], 4
            //   e8????????           |                     
            //   eb18                 | jmp                 0x1a
            //   83f803               | cmp                 eax, 3

        $sequence_12 = { ff15???????? a3???????? ff35???????? ff75f8 ff15???????? }
            // n = 5, score = 800
            //   ff15????????         |                     
            //   a3????????           |                     
            //   ff35????????         |                     
            //   ff75f8               | push                dword ptr [ebp - 8]
            //   ff15????????         |                     

        $sequence_13 = { a3???????? 68e2010000 68???????? 68???????? }
            // n = 4, score = 800
            //   a3????????           |                     
            //   68e2010000           | push                0x1e2
            //   68????????           |                     
            //   68????????           |                     

        $sequence_14 = { eb18 83f803 7519 ff7608 }
            // n = 4, score = 800
            //   eb18                 | jmp                 0x1a
            //   83f803               | cmp                 eax, 3
            //   7519                 | jne                 0x1b
            //   ff7608               | push                dword ptr [esi + 8]

        $sequence_15 = { 3c0a 7409 3c0d 740f }
            // n = 4, score = 800
            //   3c0a                 | cmp                 al, 0xa
            //   7409                 | je                  0xb
            //   3c0d                 | cmp                 al, 0xd
            //   740f                 | je                  0x11

        $sequence_16 = { 8b02 8a00 3c0a 7409 }
            // n = 4, score = 800
            //   8b02                 | mov                 eax, dword ptr [edx]
            //   8a00                 | mov                 al, byte ptr [eax]
            //   3c0a                 | cmp                 al, 0xa
            //   7409                 | je                  0xb

        $sequence_17 = { 6a2a 50 8945fc ff15???????? }
            // n = 4, score = 800
            //   6a2a                 | push                0x2a
            //   50                   | push                eax
            //   8945fc               | mov                 dword ptr [ebp - 4], eax
            //   ff15????????         |                     

        $sequence_18 = { a3???????? ff35???????? ff75ec ff15???????? }
            // n = 4, score = 800
            //   a3????????           |                     
            //   ff35????????         |                     
            //   ff75ec               | push                dword ptr [ebp - 0x14]
            //   ff15????????         |                     

        $sequence_19 = { 50 8d85d8feffff 50 ff15???????? ff35???????? }
            // n = 5, score = 700
            //   50                   | push                eax
            //   8d85d8feffff         | lea                 eax, [ebp - 0x128]
            //   50                   | push                eax
            //   ff15????????         |                     
            //   ff35????????         |                     

        $sequence_20 = { 8d85f0fdffff 50 ff15???????? ff75fc 8d85f0fdffff 50 e8???????? }
            // n = 7, score = 700
            //   8d85f0fdffff         | lea                 eax, [ebp - 0x210]
            //   50                   | push                eax
            //   ff15????????         |                     
            //   ff75fc               | push                dword ptr [ebp - 4]
            //   8d85f0fdffff         | lea                 eax, [ebp - 0x210]
            //   50                   | push                eax
            //   e8????????           |                     

        $sequence_21 = { 8d85f0fdffff 50 e8???????? 59 50 68???????? }
            // n = 6, score = 700
            //   8d85f0fdffff         | lea                 eax, [ebp - 0x210]
            //   50                   | push                eax
            //   e8????????           |                     
            //   59                   | pop                 ecx
            //   50                   | push                eax
            //   68????????           |                     

        $sequence_22 = { ff15???????? 8b35???????? 8d430c 50 }
            // n = 4, score = 200
            //   ff15????????         |                     
            //   8b35????????         |                     
            //   8d430c               | lea                 eax, [ebx + 0xc]
            //   50                   | push                eax

        $sequence_23 = { 8b1d???????? 83fbff 7424 85db 740f ff149dc01de06e 83eb01 }
            // n = 7, score = 100
            //   8b1d????????         |                     
            //   83fbff               | cmp                 ebx, -1
            //   7424                 | je                  0x26
            //   85db                 | test                ebx, ebx
            //   740f                 | je                  0x11
            //   ff149dc01de06e       | call                dword ptr [ebx*4 + 0x6ee01dc0]
            //   83eb01               | sub                 ebx, 1

        $sequence_24 = { eb10 8d04cd00000000 2bc1 8d0c45386d0210 }
            // n = 4, score = 100
            //   eb10                 | jmp                 0x12
            //   8d04cd00000000       | lea                 eax, [ecx*8]
            //   2bc1                 | sub                 eax, ecx
            //   8d0c45386d0210       | lea                 ecx, [eax*2 + 0x10026d38]

        $sequence_25 = { 85c0 75b7 8b7c241c 8b8780000000 }
            // n = 4, score = 100
            //   85c0                 | test                eax, eax
            //   75b7                 | jne                 0xffffffb9
            //   8b7c241c             | mov                 edi, dword ptr [esp + 0x1c]
            //   8b8780000000         | mov                 eax, dword ptr [edi + 0x80]

        $sequence_26 = { 89442404 e8???????? 83ec10 8b44241c }
            // n = 4, score = 100
            //   89442404             | mov                 dword ptr [esp + 4], eax
            //   e8????????           |                     
            //   83ec10               | sub                 esp, 0x10
            //   8b44241c             | mov                 eax, dword ptr [esp + 0x1c]

        $sequence_27 = { 83ec08 85c0 75d6 31db }
            // n = 4, score = 100
            //   83ec08               | sub                 esp, 8
            //   85c0                 | test                eax, eax
            //   75d6                 | jne                 0xffffffd8
            //   31db                 | xor                 ebx, ebx

        $sequence_28 = { 01d8 89442418 8b400c 85c0 745c 01d8 890424 }
            // n = 7, score = 100
            //   01d8                 | add                 eax, ebx
            //   89442418             | mov                 dword ptr [esp + 0x18], eax
            //   8b400c               | mov                 eax, dword ptr [eax + 0xc]
            //   85c0                 | test                eax, eax
            //   745c                 | je                  0x5e
            //   01d8                 | add                 eax, ebx
            //   890424               | mov                 dword ptr [esp], eax

        $sequence_29 = { 81c2???????? 89542404 890c24 e8???????? }
            // n = 4, score = 100
            //   81c2????????         |                     
            //   89542404             | mov                 dword ptr [esp + 4], edx
            //   890c24               | mov                 dword ptr [esp], ecx
            //   e8????????           |                     

        $sequence_30 = { ff149dc01de06e 83eb01 8d7600 75f1 c70424???????? }
            // n = 5, score = 100
            //   ff149dc01de06e       | call                dword ptr [ebx*4 + 0x6ee01dc0]
            //   83eb01               | sub                 ebx, 1
            //   8d7600               | lea                 esi, [esi]
            //   75f1                 | jne                 0xfffffff3
            //   c70424????????       |                     

        $sequence_31 = { e8???????? 83ec04 3c0c 7421 ffd3 }
            // n = 5, score = 100
            //   e8????????           |                     
            //   83ec04               | sub                 esp, 4
            //   3c0c                 | cmp                 al, 0xc
            //   7421                 | je                  0x23
            //   ffd3                 | call                ebx

    condition:
        7 of them and filesize < 1196032
}