rule win_tiop_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.tiop."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.tiop"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 3be9 72e9 8b9e4c050000 83c9ff 8bfb 33c0 }
            // n = 6, score = 100
            //   3be9                 | cmp                 ebp, ecx
            //   72e9                 | jb                  0xffffffeb
            //   8b9e4c050000         | mov                 ebx, dword ptr [esi + 0x54c]
            //   83c9ff               | or                  ecx, 0xffffffff
            //   8bfb                 | mov                 edi, ebx
            //   33c0                 | xor                 eax, eax

        $sequence_1 = { 8b4608 50 ff15???????? 8b4e10 6a0d 51 }
            // n = 6, score = 100
            //   8b4608               | mov                 eax, dword ptr [esi + 8]
            //   50                   | push                eax
            //   ff15????????         |                     
            //   8b4e10               | mov                 ecx, dword ptr [esi + 0x10]
            //   6a0d                 | push                0xd
            //   51                   | push                ecx

        $sequence_2 = { 5d 81c484000000 c20800 892e 5f 5e 33c0 }
            // n = 7, score = 100
            //   5d                   | pop                 ebp
            //   81c484000000         | add                 esp, 0x84
            //   c20800               | ret                 8
            //   892e                 | mov                 dword ptr [esi], ebp
            //   5f                   | pop                 edi
            //   5e                   | pop                 esi
            //   33c0                 | xor                 eax, eax

        $sequence_3 = { 8b15???????? 68f0000000 8d4c2460 89442464 6a04 8d44242a 51 }
            // n = 7, score = 100
            //   8b15????????         |                     
            //   68f0000000           | push                0xf0
            //   8d4c2460             | lea                 ecx, [esp + 0x60]
            //   89442464             | mov                 dword ptr [esp + 0x64], eax
            //   6a04                 | push                4
            //   8d44242a             | lea                 eax, [esp + 0x2a]
            //   51                   | push                ecx

        $sequence_4 = { b90c000000 33c0 bf???????? f3ab 66ab 8bfa 83c9ff }
            // n = 7, score = 100
            //   b90c000000           | mov                 ecx, 0xc
            //   33c0                 | xor                 eax, eax
            //   bf????????           |                     
            //   f3ab                 | rep stosd           dword ptr es:[edi], eax
            //   66ab                 | stosw               word ptr es:[edi], ax
            //   8bfa                 | mov                 edi, edx
            //   83c9ff               | or                  ecx, 0xffffffff

        $sequence_5 = { 51 ff15???????? b908020000 33c0 8dbc2499090000 c684249809000000 }
            // n = 6, score = 100
            //   51                   | push                ecx
            //   ff15????????         |                     
            //   b908020000           | mov                 ecx, 0x208
            //   33c0                 | xor                 eax, eax
            //   8dbc2499090000       | lea                 edi, [esp + 0x999]
            //   c684249809000000     | mov                 byte ptr [esp + 0x998], 0

        $sequence_6 = { 56 ff15???????? 6a05 56 ff15???????? 68???????? 68e8030000 }
            // n = 7, score = 100
            //   56                   | push                esi
            //   ff15????????         |                     
            //   6a05                 | push                5
            //   56                   | push                esi
            //   ff15????????         |                     
            //   68????????           |                     
            //   68e8030000           | push                0x3e8

        $sequence_7 = { 8b942448080000 55 51 8d442428 52 50 899c244c080000 }
            // n = 7, score = 100
            //   8b942448080000       | mov                 edx, dword ptr [esp + 0x848]
            //   55                   | push                ebp
            //   51                   | push                ecx
            //   8d442428             | lea                 eax, [esp + 0x28]
            //   52                   | push                edx
            //   50                   | push                eax
            //   899c244c080000       | mov                 dword ptr [esp + 0x84c], ebx

        $sequence_8 = { 8b10 6a00 8bc8 c744241000000000 ff12 8d4c2414 c744240cffffffff }
            // n = 7, score = 100
            //   8b10                 | mov                 edx, dword ptr [eax]
            //   6a00                 | push                0
            //   8bc8                 | mov                 ecx, eax
            //   c744241000000000     | mov                 dword ptr [esp + 0x10], 0
            //   ff12                 | call                dword ptr [edx]
            //   8d4c2414             | lea                 ecx, [esp + 0x14]
            //   c744240cffffffff     | mov                 dword ptr [esp + 0xc], 0xffffffff

        $sequence_9 = { 85c0 7502 5e c3 b9???????? e8???????? }
            // n = 6, score = 100
            //   85c0                 | test                eax, eax
            //   7502                 | jne                 4
            //   5e                   | pop                 esi
            //   c3                   | ret                 
            //   b9????????           |                     
            //   e8????????           |                     

    condition:
        7 of them and filesize < 712704
}