rule win_tokyox_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.tokyox."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.tokyox"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { ff700c 8b08 ff7008 e8???????? 8945e4 3de22e0000 }
            // n = 6, score = 200
            //   ff700c               | push                dword ptr [eax + 0xc]
            //   8b08                 | mov                 ecx, dword ptr [eax]
            //   ff7008               | push                dword ptr [eax + 8]
            //   e8????????           |                     
            //   8945e4               | mov                 dword ptr [ebp - 0x1c], eax
            //   3de22e0000           | cmp                 eax, 0x2ee2

        $sequence_1 = { 50 ff7508 c745fc616d6500 ff15???????? }
            // n = 4, score = 200
            //   50                   | push                eax
            //   ff7508               | push                dword ptr [ebp + 8]
            //   c745fc616d6500       | mov                 dword ptr [ebp - 4], 0x656d61
            //   ff15????????         |                     

        $sequence_2 = { 8bce 83c40c 33c0 668907 8d5101 }
            // n = 5, score = 200
            //   8bce                 | mov                 ecx, esi
            //   83c40c               | add                 esp, 0xc
            //   33c0                 | xor                 eax, eax
            //   668907               | mov                 word ptr [edi], ax
            //   8d5101               | lea                 edx, [ecx + 1]

        $sequence_3 = { 8d45fc 8b35???????? 50 6a1f }
            // n = 4, score = 200
            //   8d45fc               | lea                 eax, [ebp - 4]
            //   8b35????????         |                     
            //   50                   | push                eax
            //   6a1f                 | push                0x1f

        $sequence_4 = { 6689047e eb18 52 8d85f0faffff c645a000 50 ff75a0 }
            // n = 7, score = 200
            //   6689047e             | mov                 word ptr [esi + edi*2], ax
            //   eb18                 | jmp                 0x1a
            //   52                   | push                edx
            //   8d85f0faffff         | lea                 eax, [ebp - 0x510]
            //   c645a000             | mov                 byte ptr [ebp - 0x60], 0
            //   50                   | push                eax
            //   ff75a0               | push                dword ptr [ebp - 0x60]

        $sequence_5 = { 6a00 68e9fd0000 ff15???????? 8b450c 8930 33f6 eb11 }
            // n = 7, score = 200
            //   6a00                 | push                0
            //   68e9fd0000           | push                0xfde9
            //   ff15????????         |                     
            //   8b450c               | mov                 eax, dword ptr [ebp + 0xc]
            //   8930                 | mov                 dword ptr [eax], esi
            //   33f6                 | xor                 esi, esi
            //   eb11                 | jmp                 0x13

        $sequence_6 = { 3de22e0000 74d8 6a01 ff7508 }
            // n = 4, score = 200
            //   3de22e0000           | cmp                 eax, 0x2ee2
            //   74d8                 | je                  0xffffffda
            //   6a01                 | push                1
            //   ff7508               | push                dword ptr [ebp + 8]

        $sequence_7 = { 8d85ecefffff 6a00 50 e8???????? 83c40c c7451000000000 }
            // n = 6, score = 200
            //   8d85ecefffff         | lea                 eax, [ebp - 0x1014]
            //   6a00                 | push                0
            //   50                   | push                eax
            //   e8????????           |                     
            //   83c40c               | add                 esp, 0xc
            //   c7451000000000       | mov                 dword ptr [ebp + 0x10], 0

        $sequence_8 = { 8d8df0fcffff 8d45c8 0f4345c8 51 50 ff15???????? 8bf8 }
            // n = 7, score = 200
            //   8d8df0fcffff         | lea                 ecx, [ebp - 0x310]
            //   8d45c8               | lea                 eax, [ebp - 0x38]
            //   0f4345c8             | cmovae              eax, dword ptr [ebp - 0x38]
            //   51                   | push                ecx
            //   50                   | push                eax
            //   ff15????????         |                     
            //   8bf8                 | mov                 edi, eax

        $sequence_9 = { 56 6a00 6a01 ff15???????? 8bcb 8d5102 90 }
            // n = 7, score = 200
            //   56                   | push                esi
            //   6a00                 | push                0
            //   6a01                 | push                1
            //   ff15????????         |                     
            //   8bcb                 | mov                 ecx, ebx
            //   8d5102               | lea                 edx, [ecx + 2]
            //   90                   | nop                 

    condition:
        7 of them and filesize < 237568
}