rule win_torrentlocker_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.torrentlocker."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.torrentlocker"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { c3 83f801 7405 83f802 }
            // n = 4, score = 500
            //   c3                   | ret                 
            //   83f801               | cmp                 eax, 1
            //   7405                 | je                  7
            //   83f802               | cmp                 eax, 2

        $sequence_1 = { 85c0 753c 68???????? b8???????? bb???????? e8???????? }
            // n = 6, score = 400
            //   85c0                 | test                eax, eax
            //   753c                 | jne                 0x3e
            //   68????????           |                     
            //   b8????????           |                     
            //   bb????????           |                     
            //   e8????????           |                     

        $sequence_2 = { 750b 68???????? ff15???????? 8bc3 }
            // n = 4, score = 400
            //   750b                 | jne                 0xd
            //   68????????           |                     
            //   ff15????????         |                     
            //   8bc3                 | mov                 eax, ebx

        $sequence_3 = { 8b0d???????? 50 6a00 51 ff15???????? 8bf0 }
            // n = 6, score = 400
            //   8b0d????????         |                     
            //   50                   | push                eax
            //   6a00                 | push                0
            //   51                   | push                ecx
            //   ff15????????         |                     
            //   8bf0                 | mov                 esi, eax

        $sequence_4 = { 6a00 68???????? ffd6 83f801 7502 5e c3 }
            // n = 7, score = 400
            //   6a00                 | push                0
            //   68????????           |                     
            //   ffd6                 | call                esi
            //   83f801               | cmp                 eax, 1
            //   7502                 | jne                 4
            //   5e                   | pop                 esi
            //   c3                   | ret                 

        $sequence_5 = { 6a02 e8???????? 83c430 85c0 }
            // n = 4, score = 400
            //   6a02                 | push                2
            //   e8????????           |                     
            //   83c430               | add                 esp, 0x30
            //   85c0                 | test                eax, eax

        $sequence_6 = { 8bc6 5e 5f c3 be02000000 }
            // n = 5, score = 400
            //   8bc6                 | mov                 eax, esi
            //   5e                   | pop                 esi
            //   5f                   | pop                 edi
            //   c3                   | ret                 
            //   be02000000           | mov                 esi, 2

        $sequence_7 = { 68???????? ffd6 85c0 751f ff15???????? 3d16000980 753d }
            // n = 7, score = 400
            //   68????????           |                     
            //   ffd6                 | call                esi
            //   85c0                 | test                eax, eax
            //   751f                 | jne                 0x21
            //   ff15????????         |                     
            //   3d16000980           | cmp                 eax, 0x80090016
            //   753d                 | jne                 0x3f

        $sequence_8 = { 7415 50 a1???????? 56 }
            // n = 4, score = 400
            //   7415                 | je                  0x17
            //   50                   | push                eax
            //   a1????????           |                     
            //   56                   | push                esi

        $sequence_9 = { 83ec0c 56 8b35???????? 57 6a14 6a08 50 }
            // n = 7, score = 400
            //   83ec0c               | sub                 esp, 0xc
            //   56                   | push                esi
            //   8b35????????         |                     
            //   57                   | push                edi
            //   6a14                 | push                0x14
            //   6a08                 | push                8
            //   50                   | push                eax

        $sequence_10 = { 741d 8b15???????? 50 6a00 52 ff15???????? 8bc7 }
            // n = 7, score = 400
            //   741d                 | je                  0x1f
            //   8b15????????         |                     
            //   50                   | push                eax
            //   6a00                 | push                0
            //   52                   | push                edx
            //   ff15????????         |                     
            //   8bc7                 | mov                 eax, edi

        $sequence_11 = { 7526 68400000f0 50 6a00 }
            // n = 4, score = 400
            //   7526                 | jne                 0x28
            //   68400000f0           | push                0xf0000040
            //   50                   | push                eax
            //   6a00                 | push                0

        $sequence_12 = { 50 ff15???????? 85c0 8d4601 7502 8bc6 5e }
            // n = 7, score = 400
            //   50                   | push                eax
            //   ff15????????         |                     
            //   85c0                 | test                eax, eax
            //   8d4601               | lea                 eax, [esi + 1]
            //   7502                 | jne                 4
            //   8bc6                 | mov                 eax, esi
            //   5e                   | pop                 esi

        $sequence_13 = { 7412 83c8ff 5f a3???????? 89460c }
            // n = 5, score = 400
            //   7412                 | je                  0x14
            //   83c8ff               | or                  eax, 0xffffffff
            //   5f                   | pop                 edi
            //   a3????????           |                     
            //   89460c               | mov                 dword ptr [esi + 0xc], eax

        $sequence_14 = { 68???????? ff15???????? 85c0 7510 6a78 50 }
            // n = 6, score = 400
            //   68????????           |                     
            //   ff15????????         |                     
            //   85c0                 | test                eax, eax
            //   7510                 | jne                 0x12
            //   6a78                 | push                0x78
            //   50                   | push                eax

        $sequence_15 = { 6a78 50 68???????? e8???????? }
            // n = 4, score = 400
            //   6a78                 | push                0x78
            //   50                   | push                eax
            //   68????????           |                     
            //   e8????????           |                     

    condition:
        7 of them and filesize < 933888
}