rule win_turnedup_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.turnedup."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.turnedup"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 7414 85c0 780a b900020000 2bca }
            // n = 5, score = 400
            //   7414                 | je                  0x16
            //   85c0                 | test                eax, eax
            //   780a                 | js                  0xc
            //   b900020000           | mov                 ecx, 0x200
            //   2bca                 | sub                 ecx, edx

        $sequence_1 = { 8b5dbc c60365 8b0e 43 895dbc 85c9 }
            // n = 6, score = 400
            //   8b5dbc               | mov                 ebx, dword ptr [ebp - 0x44]
            //   c60365               | mov                 byte ptr [ebx], 0x65
            //   8b0e                 | mov                 ecx, dword ptr [esi]
            //   43                   | inc                 ebx
            //   895dbc               | mov                 dword ptr [ebp - 0x44], ebx
            //   85c9                 | test                ecx, ecx

        $sequence_2 = { 391d???????? 757d 6a01 53 8d450c 50 }
            // n = 6, score = 400
            //   391d????????         |                     
            //   757d                 | jne                 0x7f
            //   6a01                 | push                1
            //   53                   | push                ebx
            //   8d450c               | lea                 eax, [ebp + 0xc]
            //   50                   | push                eax

        $sequence_3 = { 895dfc 752b 6a00 8d4df8 e8???????? 833d????????00 }
            // n = 6, score = 400
            //   895dfc               | mov                 dword ptr [ebp - 4], ebx
            //   752b                 | jne                 0x2d
            //   6a00                 | push                0
            //   8d4df8               | lea                 ecx, [ebp - 8]
            //   e8????????           |                     
            //   833d????????00       |                     

        $sequence_4 = { 60 33c0 3e8b7c2424 33c9 }
            // n = 4, score = 400
            //   60                   | pushal              
            //   33c0                 | xor                 eax, eax
            //   3e8b7c2424           | mov                 edi, dword ptr ds:[esp + 0x24]
            //   33c9                 | xor                 ecx, ecx

        $sequence_5 = { 7434 8b4120 833800 741b 8b5130 833a00 7e13 }
            // n = 7, score = 400
            //   7434                 | je                  0x36
            //   8b4120               | mov                 eax, dword ptr [ecx + 0x20]
            //   833800               | cmp                 dword ptr [eax], 0
            //   741b                 | je                  0x1d
            //   8b5130               | mov                 edx, dword ptr [ecx + 0x30]
            //   833a00               | cmp                 dword ptr [edx], 0
            //   7e13                 | jle                 0x15

        $sequence_6 = { 83ec1c 8bcc 6a14 c741140f000000 }
            // n = 4, score = 400
            //   83ec1c               | sub                 esp, 0x1c
            //   8bcc                 | mov                 ecx, esp
            //   6a14                 | push                0x14
            //   c741140f000000       | mov                 dword ptr [ecx + 0x14], 0xf

        $sequence_7 = { e8???????? 83c404 3bc3 7433 8b0d???????? 8904b1 }
            // n = 6, score = 400
            //   e8????????           |                     
            //   83c404               | add                 esp, 4
            //   3bc3                 | cmp                 eax, ebx
            //   7433                 | je                  0x35
            //   8b0d????????         |                     
            //   8904b1               | mov                 dword ptr [ecx + esi*4], eax

        $sequence_8 = { 6a01 8bcf ffd0 8b4da4 8b11 8b520c }
            // n = 6, score = 400
            //   6a01                 | push                1
            //   8bcf                 | mov                 ecx, edi
            //   ffd0                 | call                eax
            //   8b4da4               | mov                 ecx, dword ptr [ebp - 0x5c]
            //   8b11                 | mov                 edx, dword ptr [ecx]
            //   8b520c               | mov                 edx, dword ptr [edx + 0xc]

        $sequence_9 = { 8b5f10 85db 7438 8b4f14 83f910 }
            // n = 5, score = 400
            //   8b5f10               | mov                 ebx, dword ptr [edi + 0x10]
            //   85db                 | test                ebx, ebx
            //   7438                 | je                  0x3a
            //   8b4f14               | mov                 ecx, dword ptr [edi + 0x14]
            //   83f910               | cmp                 ecx, 0x10

    condition:
        7 of them and filesize < 892928
}