rule win_udpos_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.udpos."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.udpos"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 7410 8b0d???????? 8d95c4fbffff 52 51 ffd0 }
            // n = 6, score = 100
            //   7410                 | je                  0x12
            //   8b0d????????         |                     
            //   8d95c4fbffff         | lea                 edx, [ebp - 0x43c]
            //   52                   | push                edx
            //   51                   | push                ecx
            //   ffd0                 | call                eax

        $sequence_1 = { 6a00 6a01 6800000040 8d8d1cefffff 51 }
            // n = 5, score = 100
            //   6a00                 | push                0
            //   6a01                 | push                1
            //   6800000040           | push                0x40000000
            //   8d8d1cefffff         | lea                 ecx, [ebp - 0x10e4]
            //   51                   | push                ecx

        $sequence_2 = { 83c404 684c040000 ff15???????? 83bd9cfefffff5 0f8fbafcffff 833d????????0a 5f }
            // n = 7, score = 100
            //   83c404               | add                 esp, 4
            //   684c040000           | push                0x44c
            //   ff15????????         |                     
            //   83bd9cfefffff5       | cmp                 dword ptr [ebp - 0x164], -0xb
            //   0f8fbafcffff         | jg                  0xfffffcc0
            //   833d????????0a       |                     
            //   5f                   | pop                 edi

        $sequence_3 = { ffd6 8d955cffffff 52 8d85e0f8ffff 50 ffd6 }
            // n = 6, score = 100
            //   ffd6                 | call                esi
            //   8d955cffffff         | lea                 edx, [ebp - 0xa4]
            //   52                   | push                edx
            //   8d85e0f8ffff         | lea                 eax, [ebp - 0x720]
            //   50                   | push                eax
            //   ffd6                 | call                esi

        $sequence_4 = { 68???????? 8d85e0f8ffff 50 ffd6 8b8d10efffff 51 }
            // n = 6, score = 100
            //   68????????           |                     
            //   8d85e0f8ffff         | lea                 eax, [ebp - 0x720]
            //   50                   | push                eax
            //   ffd6                 | call                esi
            //   8b8d10efffff         | mov                 ecx, dword ptr [ebp - 0x10f0]
            //   51                   | push                ecx

        $sequence_5 = { 3bc6 7e15 85c0 7e11 }
            // n = 4, score = 100
            //   3bc6                 | cmp                 eax, esi
            //   7e15                 | jle                 0x17
            //   85c0                 | test                eax, eax
            //   7e11                 | jle                 0x13

        $sequence_6 = { ffd6 8b0d???????? 51 68???????? ffd6 }
            // n = 5, score = 100
            //   ffd6                 | call                esi
            //   8b0d????????         |                     
            //   51                   | push                ecx
            //   68????????           |                     
            //   ffd6                 | call                esi

        $sequence_7 = { ffd6 8d85bcfeffff 50 8d8de0f8ffff 51 ffd6 8d957cf8ffff }
            // n = 7, score = 100
            //   ffd6                 | call                esi
            //   8d85bcfeffff         | lea                 eax, [ebp - 0x144]
            //   50                   | push                eax
            //   8d8de0f8ffff         | lea                 ecx, [ebp - 0x720]
            //   51                   | push                ecx
            //   ffd6                 | call                esi
            //   8d957cf8ffff         | lea                 edx, [ebp - 0x784]

        $sequence_8 = { c20400 e8???????? 5d c20400 a1???????? 8b5020 33c9 }
            // n = 7, score = 100
            //   c20400               | ret                 4
            //   e8????????           |                     
            //   5d                   | pop                 ebp
            //   c20400               | ret                 4
            //   a1????????           |                     
            //   8b5020               | mov                 edx, dword ptr [eax + 0x20]
            //   33c9                 | xor                 ecx, ecx

        $sequence_9 = { 83e60f 0fb65c35e8 0fb671fd 8858fd }
            // n = 4, score = 100
            //   83e60f               | and                 esi, 0xf
            //   0fb65c35e8           | movzx               ebx, byte ptr [ebp + esi - 0x18]
            //   0fb671fd             | movzx               esi, byte ptr [ecx - 3]
            //   8858fd               | mov                 byte ptr [eax - 3], bl

    condition:
        7 of them and filesize < 163840
}