rule win_unidentified_053_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.unidentified_053."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.unidentified_053"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 0f857afeffff 393cb500924100 742e a1???????? 8d70ff 85f6 }
            // n = 6, score = 100
            //   0f857afeffff         | jne                 0xfffffe80
            //   393cb500924100       | cmp                 dword ptr [esi*4 + 0x419200], edi
            //   742e                 | je                  0x30
            //   a1????????           |                     
            //   8d70ff               | lea                 esi, [eax - 1]
            //   85f6                 | test                esi, esi

        $sequence_1 = { 0fb6bdb0fffcff c1e208 0bd7 03d0 2bca 6a00 }
            // n = 6, score = 100
            //   0fb6bdb0fffcff       | movzx               edi, byte ptr [ebp - 0x30050]
            //   c1e208               | shl                 edx, 8
            //   0bd7                 | or                  edx, edi
            //   03d0                 | add                 edx, eax
            //   2bca                 | sub                 ecx, edx
            //   6a00                 | push                0

        $sequence_2 = { 754d 53 57 8d3c85a8914100 833f00 bb00100000 7520 }
            // n = 7, score = 100
            //   754d                 | jne                 0x4f
            //   53                   | push                ebx
            //   57                   | push                edi
            //   8d3c85a8914100       | lea                 edi, [eax*4 + 0x4191a8]
            //   833f00               | cmp                 dword ptr [edi], 0
            //   bb00100000           | mov                 ebx, 0x1000
            //   7520                 | jne                 0x22

        $sequence_3 = { 7e13 8d048dfc914100 3938 7408 4a }
            // n = 5, score = 100
            //   7e13                 | jle                 0x15
            //   8d048dfc914100       | lea                 eax, [ecx*4 + 0x4191fc]
            //   3938                 | cmp                 dword ptr [eax], edi
            //   7408                 | je                  0xa
            //   4a                   | dec                 edx

        $sequence_4 = { 8a6e1b 0fb64619 0fb67df4 8a4e1a }
            // n = 4, score = 100
            //   8a6e1b               | mov                 ch, byte ptr [esi + 0x1b]
            //   0fb64619             | movzx               eax, byte ptr [esi + 0x19]
            //   0fb67df4             | movzx               edi, byte ptr [ebp - 0xc]
            //   8a4e1a               | mov                 cl, byte ptr [esi + 0x1a]

        $sequence_5 = { 81e9003ca875 87d6 4e 46 87d6 81c1003ca875 }
            // n = 6, score = 100
            //   81e9003ca875         | sub                 ecx, 0x75a83c00
            //   87d6                 | xchg                esi, edx
            //   4e                   | dec                 esi
            //   46                   | inc                 esi
            //   87d6                 | xchg                esi, edx
            //   81c1003ca875         | add                 ecx, 0x75a83c00

        $sequence_6 = { 0fb6d2 f6820194410004 7406 8b10 41 }
            // n = 5, score = 100
            //   0fb6d2               | movzx               edx, dl
            //   f6820194410004       | test                byte ptr [edx + 0x419401], 4
            //   7406                 | je                  8
            //   8b10                 | mov                 edx, dword ptr [eax]
            //   41                   | inc                 ecx

        $sequence_7 = { c1c719 e8???????? 87f2 e8???????? 2bd5 }
            // n = 5, score = 100
            //   c1c719               | rol                 edi, 0x19
            //   e8????????           |                     
            //   87f2                 | xchg                edx, esi
            //   e8????????           |                     
            //   2bd5                 | sub                 edx, ebp

        $sequence_8 = { 891d???????? 4a 87d6 8915???????? 03f7 46 893d???????? }
            // n = 7, score = 100
            //   891d????????         |                     
            //   4a                   | dec                 edx
            //   87d6                 | xchg                esi, edx
            //   8915????????         |                     
            //   03f7                 | add                 esi, edi
            //   46                   | inc                 esi
            //   893d????????         |                     

        $sequence_9 = { 8b048588814100 234508 8b4e14 8d04c1 0fb64801 8b5004 83fa10 }
            // n = 7, score = 100
            //   8b048588814100       | mov                 eax, dword ptr [eax*4 + 0x418188]
            //   234508               | and                 eax, dword ptr [ebp + 8]
            //   8b4e14               | mov                 ecx, dword ptr [esi + 0x14]
            //   8d04c1               | lea                 eax, [ecx + eax*8]
            //   0fb64801             | movzx               ecx, byte ptr [eax + 1]
            //   8b5004               | mov                 edx, dword ptr [eax + 4]
            //   83fa10               | cmp                 edx, 0x10

    condition:
        7 of them and filesize < 294912
}