rule win_unidentified_076_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.unidentified_076."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.unidentified_076"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 0f95c3 488b6c2438 488b742440 488b7c2448 8bc3 488b5c2430 4883c420 }
            // n = 7, score = 100
            //   0f95c3               | mov                 byte ptr [eax + ebp], al
            //   488b6c2438           | inc                 esp
            //   488b742440           | add                 eax, esi
            //   488b7c2448           | inc                 ebp
            //   8bc3                 | cmp                 eax, dword ptr [esi + 0x194]
            //   488b5c2430           | jb                  0x1e90
            //   4883c420             | dec                 eax

        $sequence_1 = { 448bc3 49894628 488b87c8000000 8bd5 488b4810 49894e18 }
            // n = 6, score = 100
            //   448bc3               | call                dword ptr [eax + 0x7f0]
            //   49894628             | dec                 esp
            //   488b87c8000000       | mov                 eax, dword ptr [esp + 0xa0]
            //   8bd5                 | dec                 esp
            //   488b4810             | mov                 ecx, ebp
            //   49894e18             | dec                 eax

        $sequence_2 = { ff97f8000000 488bd8 4885c0 7508 418bf4 e9???????? }
            // n = 6, score = 100
            //   ff97f8000000         | inc                 ecx
            //   488bd8               | mov                 eax, 0x1ff
            //   4885c0               | dec                 eax
            //   7508                 | mov                 ecx, ebx
            //   418bf4               | inc                 esp
            //   e9????????           |                     

        $sequence_3 = { 488b87c8000000 33d2 488bce 448d4230 ff9020070000 488b87c8000000 }
            // n = 6, score = 100
            //   488b87c8000000       | mov                 ecx, eax
            //   33d2                 | jne                 0xbdb
            //   488bce               | dec                 eax
            //   448d4230             | mov                 eax, dword ptr [esi + 0xc8]
            //   ff9020070000         | call                dword ptr [eax + 0x150]
            //   488b87c8000000       | inc                 esp

        $sequence_4 = { e9???????? 8b473c 33c9 394764 8d5101 0f43ca 4533e4 }
            // n = 7, score = 100
            //   e9????????           |                     
            //   8b473c               | mov                 esi, ecx
            //   33c9                 | dec                 eax
            //   394764               | mov                 dword ptr [esp + 0x30], ecx
            //   8d5101               | dec                 eax
            //   0f43ca               | mov                 dword ptr [eax + 8], ecx
            //   4533e4               | inc                 esp

        $sequence_5 = { 488b8bb00a0000 4885c9 7413 4c8b83c8000000 ba02000000 41ff90f0040000 488b93c8000000 }
            // n = 7, score = 100
            //   488b8bb00a0000       | mov                 ecx, esi
            //   4885c9               | inc                 esp
            //   7413                 | mov                 ecx, eax
            //   4c8b83c8000000       | dec                 eax
            //   ba02000000           | mov                 eax, dword ptr [esi + 0xc8]
            //   41ff90f0040000       | mov                 edx, dword ptr [eax + 8]
            //   488b93c8000000       | jmp                 0x2f0

        $sequence_6 = { 488bcf 03c0 41898638040000 e8???????? 498d962c010000 488bcf e8???????? }
            // n = 7, score = 100
            //   488bcf               | dec                 eax
            //   03c0                 | idiv                dword ptr [ebp + 0x20]
            //   41898638040000       | btr                 eax, 0x1f
            //   e8????????           |                     
            //   498d962c010000       | sub                 ebx, eax
            //   488bcf               | dec                 eax
            //   e8????????           |                     

        $sequence_7 = { 85c0 7e29 803c313b 740c 48ffc1 ffc2 }
            // n = 6, score = 100
            //   85c0                 | test                eax, eax
            //   7e29                 | je                  0x2e4
            //   803c313b             | inc                 esp
            //   740c                 | mov                 ecx, esi
            //   48ffc1               | call                dword ptr [edi + 0xf8]
            //   ffc2                 | dec                 eax

        $sequence_8 = { 488b8790000000 49891c24 498d5640 4989442408 488b8790000000 498d4c2440 }
            // n = 6, score = 100
            //   488b8790000000       | jne                 0xad2
            //   49891c24             | dec                 esp
            //   498d5640             | mov                 eax, edi
            //   4989442408           | dec                 eax
            //   488b8790000000       | mov                 ecx, esi
            //   498d4c2440           | test                eax, eax

        $sequence_9 = { 4885c9 7415 488b8308010000 33d2 41b800800000 ff9000010000 4889bbe0000000 }
            // n = 7, score = 100
            //   4885c9               | inc                 dword ptr [ebx + 0x64]
            //   7415                 | inc                 dword ptr [ebx + 0x18]
            //   488b8308010000       | dec                 eax
            //   33d2                 | mov                 dword ptr [ebx + 0xa0], edx
            //   41b800800000         | dec                 eax
            //   ff9000010000         | cmp                 edi, dword ptr [edi]
            //   4889bbe0000000       | dec                 eax

    condition:
        7 of them and filesize < 114688
}