rule win_unidentified_095_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2024-10-31"
        version = "1"
        description = "Detects win.unidentified_095."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.unidentified_095"
        malpedia_rule_date = "20241030"
        malpedia_hash = "26e26953c49c8efafbf72a38076855d578e0a2e4"
        malpedia_version = "20241030"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 448be0 e8???????? 85c0 0f84e3000000 4883cfff 488bdf 48ffc3 }
            // n = 7, score = 100
            //   448be0               | mov                 esp, dword ptr [esp + 0x258]
            //   e8????????           |                     
            //   85c0                 | dec                 eax
            //   0f84e3000000         | mov                 esi, dword ptr [esp + 0x98]
            //   4883cfff             | dec                 eax
            //   488bdf               | mov                 ebp, dword ptr [esp + 0x90]
            //   48ffc3               | je                  0x3a

        $sequence_1 = { eb04 1bc0 8903 bf01000000 ff15???????? 4c8b742438 85ed }
            // n = 7, score = 100
            //   eb04                 | test                eax, eax
            //   1bc0                 | je                  0x454
            //   8903                 | inc                 ecx
            //   bf01000000           | mov                 eax, 0x10000
            //   ff15????????         |                     
            //   4c8b742438           | dec                 eax
            //   85ed                 | mov                 edx, ebp

        $sequence_2 = { 4533db 498bd3 4c8d05b34dffff 4b8b8ce0a0450200 4803ca 48ffc2 46885cf13e }
            // n = 7, score = 100
            //   4533db               | jne                 0x442
            //   498bd3               | dec                 eax
            //   4c8d05b34dffff       | mov                 ecx, eax
            //   4b8b8ce0a0450200     | jmp                 0x3f5
            //   4803ca               | mov                 edi, 1
            //   48ffc2               | test                ebp, ebp
            //   46885cf13e           | dec                 eax

        $sequence_3 = { 41ffd6 be01000000 488bcf ff15???????? 4c8b742430 }
            // n = 5, score = 100
            //   41ffd6               | inc                 edx
            //   be01000000           | cmp                 byte ptr [eax + edi*8 + 0x39], bl
            //   488bcf               | jne                 0x1491
            //   ff15????????         |                     
            //   4c8b742430           | dec                 eax

        $sequence_4 = { 418be9 48c1f806 488d0da88e0100 4183e23f 4903e8 498bf0 }
            // n = 6, score = 100
            //   418be9               | dec                 eax
            //   48c1f806             | mov                 eax, dword ptr [ebx]
            //   488d0da88e0100       | dec                 eax
            //   4183e23f             | test                eax, eax
            //   4903e8               | je                  0xd2b
            //   498bf0               | dec                 eax

        $sequence_5 = { 4881c490000000 5d c3 4053 4883ec20 488bd9 }
            // n = 6, score = 100
            //   4881c490000000       | sar                 ebp, 6
            //   5d                   | dec                 ecx
            //   c3                   | mov                 eax, esi
            //   4053                 | dec                 esp
            //   4883ec20             | lea                 edi, [0xffff9bfb]
            //   488bd9               | dec                 ecx

        $sequence_6 = { 488d0dc2f30100 e8???????? 488b442428 488905???????? 488d442428 4883c008 488905???????? }
            // n = 7, score = 100
            //   488d0dc2f30100       | dec                 esp
            //   e8????????           |                     
            //   488b442428           | mov                 dword ptr [esp + 0x30], edi
            //   488905????????       |                     
            //   488d442428           | dec                 esp
            //   4883c008             | mov                 edi, ecx
            //   488905????????       |                     

        $sequence_7 = { 4883ec40 48897c2460 33ed 4c89642470 4d8be1 4c896c2478 4d8be8 }
            // n = 7, score = 100
            //   4883ec40             | xor                 edx, edx
            //   48897c2460           | dec                 eax
            //   33ed                 | mov                 ebp, ecx
            //   4c89642470           | xor                 edi, edi
            //   4d8be1               | xor                 ecx, ecx
            //   4c896c2478           | xor                 edx, edx
            //   4d8be8               | inc                 ecx

        $sequence_8 = { 894c2428 488d156a4f0100 4889442420 e8???????? e9???????? 89758f e9???????? }
            // n = 7, score = 100
            //   894c2428             | test                eax, eax
            //   488d156a4f0100       | je                  0x2f4
            //   4889442420           | inc                 ecx
            //   e8????????           |                     
            //   e9????????           |                     
            //   89758f               | mov                 eax, 0xb
            //   e9????????           |                     

        $sequence_9 = { 48894c2428 4885f6 0f848b000000 4533c0 488bd6 488bcb e8???????? }
            // n = 7, score = 100
            //   48894c2428           | lea                 edx, [ebp - 0x69]
            //   4885f6               | dec                 eax
            //   0f848b000000         | mov                 ecx, ebx
            //   4533c0               | dec                 eax
            //   488bd6               | lea                 ecx, [0xfffedea6]
            //   488bcb               | dec                 eax
            //   e8????????           |                     

    condition:
        7 of them and filesize < 339968
}